/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkHIST
extends PngChunkSingle {
    public static final String ID = "hIST";
    private int[] hist = new int[0];

    public PngChunkHIST(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT;
    }

    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images accept a HIST chunk");
        }
        int n2 = chunkRaw.data.length / 2;
        this.hist = new int[n2];
        for (int i2 = 0; i2 < this.hist.length; ++i2) {
            this.hist[i2] = PngHelperInternal.readInt2fromBytes(chunkRaw.data, i2 * 2);
        }
    }

    public ChunkRaw createRawChunk() {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images accept a HIST chunk");
        }
        ChunkRaw chunkRaw = null;
        chunkRaw = this.createEmptyChunk(this.hist.length * 2, true);
        for (int i2 = 0; i2 < this.hist.length; ++i2) {
            PngHelperInternal.writeInt2tobytes(this.hist[i2], chunkRaw.data, i2 * 2);
        }
        return chunkRaw;
    }

    public int[] getHist() {
        return this.hist;
    }

    public void setHist(int[] nArray) {
        this.hist = nArray;
    }
}

