/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.DeflatedChunksSet;
import ar.com.hjg.pngj.Deinterlacer;
import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.RowInfo;
import java.util.Arrays;
import java.util.zip.Checksum;
import java.util.zip.Inflater;

public class IdatSet
extends DeflatedChunksSet {
    protected byte[] rowUnfiltered;
    protected byte[] rowUnfilteredPrev;
    protected final ImageInfo imgInfo;
    protected final Deinterlacer deinterlacer;
    final RowInfo rowinfo;
    protected int[] filterUseStat = new int[5];

    public IdatSet(String string, ImageInfo imageInfo, Deinterlacer deinterlacer) {
        this(string, imageInfo, deinterlacer, null, null);
    }

    public IdatSet(String string, ImageInfo imageInfo, Deinterlacer deinterlacer, Inflater inflater, byte[] byArray) {
        super(string, deinterlacer != null ? deinterlacer.getBytesToRead() + 1 : imageInfo.bytesPerRow + 1, imageInfo.bytesPerRow + 1, inflater, byArray);
        this.imgInfo = imageInfo;
        this.deinterlacer = deinterlacer;
        this.rowinfo = new RowInfo(imageInfo, deinterlacer);
    }

    public void unfilterRow() {
        this.unfilterRow(this.rowinfo.bytesRow);
    }

    protected void unfilterRow(int n2) {
        if (this.rowUnfiltered == null || this.rowUnfiltered.length < this.row.length) {
            this.rowUnfiltered = new byte[this.row.length];
            this.rowUnfilteredPrev = new byte[this.row.length];
        }
        if (this.rowinfo.rowNsubImg == 0) {
            Arrays.fill(this.rowUnfiltered, (byte)0);
        }
        byte[] byArray = this.rowUnfiltered;
        this.rowUnfiltered = this.rowUnfilteredPrev;
        this.rowUnfilteredPrev = byArray;
        byte by2 = this.row[0];
        FilterType filterType = FilterType.getByVal(by2);
        if (filterType == null) {
            throw new PngjInputException("Filter type " + by2 + " invalid");
        }
        byte by3 = by2;
        this.filterUseStat[by3] = this.filterUseStat[by3] + 1;
        this.rowUnfiltered[0] = this.row[0];
        switch (filterType) {
            case FILTER_NONE: {
                this.unfilterRowNone(n2);
                break;
            }
            case FILTER_SUB: {
                this.unfilterRowSub(n2);
                break;
            }
            case FILTER_UP: {
                this.unfilterRowUp(n2);
                break;
            }
            case FILTER_AVERAGE: {
                this.unfilterRowAverage(n2);
                break;
            }
            case FILTER_PAETH: {
                this.unfilterRowPaeth(n2);
                break;
            }
            default: {
                throw new PngjInputException("Filter type " + by2 + " not implemented");
            }
        }
    }

    private void unfilterRowAverage(int n2) {
        int n3 = 1 - this.imgInfo.bytesPixel;
        int n4 = 1;
        while (n4 <= n2) {
            int n5 = n3 > 0 ? this.rowUnfiltered[n3] & 0xFF : 0;
            this.rowUnfiltered[n4] = (byte)(this.row[n4] + (n5 + (this.rowUnfilteredPrev[n4] & 0xFF)) / 2);
            ++n4;
            ++n3;
        }
    }

    private void unfilterRowNone(int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.rowUnfiltered[i2] = this.row[i2];
        }
    }

    private void unfilterRowPaeth(int n2) {
        int n3 = 1 - this.imgInfo.bytesPixel;
        int n4 = 1;
        while (n4 <= n2) {
            int n5 = n3 > 0 ? this.rowUnfiltered[n3] & 0xFF : 0;
            int n6 = n3 > 0 ? this.rowUnfilteredPrev[n3] & 0xFF : 0;
            this.rowUnfiltered[n4] = (byte)(this.row[n4] + PngHelperInternal.filterPaethPredictor(n5, this.rowUnfilteredPrev[n4] & 0xFF, n6));
            ++n4;
            ++n3;
        }
    }

    private void unfilterRowSub(int n2) {
        int n3;
        for (n3 = 1; n3 <= this.imgInfo.bytesPixel; ++n3) {
            this.rowUnfiltered[n3] = this.row[n3];
        }
        int n4 = 1;
        n3 = this.imgInfo.bytesPixel + 1;
        while (n3 <= n2) {
            this.rowUnfiltered[n3] = (byte)(this.row[n3] + this.rowUnfiltered[n4]);
            ++n3;
            ++n4;
        }
    }

    private void unfilterRowUp(int n2) {
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.rowUnfiltered[i2] = (byte)(this.row[i2] + this.rowUnfilteredPrev[i2]);
        }
    }

    protected void preProcessRow() {
        super.preProcessRow();
        this.rowinfo.update(this.getRown());
        this.unfilterRow();
        this.rowinfo.updateBuf(this.rowUnfiltered, this.rowinfo.bytesRow + 1);
    }

    protected int processRowCallback() {
        int n2 = this.advanceToNextRow();
        return n2;
    }

    protected void processDoneCallback() {
    }

    public int advanceToNextRow() {
        int n2;
        if (this.deinterlacer == null) {
            n2 = this.getRown() >= this.imgInfo.rows - 1 ? 0 : this.imgInfo.bytesPerRow + 1;
        } else {
            boolean bl2 = this.deinterlacer.nextRow();
            int n3 = n2 = bl2 ? this.deinterlacer.getBytesToRead() + 1 : 0;
        }
        if (!this.isCallbackMode()) {
            this.prepareForNextRow(n2);
        }
        return n2;
    }

    public boolean isRowReady() {
        return !this.isWaitingForMoreInput();
    }

    public byte[] getUnfilteredRow() {
        return this.rowUnfiltered;
    }

    public Deinterlacer getDeinterlacer() {
        return this.deinterlacer;
    }

    void updateCrcs(Checksum ... checksumArray) {
        for (Checksum checksum : checksumArray) {
            if (checksum == null) continue;
            checksum.update(this.getUnfilteredRow(), 1, this.getRowFilled() - 1);
        }
    }

    public void close() {
        super.close();
        this.rowUnfiltered = null;
        this.rowUnfilteredPrev = null;
    }

    public int[] getFilterUseStat() {
        return this.filterUseStat;
    }
}

