/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjExceptionInternal;

public class Deinterlacer {
    final ImageInfo imi;
    private int pass;
    private int rows;
    private int cols;
    int dY;
    int dX;
    int oY;
    int oX;
    int oXsamples;
    int dXsamples;
    private int currRowSubimg = -1;
    private int currRowReal = -1;
    private int currRowSeq;
    int totalRows = 0;
    private boolean ended = false;

    public Deinterlacer(ImageInfo imageInfo) {
        this.imi = imageInfo;
        this.pass = 0;
        this.currRowSeq = 0;
        this.setPass(1);
        this.setRow(0);
    }

    private void setRow(int n2) {
        this.currRowSubimg = n2;
        this.currRowReal = n2 * this.dY + this.oY;
        if (this.currRowReal < 0 || this.currRowReal >= this.imi.rows) {
            throw new PngjExceptionInternal("bad row - this should not happen");
        }
    }

    boolean nextRow() {
        ++this.currRowSeq;
        if (this.rows == 0 || this.currRowSubimg >= this.rows - 1) {
            if (this.pass == 7) {
                this.ended = true;
                return false;
            }
            this.setPass(this.pass + 1);
            if (this.rows == 0) {
                --this.currRowSeq;
                return this.nextRow();
            }
            this.setRow(0);
        } else {
            this.setRow(this.currRowSubimg + 1);
        }
        return true;
    }

    boolean isEnded() {
        return this.ended;
    }

    void setPass(int n2) {
        if (this.pass == n2) {
            return;
        }
        this.pass = n2;
        byte[] byArray = Deinterlacer.paramsForPass(n2);
        this.dX = byArray[0];
        this.dY = byArray[1];
        this.oX = byArray[2];
        this.oY = byArray[3];
        this.rows = this.imi.rows > this.oY ? (this.imi.rows + this.dY - 1 - this.oY) / this.dY : 0;
        int n3 = this.cols = this.imi.cols > this.oX ? (this.imi.cols + this.dX - 1 - this.oX) / this.dX : 0;
        if (this.cols == 0) {
            this.rows = 0;
        }
        this.dXsamples = this.dX * this.imi.channels;
        this.oXsamples = this.oX * this.imi.channels;
    }

    static byte[] paramsForPass(int n2) {
        switch (n2) {
            case 1: {
                return new byte[]{8, 8, 0, 0};
            }
            case 2: {
                return new byte[]{8, 8, 4, 0};
            }
            case 3: {
                return new byte[]{4, 8, 0, 4};
            }
            case 4: {
                return new byte[]{4, 4, 2, 0};
            }
            case 5: {
                return new byte[]{2, 4, 0, 2};
            }
            case 6: {
                return new byte[]{2, 2, 1, 0};
            }
            case 7: {
                return new byte[]{1, 2, 0, 1};
            }
        }
        throw new PngjExceptionInternal("bad interlace pass" + n2);
    }

    int getCurrRowSubimg() {
        return this.currRowSubimg;
    }

    int getCurrRowReal() {
        return this.currRowReal;
    }

    int getPass() {
        return this.pass;
    }

    int getRows() {
        return this.rows;
    }

    int getCols() {
        return this.cols;
    }

    public int getPixelsToRead() {
        return this.getCols();
    }

    public int getBytesToRead() {
        return (this.imi.bitspPixel * this.getPixelsToRead() + 7) / 8;
    }

    public int getdY() {
        return this.dY;
    }

    public int getdX() {
        return this.dX;
    }

    public int getoY() {
        return this.oY;
    }

    public int getoX() {
        return this.oX;
    }

    public int getTotalRows() {
        if (this.totalRows == 0) {
            for (int i2 = 1; i2 <= 7; ++i2) {
                int n2;
                byte[] byArray = Deinterlacer.paramsForPass(i2);
                int n3 = this.imi.rows > byArray[3] ? (this.imi.rows + byArray[1] - 1 - byArray[3]) / byArray[1] : 0;
                int n4 = n2 = this.imi.cols > byArray[2] ? (this.imi.cols + byArray[0] - 1 - byArray[2]) / byArray[0] : 0;
                if (n3 <= 0 || n2 <= 0) continue;
                this.totalRows += n3;
            }
        }
        return this.totalRows;
    }

    public long getTotalRawBytes() {
        long l2 = 0L;
        for (int i2 = 1; i2 <= 7; ++i2) {
            byte[] byArray = Deinterlacer.paramsForPass(i2);
            int n2 = this.imi.rows > byArray[3] ? (this.imi.rows + byArray[1] - 1 - byArray[3]) / byArray[1] : 0;
            int n3 = this.imi.cols > byArray[2] ? (this.imi.cols + byArray[0] - 1 - byArray[2]) / byArray[0] : 0;
            int n4 = (this.imi.bitspPixel * n3 + 7) / 8;
            if (n2 <= 0 || n3 <= 0) continue;
            l2 += (long)n2 * (1L + (long)n4);
        }
        return l2;
    }

    public int getCurrRowSeq() {
        return this.currRowSeq;
    }
}

