/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.teachrepeat.state;

import lombok.Generated;
import us.hebi.gui.lib.bfh;
import us.hebi.gui.lib.bfi;
import us.hebi.gui.lib.blm;
import us.hebi.gui.views.teachrepeat.state.Waypoint$Type;

public abstract class Waypoint {
    public double time = Double.NaN;
    public final int numJoints;
    private static final Runnable NO_OP = () -> {};
    private Runnable onChange = NO_OP;

    public static Waypoint newMove(int n2) {
        return new bfi(n2).a(false);
    }

    public static Waypoint newStop(int n2) {
        return new bfi(n2).a(true);
    }

    public static Waypoint newIdle(int n2) {
        return new bfh(n2);
    }

    public Waypoint(int n2) {
        this.numJoints = n2;
    }

    public Waypoint setTime(double d2) {
        if (this.time != d2) {
            this.time = d2;
            return this.changed();
        }
        return this;
    }

    public abstract Waypoint$Type getType();

    public double[] getPositions() {
        return this.getPositions(null);
    }

    public double[] getPositions(double[] dArray) {
        if (dArray == null || dArray.length != this.getNumJoints()) {
            dArray = new double[this.getNumJoints()];
        }
        for (int i2 = 0; i2 < this.getNumJoints(); ++i2) {
            dArray[i2] = this.getPosition(i2);
        }
        return dArray;
    }

    public abstract boolean setPosition(int var1, double var2);

    public abstract double getPosition(int var1);

    public abstract boolean setVelocity(int var1, double var2);

    public abstract double getVelocity(int var1);

    public abstract boolean setAcceleration(int var1, double var2);

    public abstract double getAcceleration(int var1);

    public Waypoint setPositions(double ... dArray) {
        blm.a(this.getNumJoints() == dArray.length, "number of joints mismatch");
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            this.setPosition(i2, dArray[i2]);
        }
        return this;
    }

    public void setOnChange(Runnable runnable) {
        this.onChange = runnable;
    }

    public void clearOnChange() {
        this.onChange = NO_OP;
    }

    public Waypoint changed() {
        this.onChange.run();
        return this;
    }

    public String toString() {
        return String.format("%5.2fs \t %s", new Object[]{this.getTime(), this.getType()});
    }

    @Generated
    public double getTime() {
        return this.time;
    }

    @Generated
    public int getNumJoints() {
        return this.numJoints;
    }
}

