/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.motordriver;

import java.io.File;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ToggleButton;
import javax.inject.Inject;
import us.hebi.gui.lib.ade;
import us.hebi.gui.lib.aee;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.ayn;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.views.scope.dialogs.BasicFxmlDialog;

public class SaveMotorDriverXmlDialog
extends BasicFxmlDialog {
    @FXML
    private ToggleButton adcOffsetsToggle;
    @FXML
    private ToggleButton encoderOffsetsToggle;
    @FXML
    private Button saveButton;
    @Inject
    ayn fileChooser;
    @Inject
    awh notificationService;

    public SaveMotorDriverXmlDialog() {
        super("savemotordriverxml.fxml");
    }

    @FXML
    void initialize() {
        bdc.a((Property)this.adcOffsetsToggle.selectedProperty(), this.properties.getBoolean("SAVE_ADC_OFFSETS", false));
        bdc.a((Property)this.encoderOffsetsToggle.selectedProperty(), this.properties.getBoolean("SAVE_ENCODER_OFFSETS", false));
    }

    public void setContent(aee aee2) {
        this.saveButton.setOnAction(actionEvent -> {
            File file = this.fileChooser.g(bdc.a(actionEvent));
            if (file == null) {
                return;
            }
            if (!this.adcOffsetsToggle.isSelected()) {
                aee2.setBoardCalibration(null);
            }
            if (!this.encoderOffsetsToggle.isSelected()) {
                Optional.ofNullable(aee2.getEncoders().getEncoderA1()).ifPresent(adm2 -> adm2.setCalibrationOffset(null));
                Optional.ofNullable(aee2.getEncoders().getEncoderA2()).ifPresent(adm2 -> adm2.setCalibrationOffset(null));
                Optional.ofNullable(aee2.getEncoders().getEncoderB1()).ifPresent(adm2 -> adm2.setCalibrationOffset(null));
                Optional.ofNullable(aee2.getEncoders().getEncoderB2()).ifPresent(adm2 -> adm2.setCalibrationOffset(null));
            }
            try {
                new ade().writeXml(aee2, file);
                return;
            }
            catch (Exception exception) {
                this.notificationService.f(exception);
                return;
            }
        });
    }
}

