/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.convertlog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.inject.Inject;
import us.hebi.gui.lib.aaj;
import us.hebi.gui.lib.aak;
import us.hebi.gui.lib.aao;
import us.hebi.gui.lib.apd;
import us.hebi.gui.lib.aup;
import us.hebi.gui.lib.awg;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bfc;
import us.hebi.gui.lib.bs;

public class ConvertLogPresenter {
    @FXML
    private ToggleButton formatToggleMat;
    @FXML
    private ToggleGroup outputFormat;
    @FXML
    private ToggleButton formatToggleCsv;
    @FXML
    private ToggleButton viewToggleFull;
    @FXML
    private ToggleGroup outputView;
    @FXML
    private ToggleButton viewToggleIO;
    @FXML
    private ToggleButton viewToggleMobile;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Button convertBtn;
    @FXML
    private Button closeBtn;
    private static final bfc INVALID_CONVERTER = new bfc(apd2 -> Boolean.FALSE, apd2 -> {
        throw new IllegalStateException("Not a valid converter");
    });
    @Inject
    String logPath;
    @Inject
    aup properties;
    ObjectBinding<bfc> selectedFormat;
    ObjectBinding<apd> selectedView;
    BooleanProperty conversionInProgress = new SimpleBooleanProperty(false);
    final FileChooser outputFileChooser = new FileChooser();

    @FXML
    void initialize() {
        bdc.a(this.outputFormat);
        this.formatToggleMat.setUserData((Object)new bfc(aao::a, aao::a));
        this.formatToggleCsv.setUserData((Object)new bfc(aak::a, aak::a));
        this.selectedFormat = Bindings.createObjectBinding(() -> {
            Toggle toggle = this.outputFormat.getSelectedToggle();
            if (toggle == null || toggle.getUserData() == null) {
                return INVALID_CONVERTER;
            }
            return (bfc)toggle.getUserData();
        }, (Observable[])new Observable[]{this.outputFormat.selectedToggleProperty()});
        bdc.a(this.outputView);
        this.viewToggleFull.setUserData((Object)apd.c);
        this.viewToggleIO.setUserData((Object)apd.e);
        this.viewToggleMobile.setUserData((Object)apd.f);
        this.selectedView = Bindings.createObjectBinding(() -> {
            Toggle toggle = this.outputView.getSelectedToggle();
            if (toggle == null || toggle.getUserData() == null) {
                return apd.c;
            }
            return (apd)((Object)((Object)toggle.getUserData()));
        }, (Observable[])new Observable[]{this.outputView.selectedToggleProperty()});
        this.selectedFormat.addListener(observable -> this.disableUnsupportedViews());
        BooleanBinding booleanBinding = Bindings.createBooleanBinding(() -> ((bfc)this.selectedFormat.get()).h.apply((apd)((Object)((Object)this.selectedView.get()))) == false, (Observable[])new Observable[]{this.selectedFormat, this.selectedView});
        this.convertBtn.disableProperty().bind((ObservableValue)booleanBinding.or((ObservableBooleanValue)this.conversionInProgress));
        this.closeBtn.disableProperty().bind((ObservableValue)this.conversionInProgress);
        this.formatToggleMat.getParent().getParent().disableProperty().bind((ObservableValue)this.conversionInProgress);
        this.viewToggleFull.getParent().getParent().disableProperty().bind((ObservableValue)this.conversionInProgress);
        this.progressBar.setProgress(0.0);
        this.progressBar.visibleProperty().bind((ObservableValue)this.progressBar.progressProperty().isNotEqualTo(0));
        this.progressBar.managedProperty().bind((ObservableValue)this.progressBar.visibleProperty());
    }

    private void disableUnsupportedViews() {
        for (Toggle toggle : this.outputView.getToggles()) {
            ((ToggleButton)toggle).setDisable(((bfc)this.selectedFormat.get()).h.apply((apd)((Object)toggle.getUserData())) == false);
        }
    }

    public Button getCloseButton() {
        return this.closeBtn;
    }

    @FXML
    void convertLog(ActionEvent actionEvent) {
        Window window = this.getCloseButton().getScene().getWindow();
        ArrayList<FileChooser.ExtensionFilter> arrayList = new ArrayList<FileChooser.ExtensionFilter>();
        String string = "";
        if (this.formatToggleMat.isSelected()) {
            arrayList.add(new FileChooser.ExtensionFilter("MAT Files", new String[]{"*.mat"}));
            string = ".mat";
        }
        if (this.formatToggleCsv.isSelected()) {
            arrayList.add(new FileChooser.ExtensionFilter("CSV Files", new String[]{"*.csv"}));
            string = ".csv";
        }
        arrayList.add(new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"}));
        File file2 = new File(this.logPath);
        this.outputFileChooser.setTitle("Choose output file");
        bdc.a(this.outputFileChooser, file2.getParentFile());
        this.outputFileChooser.setInitialFileName(bs.a(this.logPath));
        this.outputFileChooser.getExtensionFilters().setAll(arrayList);
        File file3 = this.outputFileChooser.showSaveDialog(bdc.a(actionEvent));
        if (file3 == null) {
            return;
        }
        aaj<File> aaj2 = ((bfc)this.selectedFormat.get()).i.apply((apd)((Object)this.selectedView.get()));
        this.conversionInProgress.setValue(Boolean.TRUE);
        this.progressBar.setProgress(-1.0);
        String string2 = file3.getAbsolutePath();
        if (string2.endsWith(string)) {
            string2 = string2.substring(0, string2.length() - string.length());
        }
        String string3 = string2;
        CompletableFuture.supplyAsync(() -> {
            try {
                return (File)aaj2.a(file2, string3);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }).whenCompleteAsync((file, throwable) -> {
            if (throwable != null) {
                awg.a(throwable.getMessage(), window);
            } else {
                awg.a(file, window);
            }
            this.conversionInProgress.setValue(Boolean.FALSE);
            this.progressBar.setProgress(1.0);
        }, bdc.b);
    }
}

