/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.calibrate;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.dataset.DataSet;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Parent;
import us.hebi.gui.lib.ahg;
import us.hebi.gui.lib.ajr;
import us.hebi.gui.lib.apr;
import us.hebi.gui.lib.arc;
import us.hebi.gui.lib.aua;
import us.hebi.gui.lib.aug;
import us.hebi.gui.lib.auh;
import us.hebi.gui.lib.axx;
import us.hebi.gui.lib.axy;
import us.hebi.gui.lib.ayf;
import us.hebi.gui.lib.ayg;
import us.hebi.gui.lib.ayk;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.bak;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bix;
import us.hebi.gui.lib.bjg;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationResultDialog;

public class MotorEncoderCalibrationDialog
extends CalibrationDialog<ayk> {
    ReadOnlyObjectProperty<ajr> motorEncoder;
    ReadOnlyObjectProperty<ayg> calibrationAction;
    DoubleBinding idCmd;
    DoubleBinding poleSweepTime;
    ReadOnlyDoubleProperty numPolePairs;

    @Override
    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        super.initialize(uRL, resourceBundle);
        this.setTitle("Calibrate motor encoder");
        this.calibrationAction = this.addEnumParameter("Action", List.of(ayg.values()), ayg.Calibrate, "Verify runs the calibration process with the existing table");
        List<ajr> list = List.of(ajr.c, ajr.d, ajr.e, ajr.f);
        Object object = this.device.getInfo();
        object = ((aua)object).a;
        this.motorEncoder = this.addEnumParameter("Motor Encoder", list, ((aug)object).a.a(), "The port used for the encoder");
        this.idCmd = this.addDoubleParameter("FOC Id [A]", 1.0, "If the motor doesn't move, or doesn\u2019t move smoothly, this should be increased. Be careful to make sure this value stays at or below the current rating for your motor.");
        this.poleSweepTime = this.addDoubleParameter("Pole sweep time", 1.5, "Time spent per pole [s]");
        object = this.device.getInfo();
        object = ((aua)object).a;
        object = ((aug)object).a;
        this.numPolePairs = ((auh)object).cv;
    }

    @Override
    protected void sendPersistAllAsync() throws IOException {
        Optional.ofNullable((ayk)this.result.get()).map(ayk::a).ifPresent(axy2 -> axy2.c((ahg)this.device.getDeviceAddress().get()));
    }

    private axx subsample(axx axx2, int n2) {
        if (axx2.getNumSamples() < n2) {
            return axx2;
        }
        axx axx3 = new axx().a(n2);
        int n3 = axx2.getNumSamples() / n2;
        for (int i2 = 0; i2 < axx2.getNumSamples() && axx3.getNumSamples() <= n2; i2 += n3) {
            axx3.c(axx2.c(i2), axx2.d(i2));
        }
        return axx3;
    }

    @Override
    protected void fillResultGrid(ayk ayk2) {
        axx axx2;
        axx axx3 = this.subsample(ayk2.e, 2000);
        String string = Math.abs(axx2.h()[0]) < 1.0E-4 ? "Wrong encoder" : (!axx3.ay() ? "Bad fit" : (axx3.h()[1] < 0.0 ? "Wrong direction" : "Ok"));
        this.addChart(MotorEncoderCalibrationDialog.createPrimaryChart(ayk2));
        this.addResult("Linear fit", axx3.dl(), string);
        this.addResult("Offset (1 rotation)", apr.d(ayk2.dB), "[rad]");
        this.addResult("Offset (+/- 0.5 rotation)", apr.d(ayk2.dC), "[rad]");
    }

    private static bak toDataSet(String string, axy axy2) {
        return (bak)new bak(string, axy2::K, n2 -> arc.i(axy2.f(n2)), n2 -> arc.i(axy2.g(n2))).addStyleClasses(new String[]{bat.c.D()});
    }

    private static XYChart createChartWithAxes() {
        XYChart xYChart = azk.c();
        xYChart.getXAxis().setName("Commanded Rotor Position Offset");
        xYChart.getXAxis().setUnit("deg");
        xYChart.getYAxis().setName("Encoder Position");
        xYChart.getYAxis().setUnit("deg");
        return xYChart;
    }

    public static XYChart createPrimaryChart(ayk ayk2) {
        XYChart xYChart = MotorEncoderCalibrationDialog.createChartWithAxes();
        xYChart.getDatasets().add((Object)new bak("Samples", ayk2.e::getNumSamples, n2 -> arc.i(bix.a(true, ayk2.e.c(n2))), n2 -> arc.i(ayk2.e.e(n2))).addStyleClasses(new String[]{bat.c.D()}));
        xYChart.getDatasets().addAll((Object[])new DataSet[]{MotorEncoderCalibrationDialog.toDataSet("Forward table", ayk2.b), MotorEncoderCalibrationDialog.toDataSet("Backward table", ayk2.c), MotorEncoderCalibrationDialog.toDataSet("Combined table", ayk2.a())});
        double[] dArray = bix.a(0.0, Math.PI * 2, 4096);
        xYChart.getDatasets().add((Object)new bak("Offset", () -> dArray.length, n2 -> arc.i(dArray[n2]), n2 -> arc.i(ayk2.a().q(dArray[n2]))).addStyleClasses(new String[]{bat.a.D()}));
        return xYChart;
    }

    public static XYChart createSecondaryChart(ayk ayk2) {
        axy axy2 = ayk2.a();
        axx axx2 = ayk2.e;
        XYChart xYChart = MotorEncoderCalibrationDialog.createChartWithAxes();
        Object[] objectArray = new DataSet[3];
        objectArray[0] = new bak("Forward delta", axy2::K, n2 -> arc.i(axy2.f(n2)), n2 -> arc.i(ayk2.b.g(n2) - axy2.g(n2))).addStyleClasses(new String[]{bat.c.D()});
        objectArray[1] = new bak("Backward delta", axy2::K, n2 -> arc.i(axy2.f(n2)), n2 -> arc.i(ayk2.c.g(n2) - axy2.g(n2))).addStyleClasses(new String[]{bat.c.D()});
        objectArray[2] = new bak("Corrected samples", axx2::getNumSamples, n2 -> arc.i(bix.a(true, axx2.c(n2))), n2 -> arc.i(axx2.e(n2) - axy2.q(axx2.c(n2)))).addStyleClasses(new String[]{bat.c.D()});
        xYChart.getDatasets().addAll(objectArray);
        return xYChart;
    }

    @Override
    protected Parent renderResult(ayk ayk2) {
        CalibrationResultDialog calibrationResultDialog = new CalibrationResultDialog();
        calibrationResultDialog.setPrimaryChart(MotorEncoderCalibrationDialog.createPrimaryChart(ayk2));
        calibrationResultDialog.setSecondaryChart(MotorEncoderCalibrationDialog.createSecondaryChart(ayk2));
        if (ayk2.cH > 0) {
            calibrationResultDialog.addResult("Missing Data", ayk2.cH, "[buckets]");
        }
        calibrationResultDialog.addResult("Raw Offset", ayk2.dA, "[rad]");
        calibrationResultDialog.addResult("Offset (1 rotation)", ayk2.dC, "[rad]");
        calibrationResultDialog.addResult("Offset (1 pole)", ayk2.dE, "[rad]");
        calibrationResultDialog.setMatFileSupplier(() -> ayk2.a().a("motorEncoder", bjg.a(String.valueOf(this.motorEncoder))).a("idCmd", bjg.a(this.idCmd.get())).a("poleSweepTime", bjg.a(this.poleSweepTime.get())).a("numPolePairs", bjg.a(this.numPolePairs.get())));
        calibrationResultDialog.setPrefHeight(900.0);
        calibrationResultDialog.setPrefWidth(900.0);
        return calibrationResultDialog;
    }

    @Override
    protected Callable<ayk> createTask(ahg ahg2) {
        ayf ayf2 = new ayf(ahg2, (ajr)((Object)((Object)this.motorEncoder.get())), this.idCmd.get(), this.poleSweepTime.get(), (int)this.numPolePairs.get(), (ayg)((Object)((Object)this.calibrationAction.get())));
        MotorEncoderCalibrationDialog motorEncoderCalibrationDialog = this;
        new ayf(ahg2, (ajr)((Object)((Object)this.motorEncoder.get())), this.idCmd.get(), this.poleSweepTime.get(), (int)this.numPolePairs.get(), (ayg)((Object)((Object)this.calibrationAction.get()))).a = motorEncoderCalibrationDialog;
        return ayf2;
    }
}

