/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.calibrate;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.dataset.DataSet;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Parent;
import us.hebi.gui.lib.ahg;
import us.hebi.gui.lib.aif;
import us.hebi.gui.lib.apr;
import us.hebi.gui.lib.axv;
import us.hebi.gui.lib.axw;
import us.hebi.gui.lib.axx;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.bak;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.jc;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationResultDialog;

public class AdcCalibrationDialog
extends CalibrationDialog<axw> {
    ReadOnlyObjectProperty<aif> controlStrategy;
    DoubleBinding baseOffset;
    DoubleBinding sampleRange;
    DoubleBinding numSamples;

    @Override
    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        super.initialize(uRL, resourceBundle);
        this.setTitle("Calibrate ADC offsets");
        List<aif> list = Arrays.stream(aif.values()).filter(aif2 -> aif2 != aif.a).toList();
        this.controlStrategy = this.addEnumParameter("Control strategy", list, aif.b, "The strategy that the adc should be calibrated in. We recommend using 'Off'. The strategy will not be reset afterwards.");
        this.baseOffset = this.addDoubleParameter("Base offset", 38.0, "center base");
        this.sampleRange = this.addDoubleParameter("Sample range", 4.0, "searches base offset +/- sample range");
        this.numSamples = this.addDoubleParameter("# Samples", 200.0, "number of samples");
    }

    @Override
    protected void fillResultGrid(axw axw2) {
        this.addResult("I a", axw2.a);
        this.addResult("I b", axw2.b);
        this.addResult("I c", axw2.c);
        this.addResult("I bus", axw2.d);
    }

    private void addResult(String string, axx axx2) {
        this.addResult(string, apr.c(axx2.h()[0]), this.getComment(axx2));
    }

    private String getComment(axx axx2) {
        if (!axx2.ay()) {
            return "Bad fit: " + axx2.dl();
        }
        return "Ok";
    }

    @Override
    protected Parent renderResult(axw axw2) {
        XYChart xYChart = azk.c();
        xYChart.setTitle("Phase Current");
        xYChart.getXAxis().setName("Offset");
        xYChart.getYAxis().setName("Current");
        xYChart.getYAxis().setUnit("A");
        DataSet dataSet = AdcCalibrationDialog.wrap("A", axw2.a);
        DataSet dataSet2 = AdcCalibrationDialog.wrap("B", axw2.b);
        DataSet dataSet3 = AdcCalibrationDialog.wrap("C", axw2.c);
        xYChart.getDatasets().addAll((Object[])new DataSet[]{dataSet, dataSet2, dataSet3});
        azk.a(xYChart, "A", axw2.Q);
        azk.a(xYChart, "B", axw2.R);
        azk.a(xYChart, "C", axw2.S);
        azk.a(xYChart);
        XYChart xYChart2 = azk.c();
        xYChart2.setTitle("Bus Current");
        xYChart2.getXAxis().setName("Offset");
        xYChart2.getYAxis().setName("Current");
        xYChart2.getYAxis().setUnit("A");
        DataSet dataSet4 = AdcCalibrationDialog.wrap("Bus", axw2.d);
        xYChart2.getDatasets().add((Object)dataSet4);
        azk.a(xYChart2, null, axw2.T);
        azk.a(xYChart2);
        CalibrationResultDialog calibrationResultDialog = new CalibrationResultDialog();
        calibrationResultDialog.setPrimaryChart(xYChart);
        calibrationResultDialog.setSecondaryChart(xYChart2);
        calibrationResultDialog.addResult("Offset A", axw2.a.h()[0], this.getComment(axw2.a));
        calibrationResultDialog.addResult("Offset B", axw2.b.h()[0], this.getComment(axw2.b));
        calibrationResultDialog.addResult("Offset C", axw2.c.h()[0], this.getComment(axw2.c));
        calibrationResultDialog.addResult("Offset Bus", axw2.d.h()[0], this.getComment(axw2.d));
        return calibrationResultDialog;
    }

    private static DataSet wrap(String string, axx axx2) {
        return new bak(string, axx2::getNumSamples, axx2::c, axx2::d).addStyleClasses(new String[]{bat.c.D()});
    }

    private static DataSet wrapCoeffs(axx axx2) {
        jc jc2 = new jc(100);
        jc jc3 = new jc(100);
        axx2.h();
        return new bak("coeffs", jc2, jc3).addStyleClasses(new String[]{bat.c.D()});
    }

    @Override
    protected Callable<axw> createTask(ahg ahg2) {
        axv axv2 = new axv(ahg2, (aif)((Object)((Object)this.controlStrategy.get())), this.numSamples.intValue(), this.baseOffset.floatValue(), this.sampleRange.floatValue());
        AdcCalibrationDialog adcCalibrationDialog = this;
        new axv(ahg2, (aif)((Object)((Object)this.controlStrategy.get())), this.numSamples.intValue(), this.baseOffset.floatValue(), this.sampleRange.floatValue()).a = adcCalibrationDialog;
        return axv2;
    }
}

