/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.control.TextField;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.TextUtil;
import us.hebi.gui.lib.ac;
import us.hebi.gui.lib.ahg;
import us.hebi.gui.lib.do;
import us.hebi.gui.lib.dr;

public final class ParseUtils {
    public static final String DEFAULT_DOUBLE_FORMAT = "%.3f";
    private static final String DEFAULT_GAIN_DOUBLE_FORMAT = "%.2f";
    private static final String I_TERM_DOUBLE_FORMAT = "%.1f";
    private static final String D_TERM_DOUBLE_FORMAT = "%.4f";
    public static final Validator<String> IPV4_VALIDATOR = (control, string) -> {
        boolean bl2 = do.b(string);
        return ValidationResult.fromErrorIf(control, "Expected IPv4 address", !bl2);
    };
    public static final Validator<String> FINITE_DOUBLE_VALIDATOR = (control, string) -> {
        boolean bl2 = ac.a(string) || ParseUtils.tryParseFiniteDouble(string) != null;
        return ValidationResult.fromErrorIf(control, "Expected finite number", !bl2);
    };
    public static final Validator<String> NON_NAN_DOUBLE_VALIDATOR = (control, string) -> {
        boolean bl2 = ac.a(string) || ParseUtils.tryParseNonNanDouble(string) != null;
        return ValidationResult.fromErrorIf(control, "Value cannot be NaN", !bl2);
    };
    public static final Validator<String> INTEGER_VALIDATOR = (control, string) -> {
        boolean bl2 = ac.a(string) || ParseUtils.tryParseInteger(string) != null;
        return ValidationResult.fromErrorIf(control, "Value must be an integer", !bl2);
    };
    private static final Double ZERO = 0.0;
    public static final Validator<String> ONLY_ZERO_VALIDATOR = (control, string) -> {
        boolean bl2 = ac.a(string) || ZERO.equals(ParseUtils.tryParseNonNanDouble(string));
        return ValidationResult.fromErrorIf(control, "Value must be zero", !bl2);
    };

    private ParseUtils() {
    }

    public static Optional<InetAddress> toInet4Address(String string) {
        if (do.b(string)) {
            return Optional.of(do.a(string));
        }
        return Optional.empty();
    }

    public static String asString(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.getHostAddress();
    }

    public static String asString(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.toString().substring(1);
    }

    public static String asString(ahg ahg2) {
        if (ahg2 == null) {
            return null;
        }
        return ahg2.toString().substring(1);
    }

    public static StringBinding asInet4Address(ObservableObjectValue<InetAddress> observableObjectValue) {
        return Bindings.createStringBinding(() -> ParseUtils.asString((InetAddress)observableObjectValue.get()), (Observable[])new Observable[]{observableObjectValue});
    }

    public static StringBinding asDeviceAddressString(ObservableObjectValue<ahg> observableObjectValue) {
        return Bindings.createStringBinding(() -> ParseUtils.asString((ahg)observableObjectValue.get()), (Observable[])new Observable[]{observableObjectValue});
    }

    public static BooleanBinding isNaN(ObservableDoubleValue observableDoubleValue) {
        return Bindings.createBooleanBinding(() -> Double.isNaN(observableDoubleValue.get()), (Observable[])new Observable[]{observableDoubleValue});
    }

    public static StringExpression asFormattedString(ReadOnlyDoubleProperty readOnlyDoubleProperty) {
        return Bindings.createStringBinding(() -> TextUtil.format4digitsWithoutZeros(readOnlyDoubleProperty.get()), (Observable[])new Observable[]{readOnlyDoubleProperty});
    }

    public static StringBinding asFormattedString(ReadOnlyDoubleProperty readOnlyDoubleProperty, String string) {
        return Bindings.createStringBinding(() -> ParseUtils.lambda$asFormattedString$4(ParseUtils.createDecimalFormat(string), readOnlyDoubleProperty), (Observable[])new Observable[]{readOnlyDoubleProperty});
    }

    private static DecimalFormat createDecimalFormat(String string) {
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)DecimalFormatSymbols.getInstance(Locale.US).clone();
        decimalFormatSymbols.setInfinity("Inf");
        decimalFormatSymbols.setNaN("NaN");
        return new DecimalFormat(string, decimalFormatSymbols);
    }

    public static Double tryParseFiniteDouble(TextField textField) {
        return ParseUtils.tryParseFiniteDouble(textField.getText());
    }

    public static Double tryParseNonNanDouble(TextField textField) {
        return ParseUtils.tryParseNonNanDouble(textField.getText());
    }

    public static Double tryParseFiniteDouble(String string) {
        Double d2 = dr.a(string);
        if (d2 == null || !Double.isFinite(d2)) {
            return null;
        }
        return d2;
    }

    public static Double tryParseNonNanDouble(String string) {
        if ("-inf".equalsIgnoreCase(string) || "-infinity".equalsIgnoreCase(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("inf".equalsIgnoreCase(string) || "infinity".equalsIgnoreCase(string)) {
            return Double.POSITIVE_INFINITY;
        }
        return ParseUtils.tryParseFiniteDouble(string);
    }

    public static boolean isDouble(String string) {
        return ParseUtils.tryParseDouble(string) != null;
    }

    public static Double tryParseDouble(String string) {
        if (string.equalsIgnoreCase("nan")) {
            return Double.NaN;
        }
        return ParseUtils.tryParseNonNanDouble(string);
    }

    public static boolean isInteger(String string) {
        return ParseUtils.tryParseInteger(string) != null;
    }

    public static Integer tryParseInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static /* synthetic */ String lambda$asFormattedString$4(DecimalFormat decimalFormat, ReadOnlyDoubleProperty readOnlyDoubleProperty) throws Exception {
        return decimalFormat.format(readOnlyDoubleProperty.get());
    }
}

