/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.rima;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.dataset.DataSet;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Box;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;
import javax.inject.Inject;
import us.hebi.gui.lib.apt;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.asy;
import us.hebi.gui.lib.asz;
import us.hebi.gui.lib.atc;
import us.hebi.gui.lib.atj;
import us.hebi.gui.lib.atk;
import us.hebi.gui.lib.aup;
import us.hebi.gui.lib.avk;
import us.hebi.gui.lib.avo;
import us.hebi.gui.lib.avs;
import us.hebi.gui.lib.avw;
import us.hebi.gui.lib.avy;
import us.hebi.gui.lib.ayn;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.azo;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bes;

public class RimaPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Pane root;
    @FXML
    private Pane pane3d;
    @FXML
    private Pane pane2d;
    @FXML
    private Pane panePaut;
    @FXML
    private Pane paneControls;
    @FXML
    private Pane paneChart;
    @FXML
    private ImageView pautView;
    @FXML
    private CheckBox selectionEnabled;
    @FXML
    private CheckBox selectionFlipped;
    @FXML
    private Slider colorSliderMin;
    @FXML
    private Slider colorSliderMax;
    @FXML
    private Slider smartMinSlider;
    @FXML
    private Button saveGridImgButton;
    @FXML
    private Button saveRawImgButton;
    asz mappedSurface = null;
    asy gridData = new asy();
    asg mappedPoint = new asg();
    final Property<atc> surfaceMap = new SimpleObjectProperty();
    final avk surface3d = new avk();
    final avk probeMesh = new avk();
    final Box probeModel = new bes(this);
    final avw probe3d;
    final avy world;
    static final double PROBE_SIZE_M = 0.053;
    azo chartTrace;
    XYChart chart;
    @Inject
    aup properties;
    @Inject
    asf MAPS;
    @Inject
    atk tfmImageAnalysis;
    @Inject
    ayn fileChooser;

    public RimaPresenter() {
        this.probe3d = new avw(new Node[]{this.probeMesh.e, this.probeModel, avs.a(10.0)});
        this.world = new avy(new Node[]{this.surface3d.e, this.probe3d}).a();
        this.chartTrace = azo.a("depth", 1000, new String[0]);
        this.chart = new XYChart();
        this.chart.getPlugins().add((Object)azk.a());
        this.chart.setLegendVisible(false);
        this.chartTrace.addStyleClasses(new String[]{bat.c.D()});
        this.chart.getRenderers().setAll((Object[])new Renderer[]{azk.a()});
        this.chart.getDatasets().add((Object)this.chartTrace);
        Axis axis = this.chart.getFirstAxis(Orientation.HORIZONTAL);
        axis.setUnit("mm");
        axis.setName("x");
        axis.setTickUnit(10.0);
        axis.setAutoRanging(false);
        axis.setAutoGrowRanging(false);
        Axis axis2 = this.chart.getFirstAxis(Orientation.VERTICAL);
        axis2.setUnit("mm");
        axis2.setName("z");
        axis2.setTickUnit(5.0);
        axis2.setAutoRanging(false);
        axis2.setAutoGrowRanging(false);
        axis.set(0.0, aqy.a.f(0.053));
        axis2.set(0.0, 20.0);
    }

    @FXML
    void initialize() throws IOException {
        bdc.b(this::initializeOnFxThread);
    }

    private void initializeOnFxThread() {
        bdc.a(bl2 -> {
            if (!bl2) {
                asy asy2 = this.gridData;
                if (!asy2.ap()) {
                    Arrays.fill(asy2.aA, 0, asy2.h(), 0);
                    Arrays.fill(asy2.d, 0, asy2.h(), false);
                    asy2.aW = false;
                    asy2.aX = false;
                    asy2.a.ba();
                    asy2.a.a();
                }
                this.gridData.a(this.mappedSurface);
            }
        }, (ObservableBooleanValue)this.selectionEnabled.selectedProperty());
        bdc.a(d2 -> {
            double d3;
            double d4 = d2;
            asy asy2 = this.gridData;
            this.gridData.a.dV = d3 = d4;
            asy2.aX = true;
            this.gridData.aH();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.colorSliderMin.valueProperty());
        bdc.a(d2 -> {
            double d3;
            double d4 = d2;
            asy asy2 = this.gridData;
            this.gridData.a.D = d3 = d4;
            asy2.aX = true;
            this.gridData.aH();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.colorSliderMax.valueProperty());
        bdc.a(d2 -> {
            double d3 = d2;
            asy asy2 = this.gridData;
            asy2.cL = d3 < 0.0 ? 0.0 : (d3 > 100.0 ? 1.0 : d3 / 100.0);
            asy2.aX = true;
            this.gridData.aH();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.smartMinSlider.valueProperty());
        this.probeMesh.e.diffuseMapProperty().bind((ObservableValue)this.pautView.imageProperty());
        this.probeMesh.f.diffuseMapProperty().bind((ObservableValue)this.pautView.imageProperty());
        this.tfmImageAnalysis.f(this::updatePlots);
        this.paneChart.getChildren().add((Object)this.chart);
        bdc.c(this.chart);
        this.world.a(this.pane3d);
        Optional.ofNullable(RimaPresenter.class.getResource("assets/aluminum-dark.jpg")).map(URL::toExternalForm).map(Image::new).ifPresent(this.surface3d::a);
        this.MAPS.c(this.probe3d::b);
        this.MAPS.d(asg2 -> {
            this.mappedPoint.a((asg)asg2);
            if (this.mappedSurface != null) {
                this.mappedSurface.a((asg)asg2, 0.053);
            }
        });
        this.MAPS.b(atc2 -> {
            this.surfaceMap.setValue(atc2);
            this.surface3d.a((Mesh)atc2.a());
            Point3D point3D = avo.a((Mesh)atc2.a());
            bdc.a((Node)this.world.f, point3D);
            this.mappedSurface = asz.a(atc2, 800.0, 400.0);
            this.surface3d.e.diffuseMapProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.selectionFlipped.selectedProperty()).then(this.mappedSurface.b).otherwise(this.mappedSurface.a));
            this.surface3d.f.diffuseMapProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.selectionFlipped.selectedProperty()).then(this.mappedSurface.a).otherwise(this.mappedSurface.b));
            this.pane2d.getChildren().setAll((Object[])new Node[]{this.mappedSurface.a});
            asy asy2 = this.gridData;
            this.gridData.cK = 0.001;
            asy2.resize();
            atc atc3 = atc2;
            asy2 = this.gridData;
            this.gridData.b = atc3;
            asy2.resize();
            this.mappedSurface.l(0.01);
        });
        CompletableFuture.runAsync(() -> apt.b(1L, TimeUnit.SECONDS)).thenRun(this.MAPS::a);
    }

    public void updatePlots(atj atj2) {
        TriangleMesh triangleMesh;
        if (atj2.a != null) {
            triangleMesh = atj2.a;
            Point3D point3D = avo.a((Mesh)triangleMesh);
            this.probeMesh.e.setTranslateX(-point3D.getX());
            this.probeMesh.e.setRotationAxis(Rotate.Z_AXIS);
            this.probeMesh.e.setRotate(-90.0);
            this.probeMesh.a((Mesh)triangleMesh);
        }
        atj atj3 = atj2;
        boolean cfr_ignored_0 = atj3.aZ;
        if (atj3.ba) {
            atj3 = atj2;
            triangleMesh = (atj3.ba ? atj3.c : atj3.b).a;
            this.pautView.setImage((Image)triangleMesh);
        }
        this.chartTrace.bs();
        if (atj2.J() > 0) {
            atj2.a(this.chartTrace::f);
            this.chartTrace.br();
            if (this.mappedPoint.isInContact() && this.selectionEnabled.isSelected()) {
                atj2.a(this::addProbeMeasurement);
                this.gridData.aH();
                this.gridData.a(this.mappedSurface);
            }
        }
        this.chart.getDatasets().setAll((Object[])new DataSet[]{this.chartTrace});
    }

    private void addProbeMeasurement(double d2, double d3) {
        double d4 = d2 / 1000.0 - 0.0265;
        if (this.selectionFlipped.isSelected()) {
            d4 = -d4;
        }
        double d5 = d4 * this.mappedPoint.cy + (double)this.mappedPoint.o;
        double d6 = d4 * this.mappedPoint.cz + (double)this.mappedPoint.p;
        double d7 = d3;
        double d8 = d6;
        double d9 = d5;
        asy asy2 = this.gridData;
        if (!asy2.ap()) {
            int n2;
            int n3;
            int n4 = (int)(asy2.b.l(d9) * (double)asy2.ao);
            int n5 = (int)(asy2.b.m(d8) * (double)asy2.an);
            if (n5 < 0 || n4 < 0 || n5 >= asy2.an || n4 >= asy2.ao) {
                return;
            }
            int n6 = n4;
            int n7 = n5;
            asy asy3 = asy2;
            int n8 = n3 = n7 * asy3.ao + n6;
            int n9 = asy2.aA[n8];
            asy2.aA[n8] = n9 + 1;
            int n10 = n2 = n9 % 32;
            int n11 = n3;
            asy2.H[(n11 << 5) + n10] = d7;
            asy2.d[n3] = true;
            asy2.aW = true;
        }
    }
}

