/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.utils;

import io.fair_acc.chartfx.marker.DefaultMarker;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXY;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import us.hebi.gui.lib.aqm;
import us.hebi.gui.lib.bnb;
import us.hebi.gui.lib.bnd;
import us.hebi.gui.lib.bnn;
import us.hebi.gui.lib.bnp;
import us.hebi.gui.lib.cdw;
import us.hebi.gui.lib.cef;
import us.hebi.gui.views.maps.utils.MapsFeedbackDataSet;

public class MapsFeedbackRenderer
extends AbstractRendererXY<MapsFeedbackRenderer> {
    cef ascan;
    aqm xToDisplay;
    aqm yToDisplay;
    double ascanLineWidth = 2.0;
    double gateLineWidth = 2.0;
    double gateLineSideLength = 4.0;
    double refPosWidth = 4.0;

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        if (!(dataSet instanceof MapsFeedbackDataSet)) {
            return;
        }
        MapsFeedbackDataSet mapsFeedbackDataSet = (MapsFeedbackDataSet)dataSet;
        this.xToDisplay = d2 -> this.xAxis.getDisplayPosition(mapsFeedbackDataSet.xTransform.apply(d2));
        this.yToDisplay = d2 -> this.yAxis.getDisplayPosition(mapsFeedbackDataSet.yTransform.apply(d2));
        this.ascan = mapsFeedbackDataSet.utData.a;
        bnd bnd2 = mapsFeedbackDataSet.message.a.a;
        bnp bnp2 = mapsFeedbackDataSet.message.a.a;
        graphicsContext.save();
        this.drawAscan(graphicsContext, dataSetNode.getLineColor());
        if (bnp2.bO()) {
            graphicsContext.setLineWidth(this.refPosWidth);
            graphicsContext.setStroke(dataSetNode.getMarkerColor());
            graphicsContext.setLineDashes(dataSetNode.getMarkerLineDashes());
            this.drawDashedVerticalLine(graphicsContext, bnp2.ec);
            graphicsContext.setLineDashes(dataSetNode.getLineDashes());
        }
        this.drawGate(graphicsContext, bnd2.a, bnp2.a, bnd2.ca, 0, Color.RED);
        this.drawGate(graphicsContext, bnd2.b, bnp2.b, bnd2.ca, bnp2.a.dZ, Color.GREEN);
        this.drawGate(graphicsContext, bnd2.c, bnp2.c, bnd2.ca, bnp2.b.dZ, Color.BLUE);
        graphicsContext.restore();
    }

    private void drawAscan(GraphicsContext graphicsContext, Paint paint) {
        if (this.ascan.ar() == 0) {
            return;
        }
        graphicsContext.setLineWidth(this.ascanLineWidth);
        graphicsContext.setStroke(paint);
        graphicsContext.beginPath();
        graphicsContext.moveTo(this.xToDisplay.apply(0.0), this.yToDisplay.apply(this.ascan.a(0)));
        for (int i2 = 1; i2 < this.ascan.ar(); ++i2) {
            graphicsContext.lineTo(this.xToDisplay.apply(i2), this.yToDisplay.apply(this.ascan.a(i2)));
        }
        graphicsContext.stroke();
    }

    private void drawGate(GraphicsContext graphicsContext, bnb bnb2, bnn bnn2, boolean bl2, int n2, Color color) {
        if (((cdw)bnb2).isEmpty()) {
            return;
        }
        if (!bl2) {
            n2 = 0;
        }
        double d2 = this.xToDisplay.apply(bnb2.dR + n2);
        double d3 = this.xToDisplay.apply(bnb2.dR + bnb2.dS + n2);
        double d4 = this.yToDisplay.apply(bnb2.dT);
        double d5 = this.yToDisplay.apply((double)bnb2.dT + this.gateLineSideLength);
        double d6 = this.yToDisplay.apply((double)bnb2.dT - this.gateLineSideLength);
        graphicsContext.setStroke((Paint)color);
        graphicsContext.setLineWidth(this.gateLineWidth);
        graphicsContext.strokeLine(d2, d4, d3, d4);
        graphicsContext.strokeLine(d2, d5, d2, d6);
        graphicsContext.strokeLine(d3, d5, d3, d6);
        if (!((cdw)bnn2).isEmpty()) {
            DefaultMarker.drawCross(graphicsContext, this.xToDisplay.apply(bnn2.dZ), d4, 8.0);
            DefaultMarker.drawEmptyCircle(graphicsContext, this.xToDisplay.apply(bnn2.ea), this.yToDisplay.apply(bnn2.eb), 8.0);
        }
    }

    private void drawDashedVerticalLine(GraphicsContext graphicsContext, int n2) {
        graphicsContext.strokeLine(this.xToDisplay.apply(n2), Math.min(this.yToDisplay.apply(-128.0), this.yToDisplay.apply(0.0)), this.xToDisplay.apply(n2), Math.max(this.yToDisplay.apply(127.0), this.yToDisplay.apply(0.0)));
    }

    @Override
    protected MapsFeedbackRenderer getThis() {
        return this;
    }
}

