/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components.dialogs;

import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javax.inject.Inject;
import lombok.Generated;
import org.controlsfx.validation.ValidationSupport;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.ash;
import us.hebi.gui.lib.asi;
import us.hebi.gui.lib.awh;
import us.hebi.gui.lib.bcn;
import us.hebi.gui.lib.bcq;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bdg;
import us.hebi.gui.lib.bdx;
import us.hebi.gui.lib.bfw;
import us.hebi.gui.lib.bfy;
import us.hebi.gui.lib.bga;
import us.hebi.gui.lib.bgb;
import us.hebi.gui.lib.bgc;
import us.hebi.gui.lib.cec;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsCss;
import us.hebi.gui.views.scope.components.ParseUtils;

public class FlatWizardController
extends bcn {
    @FXML
    private ToggleButton bottomLeft;
    @FXML
    private ToggleButton bottomRight;
    @FXML
    private Button closeBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private Button generateBtn;
    @FXML
    private StackPane rectangleLines;
    @FXML
    private AnchorPane root;
    @FXML
    private ToggleButton topLeft;
    @FXML
    private ToggleButton topRight;
    @FXML
    private TextField paddingField;
    final IntegerProperty numSelectedPoints = new SimpleIntegerProperty(0);
    final BooleanBinding needsMorePoints = this.numSelectedPoints.lessThan(3);
    @Inject
    asf maps;
    @Inject
    asi registration;
    @Inject
    awh notification;
    @Inject
    MapsAppState state;

    @Override
    public void initializeFx() {
        bdx.e((Parent)this.root);
        ValidationSupport validationSupport = bcq.a();
        validationSupport.registerValidator((Control)this.paddingField, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        this.state.addUnitFields(this.paddingField);
        bdc.b(() -> {
            this.generateBtn.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, !this.needsMorePoints.get());
            this.rectangleLines.pseudoClassStateChanged(MapsCss.SELECTED, !this.needsMorePoints.get());
        }, new Observable[]{this.needsMorePoints});
        FlatWizardController flatWizardController = this;
        bfy bfy2 = flatWizardController.setupToggleButton(flatWizardController.topLeft, bdg.k);
        FlatWizardController flatWizardController2 = this;
        bfy bfy3 = flatWizardController2.setupToggleButton(flatWizardController2.topRight, bdg.l);
        FlatWizardController flatWizardController3 = this;
        bfy bfy4 = flatWizardController3.setupToggleButton(flatWizardController3.bottomLeft, bdg.m);
        FlatWizardController flatWizardController4 = this;
        bfy bfy5 = flatWizardController4.setupToggleButton(flatWizardController4.bottomRight, bdg.n);
        this.generateBtn.disableProperty().bind((ObservableValue)this.needsMorePoints.or((ObservableBooleanValue)validationSupport.invalidProperty()));
        this.generateBtn.setOnAction(actionEvent -> {
            this.registration.aF();
            if (!this.topLeft.isSelected()) {
                bfy2.c(this.deriveWaypointAndAddMarkers(bfy3, bfy4, bfy5));
            } else if (!this.topRight.isSelected()) {
                bfy3.c(this.deriveWaypointAndAddMarkers(bfy2, bfy5, bfy4));
            } else if (!this.bottomLeft.isSelected()) {
                bfy4.c(this.deriveWaypointAndAddMarkers(bfy2, bfy5, bfy3));
            } else if (!this.bottomRight.isSelected()) {
                bfy5.c(this.deriveWaypointAndAddMarkers(bfy4, bfy3, bfy2));
            }
            bgb bgb2 = bfy2.a().a(bfy3.a()).b();
            bgb bgb3 = bfy2.a().a(bfy4.a()).b();
            double d2 = this.state.getUnits().e(Optional.ofNullable(ParseUtils.tryParseDouble(this.paddingField.getText())).orElse(0.0));
            bgb bgb4 = bgb2.c().a(d2);
            bgb bgb5 = bgb3.c().a(d2);
            bgb bgb6 = bgb2.c().a(-d2);
            bgb bgb7 = bgb3.c().a(-d2);
            bfy bfy7 = bfy2.e().a(bgb4).a(bgb5);
            bfy bfy8 = bfy3.e().a(bgb6).a(bgb5);
            bfy bfy9 = bfy4.e().a(bgb4).a(bgb7);
            bfy bfy10 = bfy5.e().a(bgb6).a(bgb7);
            bfy[] bfyArray = new bfy[9];
            bfyArray[0] = bfy7.e();
            bfy bfy11 = bfy8;
            bfy bfy12 = bfy7;
            bfyArray[1] = bga.a(bfy12, bfy11);
            bfyArray[2] = bfy8.e();
            bfy11 = bfy9;
            bfy12 = bfy7;
            bfyArray[3] = bga.a(bfy12, bfy11);
            bfy11 = bfy10;
            bfy12 = bfy7;
            bfyArray[4] = bga.a(bfy12, bfy11);
            bfy11 = bfy10;
            bfy12 = bfy8;
            bfyArray[5] = bga.a(bfy12, bfy11);
            bfyArray[6] = bfy9.e();
            bfy11 = bfy10;
            bfy12 = bfy9;
            bfyArray[7] = bga.a(bfy12, bfy11);
            bfyArray[8] = bfy10.e();
            ash ash2 = new ash(bfyArray);
            bgb bgb8 = bgb3;
            bgb bgb9 = bgc.a(bgb2, bgb8, bgb.d()).b();
            bgc.a(bgb9, bgb2, bgb3);
            ash2.e(bfy2 -> bfy2.a(bgb2.a1, bgb3.a1, bgb4.a1, bgb2.a2, bgb3.a2, bgb4.a2, bgb2.a3, bgb3.a3, bgb4.a3));
            this.registration.a(ash2);
            this.closeBtn.getOnAction().handle(actionEvent);
        });
        this.clearBtn.disableProperty().bind((ObservableValue)this.numSelectedPoints.isEqualTo(0));
        this.clearBtn.setOnAction(actionEvent -> {
            this.topLeft.setSelected(false);
            this.topRight.setSelected(false);
            this.bottomLeft.setSelected(false);
            this.bottomRight.setSelected(false);
            this.paddingField.setText("0");
        });
    }

    private bfy deriveWaypointAndAddMarkers(bfy bfy2, bfy bfy3, bfy bfy4) {
        this.registration.a(bfy2, bfy3, bfy4);
        bfy bfy5 = bfy.d();
        bfy[] bfyArray = new bfy[]{bfy2, bfy3, bfy4};
        int cfr_ignored_0 = bfyArray.length;
        cec.c(true, "need at least one transform");
        bfw bfw2 = new bfw();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        bfy[] bfyArray2 = bfyArray;
        int cfr_ignored_1 = bfyArray.length;
        for (int i2 = 0; i2 < 3; ++i2) {
            bfyArray2[i2].a(bfw2);
            d2 += bfw2.cM;
            d3 += bfw2.dm;
            d4 += bfw2.dn;
            d5 += bfw2.do;
        }
        int cfr_ignored_2 = bfyArray.length;
        bfw2.cM = d2 / 3.0;
        int cfr_ignored_3 = bfyArray.length;
        bfw2.dm = d3 / 3.0;
        int cfr_ignored_4 = bfyArray.length;
        bfw2.dn = d4 / 3.0;
        int cfr_ignored_5 = bfyArray.length;
        bfw2.do = d5 / 3.0;
        bfw2.bX();
        bfy5.a(bfw2);
        bfy5.ea = bfy2.ea + bfy3.ea - bfy4.ea;
        bfy5.ec = bfy2.ec + bfy3.ec - bfy4.ec;
        bfy5.eg = bfy2.eg + bfy3.eg - bfy4.eg;
        return bfy5;
    }

    private bfy setupToggleButton(ToggleButton toggleButton, KeyCombination keyCombination) {
        toggleButton.visibleProperty().bind((ObservableValue)toggleButton.selectedProperty().or((ObservableBooleanValue)this.needsMorePoints));
        bfy bfy2 = bfy.d();
        toggleButton.selectedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                bfy2.c(this.maps.a);
                this.numSelectedPoints.set(this.numSelectedPoints.get() + 1);
                return;
            }
            this.numSelectedPoints.set(this.numSelectedPoints.get() - 1);
        });
        bdg.a((Node)toggleButton, keyCombination, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> {
            if (!bdc.a((Node)toggleButton)) {
                return;
            }
            bdc.a(toggleButton.selectedProperty());
        }));
        return bfy2;
    }

    public Button getCloseButton() {
        return this.closeBtn;
    }

    @Generated
    public MapsAppState getState() {
        return this.state;
    }
}

