/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import us.hebi.core.messages.flat.BaseFlatFeedback;
import us.hebi.core.messages.flat.FlatFeedback;
import us.hebi.gui.lib.agx;
import us.hebi.gui.lib.aln;
import us.hebi.gui.lib.amw;
import us.hebi.gui.lib.ark;
import us.hebi.gui.lib.blm;
import us.hebi.gui.lib.bvf;
import us.hebi.gui.lib.cea;
import us.hebi.gui.lib.zi;
import us.hebi.gui.lib.zl;
import us.hebi.gui.lib.zq;
import us.hebi.gui.views.logviewer.hebilog.GroupFeedbackHandler;

public class HebiLogAnalysis$FeedbackSynchronizer
implements zq {
    private aln msg;
    private FlatFeedback flatFbk;
    private agx fbkSync;
    private bvf userState = bvf.a();
    private double startTime = Double.NaN;
    private double absoluteTimeOffset = Double.NaN;
    private long timestampOffset = -1L;
    private final List<GroupFeedbackHandler> fbkHandlers = new ArrayList<GroupFeedbackHandler>();
    protected int numDevices = 0;

    public int getNumDevices() {
        return this.numDevices;
    }

    public int getNumReceived(int n2) {
        return this.fbkSync.X[n2];
    }

    public OptionalDouble getStartTime() {
        if (Double.isNaN(this.startTime)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.startTime);
    }

    public OptionalDouble getAbsoluteTimeOffset() {
        if (Double.isNaN(this.absoluteTimeOffset)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.absoluteTimeOffset);
    }

    public int[] getNumReceived() {
        return this.fbkSync.X;
    }

    public int[] getNumDropped() {
        return this.fbkSync.Y;
    }

    public int getNumSynced() {
        return this.fbkSync.bS;
    }

    @Override
    public void onHeader(zi zi2) {
        this.numDevices = zi2.getAddressMap().A();
        if (zi2.u()) {
            this.timestampOffset = zi2.k();
            this.startTime = ark.a(zi2.k());
        }
        if (zi2.v()) {
            this.absoluteTimeOffset = ark.a(zi2.l());
        }
        this.msg = new aln();
        this.flatFbk = new FlatFeedback();
        this.fbkSync = new agx(zi2.getAddressMap().A());
        Iterator<GroupFeedbackHandler> iterator = this.fbkHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().init(this.numDevices);
        }
    }

    @Override
    public void onEntry(zl zl2, int n2, long l2, cea cea2) throws IOException {
        if (zl2 == zl.a) {
            this.onFeedback(n2, l2, cea2);
            return;
        }
        if (zl2 == zl.c) {
            this.onUserState(l2, cea2);
        }
    }

    public void onFeedback(int n2, long l2, cea cea2) throws IOException {
        ((amw)this.msg).clear();
        this.msg.a(l2, cea2);
        if (!this.msg.ad()) {
            return;
        }
        if (this.timestampOffset < 0L) {
            this.timestampOffset = l2;
        }
        double d2 = ark.a(l2 - this.timestampOffset);
        ((BaseFlatFeedback)this.flatFbk).a(d2, this.msg);
        bvf bvf2 = this.userState;
        FlatFeedback flatFeedback = this.flatFbk;
        this.flatFbk.state1 = bvf2.bw;
        flatFeedback.state2 = bvf2.bx;
        flatFeedback.state3 = bvf2.by;
        flatFeedback.state4 = bvf2.bz;
        flatFeedback.state5 = bvf2.bA;
        flatFeedback.state6 = bvf2.bB;
        flatFeedback.state7 = bvf2.bC;
        flatFeedback.state8 = bvf2.bD;
        flatFeedback.state9 = bvf2.bE;
        if (this.fbkSync.a(n2, this.flatFbk)) {
            this.onGroupFeedback(d2, this.fbkSync.b, this.fbkSync.a);
            this.fbkSync.O();
        }
    }

    protected void onGroupFeedback(double d2, FlatFeedback[] flatFeedbackArray, FlatFeedback[] flatFeedbackArray2) {
        Iterator<GroupFeedbackHandler> iterator = this.fbkHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onGroupFeedback(d2, flatFeedbackArray, flatFeedbackArray2);
        }
    }

    public void onUserState(long l2, cea cea2) throws IOException {
        this.userState.b().a(cea2);
        double d2 = ark.a(l2 - this.timestampOffset);
        Iterator<GroupFeedbackHandler> iterator = this.fbkHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onUserState(d2, this.userState);
        }
    }

    @Override
    public void onEoF() {
        this.msg = null;
        this.flatFbk = null;
        this.fbkSync = null;
        Iterator<GroupFeedbackHandler> iterator = this.fbkHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onInvalidate();
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public HebiLogAnalysis$FeedbackSynchronizer addHandler(GroupFeedbackHandler groupFeedbackHandler) {
        this.fbkHandlers.add(blm.b(groupFeedbackHandler));
        return this;
    }

    public HebiLogAnalysis$FeedbackSynchronizer addHandlers(Collection<? extends GroupFeedbackHandler> collection) {
        this.fbkHandlers.addAll(collection);
        return this;
    }
}

