/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.lib;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.xml.bind.JAXBException;
import picocli.CommandLine;
import us.hebi.gui.lib.agc;
import us.hebi.gui.lib.ahc;
import us.hebi.gui.lib.ahg;
import us.hebi.gui.lib.apg;
import us.hebi.gui.lib.apt;
import us.hebi.gui.lib.apz;
import us.hebi.gui.lib.aqu;
import us.hebi.gui.lib.bbo;
import us.hebi.gui.lib.bca;
import us.hebi.gui.lib.bcb;
import us.hebi.gui.lib.bvy;
import us.hebi.gui.lib.cdw;
import us.hebi.gui.lib.cej;
import us.hebi.gui.lib.ceq;
import us.hebi.gui.lib.xs;

@CommandLine.Command(name="hebi-config", mixinStandardHelpOptions=true, versionProvider=bbo.class, description={"Sends configuration options to HEBI devices."})
public abstract class bbn
implements Callable<Integer> {
    @CommandLine.Option(names={"-ip", "--ip-address"}, description={"IP address of the target device, e.g., 10.11.12.13. May occur more than once."}, split=",")
    private String[] ipAddresses;
    @CommandLine.Option(names={"-mac", "--mac-address"}, description={"MAC address of the target device(s). May occur more than once"}, split=",")
    private String[] macAddresses;
    @CommandLine.Option(names={"-serial", "--serial-number"}, description={"Serial number of the target device(s). May occur more than once"}, split=",")
    private String[] serialNumbers;
    @CommandLine.Option(names={"-f", "--family"}, description={"Family of the target device(s). Defaults to '*'."})
    private String family = "*";
    @CommandLine.Option(names={"-n", "--name", "--names"}, description={"Names of the target device(s). May occur more than once"}, split=",")
    private String[] names;
    @CommandLine.Option(names={"--verbose"}, description={"Prints verbose information."})
    protected boolean verbose;
    @CommandLine.Option(names={"--debug"}, description={"Prints debug information."})
    protected boolean debug;
    @CommandLine.Option(names={"--dry-run"}, description={"Prints the outgoing message without sending it."})
    protected boolean dryRun;
    @CommandLine.Option(names={"--reset"}, description={"Commands the devices to reset. Can not be combined with other commands"})
    private boolean reset;
    private List<ahg> o;

    protected final List<ahg> d() throws bca {
        String[] stringArray;
        String[] stringArray2;
        if (this.o != null) {
            return this.o;
        }
        if (this.debug) {
            System.out.println("====== devices ======");
            System.out.println("macAddresses = " + Arrays.toString(this.macAddresses));
            System.out.println("serialNumbers = " + Arrays.toString(this.serialNumbers));
            System.out.println("family = " + this.family);
            System.out.println("names = " + Arrays.toString(this.names));
            System.out.println("ipAddresses = " + Arrays.toString(this.ipAddresses));
            System.out.println("=====================");
        }
        ArrayList<ahg> arrayList = new ArrayList<ahg>();
        if (this.macAddresses != null || this.serialNumbers != null || this.names != null) {
            String string;
            int n2;
            int n3;
            stringArray2 = aqu.a();
            if (this.verbose) {
                System.out.println("Found broadcast interfaces: " + String.valueOf(stringArray2.stream().map(InetAddress::getHostAddress).toList()));
            }
            System.out.println("Running lookup...");
            xs xs2 = xs.a();
            xs2.setAddresses((List<InetAddress>)stringArray2);
            xs2.start();
            for (int i2 = 0; i2 < 10; ++i2) {
                xs2.requestInfo();
                apt.b(100L, TimeUnit.MILLISECONDS);
            }
            xs2.requestInfo();
            agc agc2 = xs2.a;
            if (this.macAddresses != null) {
                if (this.verbose) {
                    System.out.println("Looking for mac addresses: " + Arrays.toString(this.macAddresses));
                }
                stringArray = this.macAddresses;
                n3 = this.macAddresses.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    string = stringArray[n2];
                    arrayList.add(agc2.a((apg)apg.a((String)string)).c);
                }
            }
            if (this.serialNumbers != null) {
                if (this.verbose) {
                    System.out.println("Looking for serial numbers: " + Arrays.toString(this.serialNumbers));
                }
                stringArray = this.serialNumbers;
                n3 = this.serialNumbers.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    string = stringArray[n2];
                    arrayList.add(agc2.a((String)string).c);
                }
            }
            if (this.names != null) {
                if (this.verbose) {
                    System.out.println("Looking for names: " + Arrays.toString(this.names));
                }
                stringArray = this.names;
                n3 = this.names.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    string = stringArray[n2];
                    arrayList.add(agc2.a((String)this.family, (String)string).c);
                }
            }
            xs2.shutdown();
        }
        if (this.ipAddresses != null) {
            stringArray2 = this.ipAddresses;
            int n4 = this.ipAddresses.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                stringArray = stringArray2[i3];
                arrayList.add(ahg.a((String)stringArray));
            }
        }
        if (arrayList.isEmpty()) {
            throw bca.a();
        }
        this.o = arrayList;
        return this.o;
    }

    private Integer a() throws Exception {
        try {
            this.run();
            return bcb.b.cT;
        }
        catch (bca bca2) {
            System.err.println(bca2.getMessage());
            return bca2.a.cT;
        }
        catch (JAXBException jAXBException) {
            System.err.println(apz.a(jAXBException));
            return bcb.c.cT;
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
            return bcb.c.cT;
        }
    }

    protected abstract void g(List<BiConsumer<bvy, Integer>> var1) throws Exception;

    protected abstract void w(int var1) throws Exception;

    protected void run() throws Exception {
        ArrayList<BiConsumer<bvy, Integer>> arrayList = new ArrayList<BiConsumer<bvy, Integer>>();
        this.g(arrayList);
        List<ahg> list = this.d();
        if (this.verbose) {
            System.out.println("Target device addresses: ");
            list.forEach(ahg2 -> System.out.println("* " + String.valueOf(ahg2)));
        }
        this.w(list.size());
        bvy bvy2 = bvy.b();
        int n2 = 0;
        for (ahg ahg3 : list) {
            bvy2.c();
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                ((BiConsumer)object.next()).accept(bvy2, n2);
            }
            ++n2;
            if (!((cdw)bvy2).isEmpty()) {
                System.out.println("Sending message to " + String.valueOf(ahg3) + "...");
                if (this.dryRun) {
                    System.out.println(bvy2);
                } else {
                    ceq ceq2;
                    object = ahc.a(ahg3, bvy2);
                    if (object == null) {
                        System.err.println("Failed to receive response from " + String.valueOf(ahg3) + ".");
                        continue;
                    }
                    if (this.verbose) {
                        System.out.println("Received response from " + String.valueOf(ahg3) + ".");
                    }
                    if ((ceq2 = ((bvy)object).a.b.d).ar() > 0) {
                        System.err.println("Received errors from " + String.valueOf(ahg3) + ":");
                        Object RepeatedType = ((cej)ceq2).a();
                        while (RepeatedType.hasNext()) {
                            String string = (String)RepeatedType.next();
                            System.err.println("    " + string);
                        }
                    }
                }
            }
            if (!this.reset) continue;
            System.out.println("Sending reset command to " + String.valueOf(ahg3) + ". Not waiting for ack.");
            bvy2.c().i(true);
            if (this.dryRun) {
                System.out.println(bvy2);
                continue;
            }
            ahc.a(ahg3, bvy2);
        }
    }

    protected final boolean c(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isFile()) {
            throw bca.a(file);
        }
        if (this.verbose) {
            System.out.println("Loading file " + String.valueOf(file));
        }
        return true;
    }

    protected static void c(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            throw bca.a(string, objectArray);
        }
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.a();
    }
}

