/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli;

import java.util.Arrays;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Logger;
import org.kordamp.ikonli.IkonHandler;

public class AbstractIkonResolver {
    private static final String ORG_KORDAMP_IKONLI_STRICT = "org.kordamp.ikonli.strict";
    private static final Logger LOGGER = Logger.getLogger(AbstractIkonResolver.class.getName());

    protected boolean registerHandler(IkonHandler ikonHandler, Set<IkonHandler> set, Set<IkonHandler> set2) {
        if (this.isLoadedViaClasspath(ikonHandler, set)) {
            this.throwOrWarn(String.format("IkonHandler for %s is already loaded via classpath", ikonHandler.getFontFamily()));
            return false;
        }
        return set2.add(ikonHandler);
    }

    protected boolean unregisterHandler(IkonHandler ikonHandler, Set<IkonHandler> set, Set<IkonHandler> set2) {
        if (this.isLoadedViaClasspath(ikonHandler, set)) {
            this.throwOrWarn(String.format("IkonHandler for %s was loaded via classpath and can't be unregistered", ikonHandler.getFontFamily()));
            return false;
        }
        return set2.remove(ikonHandler);
    }

    protected IkonHandler resolve(String string, Set<IkonHandler> set, Set<IkonHandler> set2) {
        Objects.requireNonNull(string, "Ikon description must not be null");
        for (Set set3 : Arrays.asList(set, set2)) {
            for (IkonHandler ikonHandler : set3) {
                if (!ikonHandler.supports(string)) continue;
                return ikonHandler;
            }
        }
        throw new UnsupportedOperationException("Cannot resolve '" + string + "'");
    }

    private boolean isLoadedViaClasspath(IkonHandler ikonHandler, Set<IkonHandler> set) {
        String string = ikonHandler.getFontFamily();
        for (IkonHandler ikonHandler2 : set) {
            if (!ikonHandler2.getFontFamily().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void throwOrWarn(String string) {
        if (this.strictChecksEnabled()) {
            throw new IllegalArgumentException(string);
        }
        LOGGER.warning(string);
    }

    private boolean strictChecksEnabled() {
        return System.getProperty(ORG_KORDAMP_IKONLI_STRICT) == null || Boolean.getBoolean(ORG_KORDAMP_IKONLI_STRICT);
    }

    public static ServiceLoader<IkonHandler> resolveServiceLoader() {
        ServiceLoader<IkonHandler> serviceLoader;
        if (null != IkonHandler.class.getModule().getLayer() && (serviceLoader = ServiceLoader.load(IkonHandler.class.getModule().getLayer(), IkonHandler.class)).stream().count() > 0L) {
            return serviceLoader;
        }
        serviceLoader = ServiceLoader.load(IkonHandler.class, IkonHandler.class.getClassLoader());
        if (serviceLoader.stream().count() > 0L) {
            return serviceLoader;
        }
        return ServiceLoader.load(IkonHandler.class);
    }
}

