/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.skin.ListSelectionViewSkin;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCombination;
import javafx.util.Callback;
import org.controlsfx.control.ControlsFXControl;
import org.controlsfx.control.action.Action;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;

public class ListSelectionView<T>
extends ControlsFXControl {
    private static final String DEFAULT_STYLECLASS = "list-selection-view";
    private final ObjectProperty<Node> sourceHeader = new SimpleObjectProperty((Object)this, "sourceHeader");
    private final ObjectProperty<Node> sourceFooter = new SimpleObjectProperty((Object)this, "sourceFooter");
    private final ObjectProperty<Node> targetHeader = new SimpleObjectProperty((Object)this, "targetHeader");
    private final ObjectProperty<Node> targetFooter = new SimpleObjectProperty((Object)this, "targetFooter");
    private ObjectProperty<ObservableList<T>> sourceItems;
    private ObjectProperty<ObservableList<T>> targetItems;
    private final ObjectProperty<Orientation> orientation = new SimpleObjectProperty((Object)this, "orientation", (Object)Orientation.HORIZONTAL);
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactory;
    private ObservableList<Action> actions = FXCollections.observableArrayList((Object[])new Action[]{new MoveToTarget(), new MoveToTargetAll(), new MoveToSource(), new MoveToSourceAll()});
    private ObservableList<Action> sourceActions = FXCollections.observableArrayList();
    private ObservableList<Action> targetActions = FXCollections.observableArrayList();

    public ListSelectionView() {
        this.getStyleClass().add((Object)DEFAULT_STYLECLASS);
        Label label = new Label(Localization.localize(Localization.asKey("listSelectionView.header.source")));
        label.getStyleClass().add((Object)"list-header-label");
        label.setId("source-header-label");
        this.setSourceHeader((Node)label);
        Label label2 = new Label(Localization.localize(Localization.asKey("listSelectionView.header.target")));
        label2.getStyleClass().add((Object)"list-header-label");
        label2.setId("target-header-label");
        this.setTargetHeader((Node)label2);
    }

    protected Skin<ListSelectionView<T>> createDefaultSkin() {
        return new ListSelectionViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return this.getUserAgentStylesheet(ListSelectionView.class, "listselectionview.css");
    }

    public final ObjectProperty<Node> sourceHeaderProperty() {
        return this.sourceHeader;
    }

    public final Node getSourceHeader() {
        return (Node)this.sourceHeader.get();
    }

    public final void setSourceHeader(Node node) {
        this.sourceHeader.set((Object)node);
    }

    public final ObjectProperty<Node> sourceFooterProperty() {
        return this.sourceFooter;
    }

    public final Node getSourceFooter() {
        return (Node)this.sourceFooter.get();
    }

    public final void setSourceFooter(Node node) {
        this.sourceFooter.set((Object)node);
    }

    public final ObjectProperty<Node> targetHeaderProperty() {
        return this.targetHeader;
    }

    public final Node getTargetHeader() {
        return (Node)this.targetHeader.get();
    }

    public final void setTargetHeader(Node node) {
        this.targetHeader.set((Object)node);
    }

    public final ObjectProperty<Node> targetFooterProperty() {
        return this.targetFooter;
    }

    public final Node getTargetFooter() {
        return (Node)this.targetFooter.get();
    }

    public final void setTargetFooter(Node node) {
        this.targetFooter.set((Object)node);
    }

    public final void setSourceItems(ObservableList<T> observableList) {
        this.sourceItemsProperty().set(observableList);
    }

    public final ObservableList<T> getSourceItems() {
        return (ObservableList)this.sourceItemsProperty().get();
    }

    public final ObjectProperty<ObservableList<T>> sourceItemsProperty() {
        if (this.sourceItems == null) {
            this.sourceItems = new SimpleObjectProperty((Object)this, "sourceItems", (Object)FXCollections.observableArrayList());
        }
        return this.sourceItems;
    }

    public final void setTargetItems(ObservableList<T> observableList) {
        this.targetItemsProperty().set(observableList);
    }

    public final ObservableList<T> getTargetItems() {
        return (ObservableList)this.targetItemsProperty().get();
    }

    public final ObjectProperty<ObservableList<T>> targetItemsProperty() {
        if (this.targetItems == null) {
            this.targetItems = new SimpleObjectProperty((Object)this, "targetItems", (Object)FXCollections.observableArrayList());
        }
        return this.targetItems;
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set((Object)orientation);
    }

    public final Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> callback) {
        this.cellFactoryProperty().set(callback);
    }

    public final Callback<ListView<T>, ListCell<T>> getCellFactory() {
        return this.cellFactory == null ? null : (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
        }
        return this.cellFactory;
    }

    public final ObservableList<Action> getActions() {
        return this.actions;
    }

    public final ObservableList<Action> getSourceActions() {
        return this.sourceActions;
    }

    public final ObservableList<Action> getTargetActions() {
        return this.targetActions;
    }

    private static Glyph getGlyph(FontAwesome.Glyph glyph) {
        return new FontAwesome().create(glyph);
    }

    private static <T> void moveToTarget(ListView<T> listView, ListView<T> listView2) {
        ListSelectionView.move(listView, listView2);
        listView.getSelectionModel().clearSelection();
    }

    private static <T> void moveToTargetAll(ListView<T> listView, ListView<T> listView2) {
        ListSelectionView.move(listView, listView2, new ArrayList(listView.getItems()));
        listView.getSelectionModel().clearSelection();
    }

    private static <T> void moveToSource(ListView<T> listView, ListView<T> listView2) {
        ListSelectionView.move(listView2, listView);
        listView2.getSelectionModel().clearSelection();
    }

    private static <T> void moveToSourceAll(ListView<T> listView, ListView<T> listView2) {
        ListSelectionView.move(listView2, listView, new ArrayList(listView2.getItems()));
        listView2.getSelectionModel().clearSelection();
    }

    private static <T> void move(ListView<T> listView, ListView<T> listView2) {
        ArrayList arrayList = new ArrayList(listView.getSelectionModel().getSelectedItems());
        ListSelectionView.move(listView, listView2, arrayList);
    }

    private static <T> void move(ListView<T> listView, ListView<T> listView2, List<T> list) {
        listView.getItems().removeAll(list);
        listView2.getItems().addAll(list);
    }

    public class MoveToSourceAll
    extends ListSelectionAction<T> {
        public MoveToSourceAll() {
            super((Node)ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_DOUBLE_LEFT));
            this.getStyleClass().add((Object)"move-to-source-all-button");
            this.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ListSelectionView.this.getOrientation() == Orientation.HORIZONTAL ? ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_DOUBLE_LEFT) : ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_DOUBLE_UP), (Observable[])new Observable[]{ListSelectionView.this.orientationProperty()}));
            this.setAccelerator(KeyCombination.keyCombination((String)"CTRL+SHIFT+LEFT"));
        }

        @Override
        public void initialize(ListView<T> listView, ListView<T> listView2) {
            this.disabledProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)listView2.getItems()));
            this.setEventHandler(actionEvent -> ListSelectionView.moveToSourceAll(listView, listView2));
        }
    }

    public class MoveToSource
    extends ListSelectionAction<T> {
        public MoveToSource() {
            super((Node)ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_LEFT));
            this.getStyleClass().add((Object)"move-to-source-button");
            this.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ListSelectionView.this.getOrientation() == Orientation.HORIZONTAL ? ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_LEFT) : ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_UP), (Observable[])new Observable[]{ListSelectionView.this.orientationProperty()}));
            this.setAccelerator(KeyCombination.keyCombination((String)"CTRL+LEFT"));
        }

        @Override
        public void initialize(ListView<T> listView, ListView<T> listView2) {
            this.disabledProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)listView2.getSelectionModel().getSelectedItems()));
            this.setEventHandler(actionEvent -> ListSelectionView.moveToSource(listView, listView2));
        }
    }

    public class MoveToTargetAll
    extends ListSelectionAction<T> {
        public MoveToTargetAll() {
            super((Node)ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_DOUBLE_RIGHT));
            this.getStyleClass().add((Object)"move-to-target-all-button");
            this.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ListSelectionView.this.getOrientation() == Orientation.HORIZONTAL ? ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_DOUBLE_RIGHT) : ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_DOUBLE_DOWN), (Observable[])new Observable[]{ListSelectionView.this.orientationProperty()}));
            this.setAccelerator(KeyCombination.keyCombination((String)"CTRL+SHIFT+RIGHT"));
        }

        @Override
        public void initialize(ListView<T> listView, ListView<T> listView2) {
            this.disabledProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)listView.getItems()));
            this.setEventHandler(actionEvent -> ListSelectionView.moveToTargetAll(listView, listView2));
        }
    }

    public class MoveToTarget
    extends ListSelectionAction<T> {
        public MoveToTarget() {
            super((Node)ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_RIGHT));
            this.getStyleClass().add((Object)"move-to-target-button");
            this.setAccelerator(KeyCombination.keyCombination((String)"CTRL+RIGHT"));
            this.graphicProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ListSelectionView.this.getOrientation() == Orientation.HORIZONTAL ? ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_RIGHT) : ListSelectionView.getGlyph(FontAwesome.Glyph.ANGLE_DOWN), (Observable[])new Observable[]{ListSelectionView.this.orientationProperty()}));
        }

        @Override
        public void initialize(ListView<T> listView, ListView<T> listView2) {
            this.disabledProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)listView.getSelectionModel().getSelectedItems()));
            this.setEventHandler(actionEvent -> ListSelectionView.moveToTarget(listView, listView2));
        }
    }

    public static abstract class ListSelectionAction<T>
    extends Action {
        public ListSelectionAction(Node node) {
            this(node, "");
        }

        public ListSelectionAction(Node node, String string) {
            super(string);
            this.setGraphic(node);
        }

        public abstract void initialize(ListView<T> var1, ListView<T> var2);

        @Override
        protected final void setEventHandler(Consumer<ActionEvent> consumer) {
            super.setEventHandler(consumer);
        }
    }
}

