/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.controlsfx.control.CheckBitSetModelBase;
import org.controlsfx.control.IndexedCheckModel;

public class CheckListView<T>
extends ListView<T> {
    private final Map<T, BooleanProperty> itemBooleanMap;
    private ObjectProperty<IndexedCheckModel<T>> checkModel = new SimpleObjectProperty((Object)this, "checkModel");

    public CheckListView() {
        this(FXCollections.observableArrayList());
    }

    public CheckListView(ObservableList<T> observableList) {
        super(observableList);
        this.itemBooleanMap = new HashMap<T, BooleanProperty>();
        this.setCheckModel(new CheckListViewBitSetCheckModel<T>(this.getItems(), this.itemBooleanMap));
        this.itemsProperty().addListener(observable -> this.setCheckModel(new CheckListViewBitSetCheckModel<T>(this.getItems(), this.itemBooleanMap)));
        this.setCellFactory(listView -> {
            CheckBoxListCell checkBoxListCell = new CheckBoxListCell(object -> this.getItemBooleanProperty(object));
            checkBoxListCell.focusedProperty().addListener((observableValue, bl2, bl3) -> {
                Parent parent;
                if (bl3.booleanValue() && (parent = checkBoxListCell.getParent()) != null) {
                    parent.requestFocus();
                }
            });
            return checkBoxListCell;
        });
        this.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            IndexedCheckModel<Object> indexedCheckModel;
            Object object;
            if (keyEvent.getCode() == KeyCode.SPACE && (object = this.getSelectionModel().getSelectedItem()) != null && (indexedCheckModel = this.getCheckModel()) != null) {
                if (indexedCheckModel.isChecked(object)) {
                    indexedCheckModel.clearCheck(object);
                } else {
                    indexedCheckModel.check(object);
                }
            }
        });
    }

    public BooleanProperty getItemBooleanProperty(int n2) {
        if (n2 < 0 || n2 >= this.getItems().size()) {
            return null;
        }
        return this.getItemBooleanProperty(this.getItems().get(n2));
    }

    public BooleanProperty getItemBooleanProperty(T t2) {
        return this.itemBooleanMap.get(t2);
    }

    public final void setCheckModel(IndexedCheckModel<T> indexedCheckModel) {
        this.checkModelProperty().set(indexedCheckModel);
    }

    public final IndexedCheckModel<T> getCheckModel() {
        return this.checkModel == null ? null : (IndexedCheckModel)this.checkModel.get();
    }

    public final ObjectProperty<IndexedCheckModel<T>> checkModelProperty() {
        return this.checkModel;
    }

    private static class CheckListViewBitSetCheckModel<T>
    extends CheckBitSetModelBase<T> {
        private final ObservableList<T> items;

        CheckListViewBitSetCheckModel(ObservableList<T> observableList, Map<T, BooleanProperty> map) {
            super(map);
            this.items = observableList;
            this.items.addListener(change -> this.updateMap());
            this.updateMap();
        }

        @Override
        public T getItem(int n2) {
            return (T)this.items.get(n2);
        }

        @Override
        public int getItemCount() {
            return this.items.size();
        }

        @Override
        public int getItemIndex(T t2) {
            return this.items.indexOf(t2);
        }
    }
}

