/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import org.agrona.concurrent.IdleStrategy;

public final class SleepingMillisIdleStrategy
implements IdleStrategy {
    public static final String ALIAS = "sleep-ms";
    public static final long DEFAULT_SLEEP_PERIOD_MS = 1L;
    private final long sleepPeriodMs;

    public SleepingMillisIdleStrategy() {
        this.sleepPeriodMs = 1L;
    }

    public SleepingMillisIdleStrategy(long l2) {
        this.sleepPeriodMs = l2;
    }

    @Override
    public void idle(int n2) {
        if (n2 > 0) {
            return;
        }
        try {
            Thread.sleep(this.sleepPeriodMs);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void idle() {
        try {
            Thread.sleep(this.sleepPeriodMs);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public String alias() {
        return ALIAS;
    }

    public String toString() {
        return "SleepingMillisIdleStrategy{alias=sleep-ms, sleepPeriodMs=" + this.sleepPeriodMs + "}";
    }
}

