/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Object2ObjectHashMap<K, V>
implements Map<K, V> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private Object[] entries;
    private KeySet keySet;
    private ValueCollection valueCollection;
    private EntrySet entrySet;

    public Object2ObjectHashMap() {
        this(8, 0.65f);
    }

    public Object2ObjectHashMap(int n2, float f2) {
        this(n2, f2, true);
    }

    public Object2ObjectHashMap(int n2, float f2, boolean bl2) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        this.shouldAvoidAllocation = bl2;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public Object2ObjectHashMap(Object2ObjectHashMap<K, V> object2ObjectHashMap) {
        this.loadFactor = object2ObjectHashMap.loadFactor;
        this.resizeThreshold = object2ObjectHashMap.resizeThreshold;
        this.size = object2ObjectHashMap.size;
        this.shouldAvoidAllocation = object2ObjectHashMap.shouldAvoidAllocation;
        this.entries = (Object[])object2ObjectHashMap.entries.clone();
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object object) {
        return this.unmapNullValue(this.getMapped(object));
    }

    private V getMapped(Object object) {
        Object object2;
        Objects.requireNonNull(object);
        Object[] objectArray = this.entries;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.evenHash(object.hashCode(), n2);
        while (null != (object2 = objectArray[n3 + 1]) && !Objects.equals(objectArray[n3], object)) {
            n3 = Object2ObjectHashMap.next(n3, n2);
        }
        return (V)object2;
    }

    @Override
    public V put(K k2, V v2) {
        Object object;
        Object object2 = this.mapNullValue(v2);
        Objects.requireNonNull(object2, "value cannot be null");
        Object[] objectArray = this.entries;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.evenHash(k2.hashCode(), n2);
        while (null != (object = objectArray[n3 + 1]) && !Objects.equals(objectArray[n3], k2)) {
            n3 = Object2ObjectHashMap.next(n3, n2);
        }
        if (null == object) {
            ++this.size;
            objectArray[n3] = k2;
        }
        objectArray[n3 + 1] = object2;
        this.increaseCapacity();
        return this.unmapNullValue(object);
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int n2 = this.entries.length;
            this.rehash(n2);
        }
    }

    private void rehash(int n2) {
        Object[] objectArray = this.entries;
        int n3 = this.entries.length;
        this.capacity(n2);
        Object[] objectArray2 = this.entries;
        int n4 = this.entries.length - 1;
        for (int i2 = 0; i2 < n3; i2 += 2) {
            Object object = objectArray[i2 + 1];
            if (null == object) continue;
            Object object2 = objectArray[i2];
            int n5 = Hashing.evenHash(object2.hashCode(), n4);
            while (null != objectArray2[n5 + 1]) {
                n5 = Object2ObjectHashMap.next(n5, n4);
            }
            objectArray2[n5] = object2;
            objectArray2[n5 + 1] = object;
        }
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = this.mapNullValue(object);
        boolean bl2 = false;
        if (null != object2) {
            Object[] objectArray = this.entries;
            int n2 = objectArray.length;
            for (int i2 = 1; i2 < n2; i2 += 2) {
                Object object3 = objectArray[i2];
                if (null == object3 || !Objects.equals(object3, object2)) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, null);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        int n2 = this.size;
        Object[] objectArray = this.entries;
        int n3 = objectArray.length;
        for (int i2 = 1; n2 > 0 && i2 < n3; i2 += 2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            biConsumer.accept(objectArray[i2 - 1], this.unmapNullValue(object));
            --n2;
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return null != this.getMapped(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V remove(Object object) {
        Object object2;
        Object[] objectArray = this.entries;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.evenHash(object.hashCode(), n2);
        while (null != (object2 = objectArray[n3 + 1])) {
            if (Objects.equals(objectArray[n3], object)) {
                objectArray[n3] = null;
                objectArray[n3 + 1] = null;
                --this.size;
                this.compactChain(n3);
                break;
            }
            n3 = Object2ObjectHashMap.next(n3, n2);
        }
        return this.unmapNullValue(object2);
    }

    private void compactChain(int n2) {
        Object object;
        Object[] objectArray = this.entries;
        int n3 = objectArray.length - 1;
        int n4 = n2;
        while (null != (object = objectArray[(n4 = Object2ObjectHashMap.next(n4, n3)) + 1])) {
            Object object2 = objectArray[n4];
            int n5 = Hashing.evenHash(object2.hashCode(), n3);
            if ((n4 >= n5 || n5 > n2 && n2 > n4) && (n5 > n2 || n2 > n4)) continue;
            objectArray[n2] = object2;
            objectArray[n2 + 1] = object;
            objectArray[n4] = null;
            objectArray[n4 + 1] = null;
            n2 = n4;
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder stringBuilder = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            stringBuilder.append(entryIterator.getKey()).append('=').append(this.unmapNullValue(entryIterator.getValue()));
            if (!entryIterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        return this.size == map.size() && this.entrySet().equals(map.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public V computeIfAbsent(K k2, Function<? super K, ? extends V> function) {
        Object object;
        Object[] objectArray = this.entries;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.evenHash(k2.hashCode(), n2);
        while (null != (object = objectArray[n3 + 1]) && !Objects.equals(objectArray[n3], k2)) {
            n3 = Object2ObjectHashMap.next(n3, n2);
        }
        V v2 = this.unmapNullValue(object);
        if (v2 == null && (v2 = function.apply(k2)) != null) {
            objectArray[n3 + 1] = v2;
            if (object == null) {
                objectArray[n3] = k2;
                ++this.size;
                this.increaseCapacity();
            }
        }
        return v2;
    }

    @Override
    public V computeIfPresent(K k2, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Object object;
        Object[] objectArray = this.entries;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.evenHash(k2.hashCode(), n2);
        while (null != (object = objectArray[n3 + 1]) && !Objects.equals(objectArray[n3], k2)) {
            n3 = Object2ObjectHashMap.next(n3, n2);
        }
        V v2 = this.unmapNullValue(object);
        if (v2 != null) {
            v2 = biFunction.apply(k2, v2);
            objectArray[n3 + 1] = v2;
            if (v2 == null) {
                objectArray[n3] = null;
                --this.size;
                this.compactChain(n3);
            }
        }
        return v2;
    }

    @Override
    public V compute(K k2, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Object object;
        Object[] objectArray = this.entries;
        int n2 = objectArray.length - 1;
        int n3 = Hashing.evenHash(k2.hashCode(), n2);
        while (null != (object = objectArray[n3 + 1]) && !Objects.equals(objectArray[n3], k2)) {
            n3 = Object2ObjectHashMap.next(n3, n2);
        }
        V v2 = this.unmapNullValue(object);
        V v3 = biFunction.apply(k2, v2);
        if (v3 != null) {
            objectArray[n3 + 1] = v3;
            if (object == null) {
                objectArray[n3] = k2;
                ++this.size;
                this.increaseCapacity();
            }
        } else if (object != null) {
            objectArray[n3] = null;
            objectArray[n3 + 1] = null;
            --this.size;
            this.compactChain(n3);
        }
        return v3;
    }

    protected Object mapNullValue(Object object) {
        return object;
    }

    protected V unmapNullValue(Object object) {
        return (V)object;
    }

    private static int next(int n2, int n3) {
        return n2 + 2 & n3;
    }

    private void capacity(int n2) {
        int n3 = n2 * 2;
        if (n3 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        this.entries = new Object[n3];
    }

    public final class KeySet
    extends AbstractSet<K> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Object2ObjectHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Object2ObjectHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Object2ObjectHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Object2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return Object2ObjectHashMap.this.containsKey(object);
        }

        @Override
        public void forEach(Consumer<? super K> consumer) {
            int n2 = Object2ObjectHashMap.this.size;
            Object[] objectArray = Object2ObjectHashMap.this.entries;
            int n3 = objectArray.length;
            for (int i2 = 1; n2 > 0 && i2 < n3; i2 += 2) {
                if (null == objectArray[i2]) continue;
                consumer.accept(objectArray[i2 - 1]);
                --n2;
            }
        }
    }

    public final class ValueCollection
    extends AbstractCollection<V> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Object2ObjectHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Object2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Object2ObjectHashMap.this.containsValue(object);
        }

        @Override
        public void forEach(Consumer<? super V> consumer) {
            int n2 = Object2ObjectHashMap.this.size;
            Object[] objectArray = Object2ObjectHashMap.this.entries;
            int n3 = objectArray.length;
            for (int i2 = 1; n2 > 0 && i2 < n3; i2 += 2) {
                Object object = objectArray[i2];
                if (null == object) continue;
                consumer.accept(Object2ObjectHashMap.this.unmapNullValue(object));
                --n2;
            }
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Object2ObjectHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Object2ObjectHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Object2ObjectHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Object2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v2 = Object2ObjectHashMap.this.getMapped(entry.getKey());
            return null != v2 && Objects.equals(v2, Object2ObjectHashMap.this.mapNullValue(entry.getValue()));
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = TArray.length >= Object2ObjectHashMap.this.size ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), Object2ObjectHashMap.this.size);
            EntryIterator entryIterator = this.iterator();
            for (int i2 = 0; i2 < TArray2.length; ++i2) {
                if (!entryIterator.hasNext()) {
                    TArray2[i2] = null;
                    break;
                }
                entryIterator.next();
                TArray2[i2] = entryIterator.allocateDuplicateEntry();
            }
            return TArray2;
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<K, V>>,
    Map.Entry<K, V> {
        @Override
        public K getKey() {
            return Object2ObjectHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public V getValue() {
            return Object2ObjectHashMap.this.unmapNullValue(Object2ObjectHashMap.this.entries[this.keyPosition() + 1]);
        }

        @Override
        public V setValue(V v2) {
            Object object = Object2ObjectHashMap.this.mapNullValue(v2);
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (null == object) {
                throw new IllegalArgumentException();
            }
            int n2 = this.keyPosition();
            Object[] objectArray = Object2ObjectHashMap.this.entries;
            Object object2 = objectArray[n2 + 1];
            objectArray[n2 + 1] = object;
            return Object2ObjectHashMap.this.unmapNullValue(object2);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.findNext();
            if (Object2ObjectHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<K, V> allocateDuplicateEntry() {
            return new MapEntry(this.getKey(), this.getValue());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ Objects.hashCode(this.getValue());
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.getKey(), entry.getKey()) && Objects.equals(this.getValue(), entry.getValue());
        }

        public final class MapEntry
        implements Map.Entry<K, V> {
            private final K k;
            private V v;

            public MapEntry(K k2, V v2) {
                this.k = k2;
                this.v = v2;
            }

            @Override
            public K getKey() {
                return this.k;
            }

            @Override
            public V getValue() {
                return this.v;
            }

            @Override
            public V setValue(V v2) {
                Object v3 = Object2ObjectHashMap.this.put(this.k, v2);
                this.v = v2;
                return v3;
            }

            @Override
            public int hashCode() {
                return this.k.hashCode() ^ Objects.hashCode(this.v);
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return Objects.equals(this.k, entry.getKey()) && Objects.equals(this.v, entry.getValue());
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Object2ObjectHashMap.this.unmapNullValue(Object2ObjectHashMap.this.entries[this.keyPosition() + 1]);
        }
    }

    public final class KeyIterator
    extends AbstractIterator
    implements Iterator<K> {
        @Override
        public K next() {
            this.findNext();
            return Object2ObjectHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator {
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int n2;
            this.isPositionValid = false;
            this.remaining = Object2ObjectHashMap.this.size;
            Object[] objectArray = Object2ObjectHashMap.this.entries;
            int n3 = n2 = objectArray.length;
            if (null != objectArray[n2 - 1]) {
                for (int i2 = 1; i2 < n2; i2 += 2) {
                    if (null != objectArray[i2]) continue;
                    n3 = i2 - 1;
                    break;
                }
            }
            this.stopCounter = n3;
            this.positionCounter = n3 + n2;
        }

        final int keyPosition() {
            return this.positionCounter & Object2ObjectHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = Object2ObjectHashMap.this.entries;
            int n2 = objectArray.length - 1;
            for (int i2 = this.positionCounter - 2; i2 >= this.stopCounter; i2 -= 2) {
                int n3 = i2 & n2;
                if (null == objectArray[n3 + 1]) continue;
                this.isPositionValid = true;
                this.positionCounter = i2;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            int n2;
            if (this.isPositionValid) {
                n2 = this.keyPosition();
                Object[] objectArray = Object2ObjectHashMap.this.entries;
                objectArray[n2] = null;
                objectArray[n2 + 1] = null;
                --Object2ObjectHashMap.this.size;
            } else {
                throw new IllegalStateException();
            }
            Object2ObjectHashMap.this.compactChain(n2);
            this.isPositionValid = false;
        }
    }
}

