/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntObjConsumer;
import org.agrona.collections.IntObjPredicate;
import org.agrona.collections.IntObjectToObjectFunction;

public class Int2ObjectHashMap<V>
implements Map<Integer, V> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private final boolean shouldAvoidAllocation;
    private int[] keys;
    private Object[] values;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Int2ObjectHashMap() {
        this(8, 0.65f, true);
    }

    public Int2ObjectHashMap(int n2, float f2) {
        this(n2, f2, true);
    }

    public Int2ObjectHashMap(int n2, float f2, boolean bl2) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        this.shouldAvoidAllocation = bl2;
        int n3 = BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2));
        this.resizeThreshold = (int)((float)n3 * f2);
        this.keys = new int[n3];
        this.values = new Object[n3];
    }

    public Int2ObjectHashMap(Int2ObjectHashMap<V> int2ObjectHashMap) {
        this.loadFactor = int2ObjectHashMap.loadFactor;
        this.resizeThreshold = int2ObjectHashMap.resizeThreshold;
        this.size = int2ObjectHashMap.size;
        this.shouldAvoidAllocation = int2ObjectHashMap.shouldAvoidAllocation;
        this.keys = (int[])int2ObjectHashMap.keys.clone();
        this.values = (Object[])int2ObjectHashMap.values.clone();
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super V> biConsumer) {
        this.forEachInt(biConsumer::accept);
    }

    @Deprecated
    public void intForEach(IntObjConsumer<V> intObjConsumer) {
        this.forEachInt(intObjConsumer);
    }

    public void forEachInt(IntObjConsumer<V> intObjConsumer) {
        Objects.requireNonNull(intObjConsumer);
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            intObjConsumer.accept(nArray[i2], this.unmapNullValue(object));
            --n3;
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey((Integer)object);
    }

    public boolean containsKey(int n2) {
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        boolean bl2 = false;
        while (null != objectArray[n4]) {
            if (n2 == nArray[n4]) {
                bl2 = true;
                break;
            }
            ++n4;
            n4 &= n3;
        }
        return bl2;
    }

    @Override
    public boolean containsValue(Object object) {
        boolean bl2 = false;
        Object object2 = this.mapNullValue(object);
        if (null != object2) {
            Object[] objectArray = this.values;
            int n2 = objectArray.length;
            int n3 = this.size;
            for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
                Object object3 = objectArray[i2];
                if (null == object3) continue;
                if (Objects.equals(object3, object2)) {
                    bl2 = true;
                    break;
                }
                --n3;
            }
        }
        return bl2;
    }

    @Override
    public V get(Object object) {
        return this.get((Integer)object);
    }

    public V get(int n2) {
        return this.unmapNullValue(this.getMapped(n2));
    }

    public V getOrDefault(int n2, V v2) {
        V v3 = this.getMapped(n2);
        return null != v3 ? this.unmapNullValue(v3) : v2;
    }

    protected V getMapped(int n2) {
        Object object;
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        while (null != (object = objectArray[n4]) && n2 != nArray[n4]) {
            ++n4;
            n4 &= n3;
        }
        return (V)object;
    }

    @Override
    public V computeIfAbsent(Integer n2, Function<? super Integer, ? extends V> function) {
        return (V)this.computeIfAbsent((int)n2, function::apply);
    }

    public V computeIfAbsent(int n2, IntFunction<? extends V> intFunction) {
        Object object;
        Objects.requireNonNull(intFunction);
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        while (null != (object = objectArray[n4]) && n2 != nArray[n4]) {
            ++n4;
            n4 &= n3;
        }
        V v2 = this.unmapNullValue(object);
        if (null == v2 && (v2 = intFunction.apply(n2)) != null) {
            objectArray[n4] = v2;
            if (null == object) {
                nArray[n4] = n2;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        }
        return v2;
    }

    @Override
    public V computeIfPresent(Integer n2, BiFunction<? super Integer, ? super V, ? extends V> biFunction) {
        return (V)this.computeIfPresent((int)n2, biFunction::apply);
    }

    public V computeIfPresent(int n2, IntObjectToObjectFunction<? super V, ? extends V> intObjectToObjectFunction) {
        Object object;
        Objects.requireNonNull(intObjectToObjectFunction);
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        while (null != (object = objectArray[n4]) && n2 != nArray[n4]) {
            ++n4;
            n4 &= n3;
        }
        V v2 = this.unmapNullValue(object);
        if (null != v2) {
            v2 = intObjectToObjectFunction.apply(n2, v2);
            objectArray[n4] = v2;
            if (null == v2) {
                --this.size;
                this.compactChain(n4);
            }
        }
        return v2;
    }

    @Override
    public V compute(Integer n2, BiFunction<? super Integer, ? super V, ? extends V> biFunction) {
        return (V)this.compute((int)n2, biFunction::apply);
    }

    public V compute(int n2, IntObjectToObjectFunction<? super V, ? extends V> intObjectToObjectFunction) {
        Object object;
        Objects.requireNonNull(intObjectToObjectFunction);
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        while (null != (object = objectArray[n4]) && n2 != nArray[n4]) {
            ++n4;
            n4 &= n3;
        }
        V v2 = intObjectToObjectFunction.apply(n2, this.unmapNullValue(object));
        if (null != v2) {
            objectArray[n4] = v2;
            if (null == object) {
                nArray[n4] = n2;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (null != object) {
            objectArray[n4] = null;
            --this.size;
            this.compactChain(n4);
        }
        return v2;
    }

    @Override
    public V merge(Integer n2, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        return this.merge((int)n2, v2, biFunction);
    }

    @Override
    public V merge(int n2, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        V v3;
        Object object;
        Objects.requireNonNull(v2);
        Objects.requireNonNull(biFunction);
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        while (null != (object = objectArray[n4]) && n2 != nArray[n4]) {
            ++n4;
            n4 &= n3;
        }
        V v4 = this.unmapNullValue(object);
        V v5 = v3 = null == v4 ? v2 : biFunction.apply(v4, v2);
        if (null != v3) {
            objectArray[n4] = v3;
            if (null == object) {
                nArray[n4] = n2;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (null != object) {
            objectArray[n4] = null;
            --this.size;
            this.compactChain(n4);
        }
        return v3;
    }

    @Override
    public V put(Integer n2, V v2) {
        return this.put((int)n2, v2);
    }

    @Override
    public V put(int n2, V v2) {
        Object object;
        Object object2 = this.mapNullValue(v2);
        Objects.requireNonNull(object2, "value cannot be null");
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        while (null != (object = objectArray[n4]) && n2 != nArray[n4]) {
            ++n4;
            n4 &= n3;
        }
        if (null == object) {
            ++this.size;
            nArray[n4] = n2;
        }
        objectArray[n4] = object2;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return this.unmapNullValue(object);
    }

    @Override
    public V remove(Object object) {
        return this.remove((Integer)object);
    }

    public V remove(int n2) {
        Object object;
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        while (null != (object = objectArray[n4])) {
            if (n2 == nArray[n4]) {
                objectArray[n4] = null;
                --this.size;
                this.compactChain(n4);
                break;
            }
            ++n4;
            n4 &= n3;
        }
        return this.unmapNullValue(object);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.remove((Integer)object, object2);
    }

    public boolean remove(int n2, V v2) {
        Object object = this.mapNullValue(v2);
        if (null != object) {
            Object object2;
            int[] nArray = this.keys;
            Object[] objectArray = this.values;
            int n3 = objectArray.length - 1;
            int n4 = Hashing.hash(n2, n3);
            while (null != (object2 = objectArray[n4])) {
                if (n2 == nArray[n4]) {
                    if (!Objects.equals(this.unmapNullValue(object2), v2)) break;
                    objectArray[n4] = null;
                    --this.size;
                    this.compactChain(n4);
                    return true;
                }
                ++n4;
                n4 &= n3;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.values, null);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Int2ObjectHashMap<? extends V> int2ObjectHashMap) {
        EntryIterator entryIterator = int2ObjectHashMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            entryIterator.findNext();
            this.put(entryIterator.getIntKey(), (V)entryIterator.getValue());
        }
    }

    @Override
    public V putIfAbsent(int n2, V v2) {
        Object object;
        Object object2 = this.mapNullValue(v2);
        Objects.requireNonNull(object2, "value cannot be null");
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        while (null != (object = objectArray[n4]) && n2 != nArray[n4]) {
            ++n4;
            n4 &= n3;
        }
        V v3 = this.unmapNullValue(object);
        if (null == v3) {
            if (null == object) {
                ++this.size;
                nArray[n4] = n2;
            }
            objectArray[n4] = object2;
            if (this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        }
        return v3;
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder stringBuilder = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            stringBuilder.append(entryIterator.getIntKey()).append('=').append(this.unmapNullValue(entryIterator.getValue()));
            if (!entryIterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size != map.size()) {
            return false;
        }
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object v2;
            Object object2 = objectArray[i2];
            if (null == object2 || object2.equals(this.mapNullValue(v2 = map.get(nArray[i2])))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            n2 += Integer.hashCode(nArray[i2]) ^ object.hashCode();
        }
        return n2;
    }

    protected Object mapNullValue(Object object) {
        return object;
    }

    protected V unmapNullValue(Object object) {
        return (V)object;
    }

    @Override
    public V replace(int n2, V v2) {
        Object object;
        Object object2 = this.mapNullValue(v2);
        Objects.requireNonNull(object2, "value cannot be null");
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        while (null != (object = objectArray[n4])) {
            if (n2 == nArray[n4]) {
                objectArray[n4] = object2;
                break;
            }
            ++n4;
            n4 &= n3;
        }
        return this.unmapNullValue(object);
    }

    @Override
    public boolean replace(int n2, V v2, V v3) {
        Object object;
        Object object2 = this.mapNullValue(v3);
        Objects.requireNonNull(object2, "value cannot be null");
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = Hashing.hash(n2, n3);
        while (null != (object = objectArray[n4])) {
            if (n2 == nArray[n4]) {
                if (!Objects.equals(this.unmapNullValue(object), v2)) break;
                objectArray[n4] = object2;
                return true;
            }
            ++n4;
            n4 &= n3;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super V, ? extends V> biFunction) {
        this.replaceAllInt(biFunction::apply);
    }

    public void replaceAllInt(IntObjectToObjectFunction<? super V, ? extends V> intObjectToObjectFunction) {
        Objects.requireNonNull(intObjectToObjectFunction);
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            Object object2 = this.mapNullValue(intObjectToObjectFunction.apply(nArray[i2], this.unmapNullValue(object)));
            Objects.requireNonNull(object2, "value cannot be null");
            objectArray[i2] = object2;
            --n3;
        }
    }

    private void increaseCapacity() {
        int n2 = this.values.length << 1;
        if (n2 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(n2);
    }

    private void rehash(int n2) {
        int n3 = n2 - 1;
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        int[] nArray = new int[n2];
        Object[] objectArray = new Object[n2];
        int[] nArray2 = this.keys;
        Object[] objectArray2 = this.values;
        int n4 = objectArray2.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            Object object = objectArray2[i2];
            if (null == object) continue;
            int n5 = nArray2[i2];
            int n6 = Hashing.hash(n5, n3);
            while (null != objectArray[n6]) {
                ++n6;
                n6 &= n3;
            }
            nArray[n6] = n5;
            objectArray[n6] = object;
        }
        this.keys = nArray;
        this.values = objectArray;
    }

    private void compactChain(int n2) {
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length - 1;
        int n4 = n2;
        while (true) {
            ++n4;
            Object object = objectArray[n4 &= n3];
            if (null == object) break;
            int n5 = nArray[n4];
            int n6 = Hashing.hash(n5, n3);
            if ((n4 >= n6 || n6 > n2 && n2 > n4) && (n6 > n2 || n2 > n4)) continue;
            nArray[n2] = n5;
            objectArray[n2] = object;
            objectArray[n4] = null;
            n2 = n4;
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Int2ObjectHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            int n2 = (Integer)entry.getKey();
            Object v2 = Int2ObjectHashMap.this.getMapped(n2);
            return null != v2 && v2.equals(Int2ObjectHashMap.this.mapNullValue(entry.getValue()));
        }

        public boolean removeIfInt(IntObjPredicate<V> intObjPredicate) {
            boolean bl2 = false;
            EntryIterator entryIterator = this.iterator();
            while (entryIterator.hasNext()) {
                entryIterator.findNext();
                if (!intObjPredicate.test(entryIterator.getIntKey(), entryIterator.getValue())) continue;
                entryIterator.remove();
                bl2 = true;
            }
            return bl2;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = TArray.length >= Int2ObjectHashMap.this.size ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), Int2ObjectHashMap.this.size);
            EntryIterator entryIterator = this.iterator();
            for (int i2 = 0; i2 < TArray2.length; ++i2) {
                if (!entryIterator.hasNext()) {
                    TArray2[i2] = null;
                    break;
                }
                entryIterator.next();
                TArray2[i2] = entryIterator.allocateDuplicateEntry();
            }
            return TArray2;
        }
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<Integer, V>>
    implements Map.Entry<Integer, V> {
        @Override
        public Map.Entry<Integer, V> next() {
            this.findNext();
            if (Int2ObjectHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Integer, V> allocateDuplicateEntry() {
            return new MapEntry(this.getIntKey(), this.getValue());
        }

        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public int getIntKey() {
            return Int2ObjectHashMap.this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return Int2ObjectHashMap.this.unmapNullValue(Int2ObjectHashMap.this.values[this.position()]);
        }

        @Override
        public V setValue(V v2) {
            Object object = Int2ObjectHashMap.this.mapNullValue(v2);
            Objects.requireNonNull(object, "value cannot be null");
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int n2 = this.position();
            Object[] objectArray = Int2ObjectHashMap.this.values;
            Object object2 = objectArray[n2];
            objectArray[n2] = object;
            return object2;
        }

        public final class MapEntry
        implements Map.Entry<Integer, V> {
            private final int k;
            private final V v;

            public MapEntry(int n2, V v2) {
                this.k = n2;
                this.v = v2;
            }

            @Override
            public Integer getKey() {
                return this.k;
            }

            @Override
            public V getValue() {
                return this.v;
            }

            @Override
            public V setValue(V v2) {
                return Int2ObjectHashMap.this.put(this.k, v2);
            }

            @Override
            public int hashCode() {
                return Integer.hashCode(EntryIterator.this.getIntKey()) ^ (null != this.v ? this.v.hashCode() : 0);
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return entry.getKey() != null && entry.getKey().equals(this.k) && (entry.getValue() == null && this.v == null || entry.getValue().equals(this.v));
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class KeySet
    extends AbstractSet<Integer> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Int2ObjectHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Int2ObjectHashMap.this.containsKey(object);
        }

        public boolean contains(int n2) {
            return Int2ObjectHashMap.this.containsKey(n2);
        }

        @Override
        public boolean remove(Object object) {
            return null != Int2ObjectHashMap.this.remove(object);
        }

        public boolean remove(int n2) {
            return null != Int2ObjectHashMap.this.remove(n2);
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }

        public boolean removeIfInt(IntPredicate intPredicate) {
            boolean bl2 = false;
            KeyIterator keyIterator = this.iterator();
            while (keyIterator.hasNext()) {
                if (!intPredicate.test(keyIterator.nextInt())) continue;
                keyIterator.remove();
                bl2 = true;
            }
            return bl2;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<V> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Int2ObjectHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Int2ObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Int2ObjectHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            Int2ObjectHashMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super V> consumer) {
            int n2 = Int2ObjectHashMap.this.size;
            Object[] objectArray = Int2ObjectHashMap.this.values;
            int n3 = objectArray.length;
            for (int i2 = 0; n2 > 0 && i2 < n3; ++i2) {
                Object object = objectArray[i2];
                if (null == object) continue;
                consumer.accept(Int2ObjectHashMap.this.unmapNullValue(object));
                --n2;
            }
        }
    }

    public final class KeyIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return Int2ObjectHashMap.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Int2ObjectHashMap.this.unmapNullValue(Int2ObjectHashMap.this.values[this.position()]);
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Int2ObjectHashMap.this.values.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = Int2ObjectHashMap.this.values;
            int n2 = objectArray.length - 1;
            int n3 = this.stopCounter;
            for (int i2 = this.posCounter - 1; i2 >= n3; --i2) {
                int n4 = i2 & n2;
                if (null == objectArray[n4]) continue;
                this.posCounter = i2;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            int n2;
            if (this.isPositionValid) {
                n2 = this.position();
                Int2ObjectHashMap.this.values[n2] = null;
                --Int2ObjectHashMap.this.size;
            } else {
                throw new IllegalStateException();
            }
            Int2ObjectHashMap.this.compactChain(n2);
            this.isPositionValid = false;
        }

        final void reset() {
            int n2;
            this.remaining = Int2ObjectHashMap.this.size;
            Object[] objectArray = Int2ObjectHashMap.this.values;
            int n3 = n2 = objectArray.length;
            if (null != objectArray[n2 - 1]) {
                for (n3 = 0; n3 < n2 && null != objectArray[n3]; ++n3) {
                }
            }
            this.stopCounter = n3;
            this.posCounter = n3 + n2;
            this.isPositionValid = false;
        }
    }
}

