/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntObjConsumer;
import org.agrona.collections.IntObjectToObjectFunction;

public class Int2ObjectCache<V>
implements Map<Integer, V> {
    private long cachePuts = 0L;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private int size;
    private final int capacity;
    private final int setSize;
    private final int setSizeShift;
    private final int mask;
    private final int[] keys;
    private final Object[] values;
    private final Consumer<V> evictionConsumer;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Int2ObjectCache(int n2, int n3, Consumer<V> consumer) {
        CollectionUtil.validatePositivePowerOfTwo(n2);
        CollectionUtil.validatePositivePowerOfTwo(n3);
        Objects.requireNonNull(consumer, "null values are not permitted");
        if ((long)n2 * (long)n3 > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("total capacity must be <= max array size: numSets=" + n2 + " setSize=" + n3);
        }
        this.setSize = n3;
        this.setSizeShift = Integer.numberOfTrailingZeros(n3);
        this.capacity = n2 << this.setSizeShift;
        this.mask = n2 - 1;
        this.keys = new int[this.capacity];
        this.values = new Object[this.capacity];
        this.evictionConsumer = consumer;
    }

    public long cacheHits() {
        return this.cacheHits;
    }

    public long cacheMisses() {
        return this.cacheMisses;
    }

    public long cachePuts() {
        return this.cachePuts;
    }

    public void resetCounters() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cachePuts = 0L;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey((Integer)object);
    }

    public boolean containsKey(int n2) {
        boolean bl2 = false;
        int n3 = Hashing.hash(n2, this.mask);
        int n4 = n3 << this.setSizeShift;
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n5 = n4 + this.setSize;
        for (int i2 = n4; i2 < n5 && null != objectArray[i2]; ++i2) {
            if (n2 != nArray[i2]) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    @Override
    public boolean containsValue(Object object) {
        boolean bl2 = false;
        if (null != object) {
            Object[] objectArray;
            for (Object object2 : objectArray = this.values) {
                if (!Objects.equals(object2, object)) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    @Override
    public V get(Object object) {
        return this.get((Integer)object);
    }

    public V get(int n2) {
        Object object;
        int n3 = Hashing.hash(n2, this.mask);
        int n4 = n3 << this.setSizeShift;
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n5 = n4 + this.setSize;
        for (int i2 = n4; i2 < n5 && null != (object = objectArray[i2]); ++i2) {
            if (n2 != nArray[i2]) continue;
            ++this.cacheHits;
            return (V)object;
        }
        ++this.cacheMisses;
        return null;
    }

    public V getOrDefault(int n2, V v2) {
        V v3 = this.get(n2);
        return null != v3 ? v3 : v2;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super V> biConsumer) {
        this.forEachInt(biConsumer::accept);
    }

    public void forEachInt(IntObjConsumer<? super V> intObjConsumer) {
        Objects.requireNonNull(intObjConsumer);
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            intObjConsumer.accept(nArray[i2], object);
            --n3;
        }
    }

    @Override
    public V computeIfAbsent(Integer n2, Function<? super Integer, ? extends V> function) {
        return (V)this.computeIfAbsent((int)n2, function::apply);
    }

    public V computeIfAbsent(int n2, IntFunction<? extends V> intFunction) {
        Objects.requireNonNull(intFunction);
        V v2 = this.get(n2);
        if (null == v2 && null != (v2 = intFunction.apply(n2))) {
            this.put(n2, v2);
        }
        return v2;
    }

    @Override
    public V computeIfPresent(Integer n2, BiFunction<? super Integer, ? super V, ? extends V> biFunction) {
        return (V)this.computeIfPresent((int)n2, biFunction::apply);
    }

    public V computeIfPresent(int n2, IntObjectToObjectFunction<? super V, ? extends V> intObjectToObjectFunction) {
        Objects.requireNonNull(intObjectToObjectFunction);
        V v2 = this.get(n2);
        if (null != v2) {
            V v3 = intObjectToObjectFunction.apply(n2, v2);
            if (null != v3) {
                this.put(n2, v3);
                return v3;
            }
            this.remove(n2);
            return null;
        }
        return null;
    }

    @Override
    public V compute(Integer n2, BiFunction<? super Integer, ? super V, ? extends V> biFunction) {
        return (V)this.compute((int)n2, biFunction::apply);
    }

    public V compute(int n2, IntObjectToObjectFunction<? super V, ? extends V> intObjectToObjectFunction) {
        V v2 = this.get(n2);
        V v3 = intObjectToObjectFunction.apply(n2, v2);
        if (null != v3) {
            this.put(n2, v3);
            return v3;
        }
        if (null != v2) {
            this.remove(n2);
        }
        return null;
    }

    @Override
    public V merge(Integer n2, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        return this.merge((int)n2, v2, biFunction);
    }

    @Override
    public V merge(int n2, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        V v3;
        Objects.requireNonNull(v2);
        Objects.requireNonNull(biFunction);
        V v4 = this.get(n2);
        V v5 = v3 = null == v4 ? v2 : biFunction.apply(v4, v2);
        if (null != v3) {
            this.put(n2, v3);
            return v3;
        }
        this.remove(n2);
        return null;
    }

    @Override
    public V putIfAbsent(Integer n2, V v2) {
        return this.putIfAbsent((int)n2, v2);
    }

    @Override
    public V putIfAbsent(int n2, V v2) {
        V v3 = this.get(n2);
        if (null == v3) {
            this.put(n2, v2);
            return null;
        }
        return v3;
    }

    @Override
    public V put(Integer n2, V v2) {
        return this.put((int)n2, v2);
    }

    @Override
    public V put(int n2, V v2) {
        int n3;
        Objects.requireNonNull(v2, "null values are not supported");
        int n4 = Hashing.hash(n2, this.mask);
        Object[] objectArray = this.values;
        int[] nArray = this.keys;
        Object object = null;
        int n5 = n3 + this.setSize;
        for (int i2 = n3 = n4 << this.setSizeShift; i2 < n5 && null != (object = objectArray[i2]); ++i2) {
            if (n2 != nArray[i2]) continue;
            this.shuffleUp(i2, n5 - 1);
            break;
        }
        if (null == object) {
            object = objectArray[n3 + (this.setSize - 1)];
        }
        this.shuffleDown(n3);
        nArray[n3] = n2;
        objectArray[n3] = v2;
        ++this.cachePuts;
        if (null != object) {
            this.evictionConsumer.accept(object);
        } else {
            ++this.size;
        }
        return null;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.remove((Integer)object, object2);
    }

    public boolean remove(int n2, V v2) {
        V v3 = this.get(n2);
        if (null != v3 && Objects.equals(v3, v2)) {
            this.remove(n2);
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object object) {
        return this.remove((Integer)object);
    }

    public V remove(int n2) {
        int n3 = Hashing.hash(n2, this.mask);
        int n4 = n3 << this.setSizeShift;
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        Object object = null;
        int n5 = n4 + this.setSize;
        for (int i2 = n4; i2 < n5 && null != (object = objectArray[i2]); ++i2) {
            if (n2 != nArray[i2]) continue;
            this.shuffleUp(i2, n5 - 1);
            --this.size;
            this.evictionConsumer.accept(object);
            break;
        }
        return (V)object;
    }

    @Override
    public boolean replace(Integer n2, V v2, V v3) {
        return this.replace((int)n2, v2, v3);
    }

    @Override
    public boolean replace(int n2, V v2, V v3) {
        V v4 = this.get(n2);
        if (null != v4 && Objects.equals(v4, v2)) {
            this.put(n2, v3);
            return true;
        }
        return false;
    }

    @Override
    public V replace(Integer n2, V v2) {
        return this.replace((int)n2, v2);
    }

    @Override
    public V replace(int n2, V v2) {
        V v3 = this.get(n2);
        if (null != v3) {
            this.put(n2, v2);
        }
        return v3;
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super V, ? extends V> biFunction) {
        this.replaceAllInt(biFunction::apply);
    }

    public void replaceAllInt(IntObjectToObjectFunction<? super V, ? extends V> intObjectToObjectFunction) {
        Objects.requireNonNull(intObjectToObjectFunction);
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            V v2 = intObjectToObjectFunction.apply(nArray[i2], object);
            Objects.requireNonNull(v2, "null values are not supported");
            objectArray[i2] = v2;
            --n3;
        }
    }

    private void shuffleUp(int n2, int n3) {
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        for (int i2 = n2; i2 < n3; ++i2) {
            objectArray[i2] = objectArray[i2 + 1];
            nArray[i2] = nArray[i2 + 1];
        }
        objectArray[n3] = null;
    }

    private void shuffleDown(int n2) {
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        for (int i2 = n2 + (this.setSize - 1); i2 > n2; --i2) {
            objectArray[i2] = objectArray[i2 - 1];
            nArray[i2] = nArray[i2 - 1];
        }
        objectArray[n2] = null;
    }

    @Override
    public void clear() {
        for (Object object : this.values) {
            if (null == object) continue;
            var1_1[var2_2] = null;
            --this.size;
            this.evictionConsumer.accept(object);
        }
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Int2ObjectCache<? extends V> int2ObjectCache) {
        EntryIterator entryIterator = int2ObjectCache.entrySet().iterator();
        while (entryIterator.hasNext()) {
            entryIterator.findNext();
            this.put(entryIterator.getIntKey(), (V)entryIterator.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            stringBuilder.append(nArray[i2]).append('=').append(object).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size != map.size()) {
            return false;
        }
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object v2;
            Object object2 = objectArray[i2];
            if (null == object2 || object2.equals(v2 = map.get(nArray[i2]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int[] nArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            n2 += Integer.hashCode(nArray[i2]) ^ object.hashCode();
        }
        return n2;
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>> {
        private final EntryIterator iterator;

        public EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        public int size() {
            return Int2ObjectCache.this.size();
        }

        public EntryIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Int2ObjectCache.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException("Cannot remove from EntrySet");
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<Integer, V>> predicate) {
            throw new UnsupportedOperationException("Cannot remove from EntrySet");
        }
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<Integer, V>>
    implements Map.Entry<Integer, V> {
        @Override
        public Map.Entry<Integer, V> next() {
            this.findNext();
            return this;
        }

        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public int getIntKey() {
            return Int2ObjectCache.this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return Int2ObjectCache.this.values[this.position()];
        }

        @Override
        public V setValue(V v2) {
            throw new UnsupportedOperationException("no set on this iterator");
        }
    }

    public final class KeySet
    extends AbstractSet<Integer> {
        private final KeyIterator iterator;

        public KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        public int size() {
            return Int2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Int2ObjectCache.this.containsKey(object);
        }

        public boolean contains(int n2) {
            return Int2ObjectCache.this.containsKey(n2);
        }

        public KeyIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException("Cannot remove from KeySet");
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> predicate) {
            throw new UnsupportedOperationException("Cannot remove from KeySet");
        }

        @Override
        public void clear() {
            Int2ObjectCache.this.clear();
        }
    }

    public final class ValueCollection
    extends AbstractCollection<V> {
        private final ValueIterator iterator;

        public ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        public int size() {
            return Int2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return Int2ObjectCache.this.containsValue(object);
        }

        public ValueIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Int2ObjectCache.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException("Cannot remove from ValueCollection");
        }

        @Override
        public boolean removeIf(Predicate<? super V> predicate) {
            throw new UnsupportedOperationException("Cannot remove from ValueCollection");
        }
    }

    public final class KeyIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return Int2ObjectCache.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Int2ObjectCache.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int remaining;
        private int position = -1;

        AbstractIterator() {
        }

        protected final int position() {
            return this.position;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            boolean bl2 = false;
            Object[] objectArray = Int2ObjectCache.this.values;
            int n2 = Int2ObjectCache.this.capacity;
            for (int i2 = this.position + 1; i2 < n2; ++i2) {
                if (null == objectArray[i2]) continue;
                bl2 = true;
                this.position = i2;
                --this.remaining;
                break;
            }
            if (!bl2) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported on Iterator");
        }

        void reset() {
            this.remaining = Int2ObjectCache.this.size;
            this.position = -1;
        }
    }
}

