/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.agrona.BufferUtil;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;

public final class IoUtil {
    public static final int BLOCK_SIZE = 4096;
    private static final byte[] FILLER = new byte[4096];
    private static final int MAP_READ_ONLY = 0;
    private static final int MAP_READ_WRITE = 1;
    private static final int MAP_PRIVATE = 2;

    private IoUtil() {
    }

    public static void fill(FileChannel fileChannel, long l2, long l3, byte by2) {
        try {
            byte[] byArray;
            if (0 != by2) {
                byArray = new byte[4096];
                Arrays.fill(byArray, by2);
            } else {
                byArray = FILLER;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            fileChannel.position(l2);
            int n2 = (int)(l3 / 4096L);
            int n3 = (int)(l3 % 4096L);
            for (int i2 = 0; i2 < n2; ++i2) {
                byteBuffer.position(0);
                fileChannel.write(byteBuffer);
            }
            if (n3 > 0) {
                byteBuffer.position(0);
                byteBuffer.limit(n3);
                fileChannel.write(byteBuffer);
            }
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
    }

    public static void delete(File file, boolean bl2) {
        if (file.exists()) {
            File[] fileArray;
            if (file.isDirectory() && null != (fileArray = file.listFiles())) {
                for (File file2 : fileArray) {
                    IoUtil.delete(file2, bl2);
                }
            }
            if (!file.delete() && !bl2) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException iOException) {
                    LangUtil.rethrowUnchecked(iOException);
                }
            }
        }
    }

    public static void delete(File file, ErrorHandler errorHandler) {
        try {
            if (file.exists()) {
                File[] fileArray;
                if (file.isDirectory() && null != (fileArray = file.listFiles())) {
                    for (File file2 : fileArray) {
                        IoUtil.delete(file2, errorHandler);
                    }
                }
                if (!file.delete()) {
                    Files.delete(file.toPath());
                }
            }
        }
        catch (Exception exception) {
            errorHandler.onError(exception);
        }
    }

    public static void ensureDirectoryExists(File file, String string) {
        if (!file.exists() && !file.mkdirs()) {
            throw new IllegalArgumentException("could not create " + string + " directory: " + file);
        }
    }

    public static void ensureDirectoryIsRecreated(File file, String string, BiConsumer<String, String> biConsumer) {
        if (file.exists()) {
            IoUtil.delete(file, false);
            biConsumer.accept(file.getAbsolutePath(), string);
        }
        if (!file.mkdirs()) {
            throw new IllegalArgumentException("could not create " + string + " directory: " + file);
        }
    }

    public static void deleteIfExists(File file) {
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
    }

    public static void deleteIfExists(File file, ErrorHandler errorHandler) {
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (Exception exception) {
            errorHandler.onError(exception);
        }
    }

    public static FileChannel createEmptyFile(File file, long l2) {
        return IoUtil.createEmptyFile(file, l2, true);
    }

    public static FileChannel createEmptyFile(File file, long l2, boolean bl2) {
        IoUtil.ensureDirectoryExists(file.getParentFile(), file.getParent());
        FileChannel fileChannel = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(l2);
            fileChannel = randomAccessFile.getChannel();
            if (bl2) {
                IoUtil.fill(fileChannel, 0L, l2, (byte)0);
            }
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return fileChannel;
    }

    public static MappedByteBuffer mapExistingFile(File file, String string) {
        return IoUtil.mapExistingFile(file, FileChannel.MapMode.READ_WRITE, string);
    }

    public static MappedByteBuffer mapExistingFile(File file, String string, long l2, long l3) {
        return IoUtil.mapExistingFile(file, FileChannel.MapMode.READ_WRITE, string, l2, l3);
    }

    public static MappedByteBuffer mapExistingFile(File file, FileChannel.MapMode mapMode, String string) {
        IoUtil.checkFileExists(file, string);
        MappedByteBuffer mappedByteBuffer = null;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, IoUtil.getFileMode(mapMode));
             FileChannel fileChannel = randomAccessFile.getChannel();){
            mappedByteBuffer = fileChannel.map(mapMode, 0L, fileChannel.size());
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return mappedByteBuffer;
    }

    public static MappedByteBuffer mapExistingFile(File file, FileChannel.MapMode mapMode, String string, long l2, long l3) {
        IoUtil.checkFileExists(file, string);
        MappedByteBuffer mappedByteBuffer = null;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, IoUtil.getFileMode(mapMode));
             FileChannel fileChannel = randomAccessFile.getChannel();){
            mappedByteBuffer = fileChannel.map(mapMode, l2, l3);
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return mappedByteBuffer;
    }

    public static MappedByteBuffer mapNewFile(File file, long l2) {
        return IoUtil.mapNewFile(file, l2, true);
    }

    public static MappedByteBuffer mapNewFile(File file, long l2, boolean bl2) {
        Buffer buffer = null;
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            buffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l2);
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        if (bl2) {
            int n2 = buffer.capacity();
            for (int i2 = 0; i2 < n2; i2 += 4096) {
                ((ByteBuffer)buffer).put(i2, (byte)0);
            }
        }
        return buffer;
    }

    public static void checkFileExists(File file, String string) {
        if (!file.exists()) {
            String string2 = "missing file for " + string + " : " + file.getAbsolutePath();
            throw new IllegalStateException(string2);
        }
    }

    public static void unmap(MappedByteBuffer mappedByteBuffer) {
        BufferUtil.free(mappedByteBuffer);
    }

    public static void unmap(ByteBuffer byteBuffer) {
        if (byteBuffer instanceof MappedByteBuffer) {
            IoUtil.unmap((MappedByteBuffer)byteBuffer);
        }
    }

    public static String tmpDirName() {
        Object object = System.getProperty("java.io.tmpdir");
        if (!((String)object).endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        return object;
    }

    public static void removeTrailingSlashes(StringBuilder stringBuilder) {
        int n2;
        char c2;
        while (stringBuilder.length() > 1 && ('/' == (c2 = stringBuilder.charAt(n2 = stringBuilder.length() - 1)) || '\\' == c2)) {
            stringBuilder.setLength(n2);
        }
    }

    private static String getFileMode(FileChannel.MapMode mapMode) {
        return mapMode == FileChannel.MapMode.READ_ONLY ? "r" : "rw";
    }
}

