/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Base64Helper;
import org.HdrHistogram.Histogram;

public class AtomicHistogram
extends Histogram {
    static final AtomicLongFieldUpdater<AtomicHistogram> totalCountUpdater = AtomicLongFieldUpdater.newUpdater(AtomicHistogram.class, "totalCount");
    volatile long totalCount;
    volatile AtomicLongArray counts;

    @Override
    long getCountAtIndex(int n2) {
        return this.counts.get(n2);
    }

    @Override
    long getCountAtNormalizedIndex(int n2) {
        return this.counts.get(n2);
    }

    @Override
    void incrementCountAtIndex(int n2) {
        this.counts.getAndIncrement(n2);
    }

    @Override
    void addToCountAtIndex(int n2, long l2) {
        this.counts.getAndAdd(n2, l2);
    }

    @Override
    void setCountAtIndex(int n2, long l2) {
        this.counts.lazySet(n2, l2);
    }

    @Override
    void setCountAtNormalizedIndex(int n2, long l2) {
        this.counts.lazySet(n2, l2);
    }

    @Override
    int getNormalizingIndexOffset() {
        return 0;
    }

    @Override
    void setNormalizingIndexOffset(int n2) {
        if (n2 != 0) {
            throw new IllegalStateException("AtomicHistogram does not support non-zero normalizing index settings. Use ConcurrentHistogram Instead.");
        }
    }

    @Override
    void shiftNormalizingIndexByOffset(int n2, boolean bl2, double d2) {
        throw new IllegalStateException("AtomicHistogram does not support Shifting operations. Use ConcurrentHistogram Instead.");
    }

    @Override
    void resize(long l2) {
        throw new IllegalStateException("AtomicHistogram does not support resizing operations. Use ConcurrentHistogram Instead.");
    }

    @Override
    public void setAutoResize(boolean bl2) {
        throw new IllegalStateException("AtomicHistogram does not support AutoResize operation. Use ConcurrentHistogram Instead.");
    }

    @Override
    public boolean supportsAutoResize() {
        return false;
    }

    @Override
    void clearCounts() {
        for (int i2 = 0; i2 < this.counts.length(); ++i2) {
            this.counts.lazySet(i2, 0L);
        }
        totalCountUpdater.set(this, 0L);
    }

    @Override
    public AtomicHistogram copy() {
        AtomicHistogram atomicHistogram = new AtomicHistogram(this);
        atomicHistogram.add(this);
        return atomicHistogram;
    }

    @Override
    public AtomicHistogram copyCorrectedForCoordinatedOmission(long l2) {
        AtomicHistogram atomicHistogram = new AtomicHistogram(this);
        atomicHistogram.addWhileCorrectingForCoordinatedOmission(this, l2);
        return atomicHistogram;
    }

    @Override
    public long getTotalCount() {
        return totalCountUpdater.get(this);
    }

    @Override
    void setTotalCount(long l2) {
        totalCountUpdater.set(this, l2);
    }

    @Override
    void incrementTotalCount() {
        totalCountUpdater.incrementAndGet(this);
    }

    @Override
    void addToTotalCount(long l2) {
        totalCountUpdater.addAndGet(this, l2);
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 8 * this.counts.length();
    }

    public AtomicHistogram(long l2, int n2) {
        this(1L, l2, n2);
    }

    public AtomicHistogram(long l2, long l3, int n2) {
        super(l2, l3, n2, false);
        this.counts = new AtomicLongArray(this.countsArrayLength);
        this.wordSizeInBytes = 8;
    }

    public AtomicHistogram(AbstractHistogram abstractHistogram) {
        super(abstractHistogram, false);
        this.counts = new AtomicLongArray(this.countsArrayLength);
        this.wordSizeInBytes = 8;
    }

    public static AtomicHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        return AtomicHistogram.decodeFromByteBuffer(byteBuffer, AtomicHistogram.class, l2);
    }

    public static AtomicHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        return AtomicHistogram.decodeFromCompressedByteBuffer(byteBuffer, AtomicHistogram.class, l2);
    }

    public static AtomicHistogram fromString(String string) throws DataFormatException {
        return AtomicHistogram.decodeFromCompressedByteBuffer(ByteBuffer.wrap(Base64Helper.parseBase64Binary(string)), 0L);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

