/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.nio.charset.Charset;
import javax.annotation.Nullable;
import okhttp3.internal.Util;

public final class Challenge {
    private final String scheme;
    private final String realm;
    private final Charset charset;

    public Challenge(String string, String string2) {
        this(string, string2, Util.ISO_8859_1);
    }

    private Challenge(String string, String string2, Charset charset) {
        if (string == null) {
            throw new NullPointerException("scheme == null");
        }
        if (string2 == null) {
            throw new NullPointerException("realm == null");
        }
        if (charset == null) {
            throw new NullPointerException("charset == null");
        }
        this.scheme = string;
        this.realm = string2;
        this.charset = charset;
    }

    public Challenge withCharset(Charset charset) {
        return new Challenge(this.scheme, this.realm, charset);
    }

    public String scheme() {
        return this.scheme;
    }

    public String realm() {
        return this.realm;
    }

    public Charset charset() {
        return this.charset;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof Challenge && ((Challenge)object).scheme.equals(this.scheme) && ((Challenge)object).realm.equals(this.realm) && ((Challenge)object).charset.equals(this.charset);
    }

    public int hashCode() {
        int n2 = 29;
        n2 = 31 * n2 + this.realm.hashCode();
        n2 = 31 * n2 + this.scheme.hashCode();
        n2 = 31 * n2 + this.charset.hashCode();
        return n2;
    }

    public String toString() {
        return this.scheme + " realm=\"" + this.realm + "\" charset=\"" + this.charset + "\"";
    }
}

