/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class ConcurrencyUtils {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool(new CustomThreadFactory(new CustomExceptionHandler()));
    private static boolean forceThreads = false;
    private static int forceNThreads = 1;

    private ConcurrencyUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static int extendDimension(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        int n3 = ConcurrencyUtils.nextExp2(n2);
        int n4 = n3 + 1;
        return (int)Math.round(Math.pow(2.0, n4));
    }

    public static int getNumberOfProcessors() {
        return forceThreads ? forceNThreads : Runtime.getRuntime().availableProcessors();
    }

    public static int getNumberOfThreads() {
        return ConcurrencyUtils.getNumberOfProcessors();
    }

    public static boolean isForceThreads() {
        return forceThreads;
    }

    public static boolean isPowerOf2(int n2) {
        if (n2 <= 0) {
            return false;
        }
        return (n2 & n2 - 1) == 0;
    }

    public static int nextExp2(int n2) {
        double d2 = Math.log(n2) / Math.log(2.0);
        int n3 = (int)Math.ceil(d2);
        double d3 = (double)n2 / Math.pow(2.0, n3);
        if (d3 == 0.5) {
            --n3;
        }
        return n3;
    }

    public static int nextPow2(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("n must be greater or equal 1");
        }
        if ((n2 & n2 - 1) == 0) {
            return n2;
        }
        int n3 = n2;
        n3 |= n3 >>> 1;
        n3 |= n3 >>> 2;
        n3 |= n3 >>> 4;
        n3 |= n3 >>> 8;
        n3 |= n3 >>> 16;
        return n3 + 1;
    }

    public static int prevPow2(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        return (int)Math.pow(2.0, Math.floor(Math.log(n2) / Math.log(2.0)));
    }

    public static void setForceThreads(boolean bl2) {
        forceThreads = bl2;
    }

    public static void setNumberOfThreads(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("n must be greater or equal 1");
        }
        ConcurrencyUtils.setForceThreads(true);
        forceNThreads = n2;
    }

    public static void sleep(long l2) {
        try {
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        return THREAD_POOL.submit(callable);
    }

    public static Future<?> submit(Runnable runnable) {
        return THREAD_POOL.submit(runnable);
    }

    public static void waitForCompletion(Future<?>[] futureArray) {
        int n2 = futureArray.length;
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                futureArray[i2].get();
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
        }
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private static final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private static int threadCounter = 1;
        private final Thread.UncaughtExceptionHandler handler;

        CustomThreadFactory(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.handler = uncaughtExceptionHandler;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = defaultFactory.newThread(runnable);
            thread.setDaemon(true);
            thread.setName("daemonised_chartfx_math_thread" + threadCounter);
            ++threadCounter;
            thread.setUncaughtExceptionHandler(this.handler);
            return thread;
        }
    }

    private static class CustomExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CustomExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

