/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.wavelet;

public class CDFWavelet {
    public void fwt53(double[] dArray, int n2) {
        int n3;
        double d2 = -0.5;
        for (n3 = 1; n3 < n2 - 2; n3 += 2) {
            int n4 = n3;
            dArray[n4] = dArray[n4] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        int n5 = n2 - 1;
        dArray[n5] = dArray[n5] + 2.0 * d2 * dArray[n2 - 2];
        d2 = 0.25;
        for (n3 = 2; n3 < n2; n3 += 2) {
            int n6 = n3;
            dArray[n6] = dArray[n6] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        dArray[0] = dArray[0] + 2.0 * d2 * dArray[1];
        d2 = Math.sqrt(2.0);
        for (n3 = 0; n3 < n2; ++n3) {
            if (n3 % 2 > 0) {
                int n7 = n3;
                dArray[n7] = dArray[n7] * d2;
                continue;
            }
            int n8 = n3;
            dArray[n8] = dArray[n8] / d2;
        }
        double[] dArray2 = null;
        if (dArray2 == null) {
            dArray2 = new double[n2];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (n3 % 2 == 0) {
                dArray2[n3 / 2] = dArray[n3];
                continue;
            }
            dArray2[n2 / 2 + n3 / 2] = dArray[n3];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dArray[n3] = dArray2[n3];
        }
    }

    public void fwt97(double[] dArray, int n2) {
        int n3;
        double d2 = -1.586134342;
        for (n3 = 1; n3 < n2 - 2; n3 += 2) {
            int n4 = n3;
            dArray[n4] = dArray[n4] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        int n5 = n2 - 1;
        dArray[n5] = dArray[n5] + 2.0 * d2 * dArray[n2 - 2];
        d2 = -0.05298011854;
        for (n3 = 2; n3 < n2; n3 += 2) {
            int n6 = n3;
            dArray[n6] = dArray[n6] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        dArray[0] = dArray[0] + 2.0 * d2 * dArray[1];
        d2 = 0.8829110762;
        for (n3 = 1; n3 < n2 - 2; n3 += 2) {
            int n7 = n3;
            dArray[n7] = dArray[n7] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        int n8 = n2 - 1;
        dArray[n8] = dArray[n8] + 2.0 * d2 * dArray[n2 - 2];
        d2 = 0.4435068522;
        for (n3 = 2; n3 < n2; n3 += 2) {
            int n9 = n3;
            dArray[n9] = dArray[n9] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        dArray[0] = dArray[0] + 2.0 * d2 * dArray[1];
        d2 = 0.869864452275695;
        for (n3 = 0; n3 < n2; ++n3) {
            if (n3 % 2 > 0) {
                int n10 = n3;
                dArray[n10] = dArray[n10] * d2;
                continue;
            }
            int n11 = n3;
            dArray[n11] = dArray[n11] / d2;
        }
        double[] dArray2 = null;
        if (dArray2 == null) {
            dArray2 = new double[n2];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (n3 % 2 == 0) {
                dArray2[n3 / 2] = dArray[n3];
                continue;
            }
            dArray2[n2 / 2 + n3 / 2] = dArray[n3];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dArray[n3] = dArray2[n3];
        }
    }

    public void iwt53(double[] dArray, int n2) {
        int n3;
        double[] dArray2 = null;
        if (dArray2 == null) {
            dArray2 = new double[n2];
        }
        for (n3 = 0; n3 < n2 / 2; ++n3) {
            dArray2[n3 * 2] = dArray[n3];
            dArray2[n3 * 2 + 1] = dArray[n3 + n2 / 2];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dArray[n3] = dArray2[n3];
        }
        double d2 = 1.0 / Math.sqrt(2.0);
        for (n3 = 0; n3 < n2; ++n3) {
            if (n3 % 2 > 0) {
                int n4 = n3;
                dArray[n4] = dArray[n4] * d2;
                continue;
            }
            int n5 = n3;
            dArray[n5] = dArray[n5] / d2;
        }
        d2 = -0.25;
        for (n3 = 2; n3 < n2; n3 += 2) {
            int n6 = n3;
            dArray[n6] = dArray[n6] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        dArray[0] = dArray[0] + 2.0 * d2 * dArray[1];
        d2 = 0.5;
        for (n3 = 1; n3 < n2 - 2; n3 += 2) {
            int n7 = n3;
            dArray[n7] = dArray[n7] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        int n8 = n2 - 1;
        dArray[n8] = dArray[n8] + 2.0 * d2 * dArray[n2 - 2];
    }

    public void iwt97(double[] dArray, int n2) {
        int n3;
        double[] dArray2 = null;
        if (dArray2 == null) {
            dArray2 = new double[n2];
        }
        for (n3 = 0; n3 < n2 / 2; ++n3) {
            dArray2[n3 * 2] = dArray[n3];
            dArray2[n3 * 2 + 1] = dArray[n3 + n2 / 2];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dArray[n3] = dArray2[n3];
        }
        double d2 = 1.149604398;
        for (n3 = 0; n3 < n2; ++n3) {
            if (n3 % 2 > 0) {
                int n4 = n3;
                dArray[n4] = dArray[n4] * d2;
                continue;
            }
            int n5 = n3;
            dArray[n5] = dArray[n5] / d2;
        }
        d2 = -0.4435068522;
        for (n3 = 2; n3 < n2; n3 += 2) {
            int n6 = n3;
            dArray[n6] = dArray[n6] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        dArray[0] = dArray[0] + 2.0 * d2 * dArray[1];
        d2 = -0.8829110762;
        for (n3 = 1; n3 < n2 - 2; n3 += 2) {
            int n7 = n3;
            dArray[n7] = dArray[n7] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        int n8 = n2 - 1;
        dArray[n8] = dArray[n8] + 2.0 * d2 * dArray[n2 - 2];
        d2 = 0.05298011854;
        for (n3 = 2; n3 < n2; n3 += 2) {
            int n9 = n3;
            dArray[n9] = dArray[n9] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        dArray[0] = dArray[0] + 2.0 * d2 * dArray[1];
        d2 = 1.586134342;
        for (n3 = 1; n3 < n2 - 2; n3 += 2) {
            int n10 = n3;
            dArray[n10] = dArray[n10] + d2 * (dArray[n3 - 1] + dArray[n3 + 1]);
        }
        int n11 = n2 - 1;
        dArray[n11] = dArray[n11] + 2.0 * d2 * dArray[n2 - 2];
    }

    public static void main(String[] stringArray) {
        int n2;
        CDFWavelet cDFWavelet = new CDFWavelet();
        double[] dArray = new double[32];
        for (n2 = 0; n2 < 32; ++n2) {
            dArray[n2] = (double)(5 + n2) + 0.4 * (double)n2 * (double)n2 - 0.02 * (double)n2 * (double)n2 * (double)n2;
        }
        System.out.print("Original signal:\n");
        for (n2 = 0; n2 < 32; ++n2) {
            System.out.printf("x[%d]=%f\n", n2, dArray[n2]);
        }
        System.out.print("\n");
        cDFWavelet.fwt97(dArray, 32);
        System.out.print("Wavelets coefficients:\n");
        for (n2 = 0; n2 < 32; ++n2) {
            System.out.printf("wc[%d]=%f\n", n2, dArray[n2]);
        }
        System.out.print("\n");
        cDFWavelet.iwt97(dArray, 32);
        System.out.print("Reconstructed signal:\n");
        for (n2 = 0; n2 < 32; ++n2) {
            System.out.printf("xx[%d]=%f\n", n2, dArray[n2]);
        }
    }
}

