/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.functions;

import io.fair_acc.math.functions.Function;
import io.fair_acc.math.utils.UpdateListener;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFunction
implements Function {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFunction.class);
    private static final List<Function> fallFunctions = new ArrayList<Function>();
    private String funcName = "none";
    private int fnbOfParameter = -1;
    protected double[] fparameter;
    protected double[] fparameterMin;
    protected double[] fparameterMax;
    protected double[] fparameterCopy;
    protected boolean[] fparameterFixed;
    protected String[] fparameterName;
    protected boolean fitterMode;
    private final List<UpdateListener> flistener = new ArrayList<UpdateListener>();
    private final long fcreationTime = System.currentTimeMillis();

    public AbstractFunction(String string, double ... dArray) {
        this(string, dArray, new String[dArray.length]);
    }

    public AbstractFunction(String string, double[] dArray, String ... stringArray) {
        if (string == null) {
            throw new InvalidParameterException("AbstractFunction(String, double[], double[]) - function name is null");
        }
        if (dArray == null) {
            throw new InvalidParameterException("AbstractFunction(" + string + ", double[], String[]) - parameter array is null");
        }
        if (stringArray.length != dArray.length) {
            throw new InvalidParameterException("AbstractFunction(" + string + ", double[], String[]) - parameter vs. name array dimension mismatch ( " + dArray.length + " vs. " + (this.fparameterName == null ? 0 : this.fparameterName.length) + ")");
        }
        this.fnbOfParameter = dArray.length;
        this.funcName = string;
        this.reinitialise();
        this.fparameter = Arrays.copyOf(dArray, dArray.length);
        this.fparameterName = Arrays.copyOf(stringArray, stringArray.length);
        this.addFunction(this);
    }

    public AbstractFunction(String string, int n2) {
        this(string, new double[n2], new String[n2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunction(Function function) {
        List<Function> list = fallFunctions;
        synchronized (list) {
            if (!fallFunctions.contains(function)) {
                fallFunctions.add(function);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UpdateListener updateListener) {
        List<UpdateListener> list = this.flistener;
        synchronized (list) {
            if (!this.flistener.contains(updateListener)) {
                this.flistener.add(updateListener);
            }
        }
    }

    @Override
    public void clearParameterValues() {
        for (int i2 = 0; i2 < this.fparameter.length; ++i2) {
            if (this.isParameterFixed(i2)) continue;
            this.fparameter[i2] = 0.0;
        }
    }

    @Override
    public void fixParameter(int n2, boolean bl2) {
        if (n2 >= 0 || n2 <= this.fnbOfParameter) {
            this.fparameterFixed[n2] = bl2;
            return;
        }
        throw new InvalidParameterException(this.exceptionForIdString("fixParameter", n2, new String[0]));
    }

    @Override
    public int getFreeParameterCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fnbOfParameter; ++i2) {
            if (this.isParameterFixed(i2)) continue;
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function[] getFunctions() {
        List<Function> list = fallFunctions;
        synchronized (list) {
            if (!fallFunctions.isEmpty()) {
                return fallFunctions.toArray(new Function[0]);
            }
        }
        return new Function[0];
    }

    @Override
    public String getID() {
        return this.getName() + this.fcreationTime;
    }

    @Override
    public String getName() {
        return this.funcName;
    }

    @Override
    public int getParameterCount() {
        return this.fnbOfParameter;
    }

    @Override
    public String getParameterName(int n2) {
        if (n2 >= 0 || n2 <= this.fnbOfParameter) {
            return this.fparameterName[n2];
        }
        throw new InvalidParameterException(this.exceptionForIdString("getParameterName", n2, new String[0]));
    }

    @Override
    public double getParameterRangeMaximum(int n2) {
        if (n2 < 0 || n2 >= this.fnbOfParameter) {
            throw new InvalidParameterException(this.exceptionForIdString("getParameterRangeMaximum", n2, new String[0]));
        }
        return this.fparameterMax[n2];
    }

    private String exceptionForIdString(String string, int n2, String ... stringArray) {
        return string + "(" + n2 + (String)(stringArray.length > 0 ? ", " + stringArray[0] : "") + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}";
    }

    @Override
    public double getParameterRangeMinimum(int n2) {
        if (n2 < 0 || n2 >= this.fnbOfParameter) {
            throw new InvalidParameterException(this.exceptionForIdString("getParameterRangeMinimum", n2, new String[0]));
        }
        return this.fparameterMin[n2];
    }

    @Override
    public double getParameterValue(int n2) {
        if (n2 >= 0 || n2 <= this.fnbOfParameter) {
            return this.fparameter[n2];
        }
        throw new InvalidParameterException(this.exceptionForIdString("getParameterValue", n2, new String[0]));
    }

    public double[] getParameterValues() {
        return this.fparameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeListener() {
        List<UpdateListener> list = this.flistener;
        synchronized (list) {
            for (UpdateListener updateListener : this.flistener) {
                updateListener.Update(this);
            }
        }
    }

    @Override
    public boolean isFitterMode() {
        return this.fitterMode;
    }

    @Override
    public boolean isParameterFixed(int n2) {
        if (n2 >= 0 || n2 <= this.fnbOfParameter) {
            return this.fparameterFixed[n2];
        }
        throw new InvalidParameterException(this.exceptionForIdString("isParameterFixed", n2, new String[0]));
    }

    public void printParameters() {
        this.printParameters(false);
    }

    public void printParameters(boolean bl2) {
        LOGGER.atInfo().log(String.format("AbstractFunction - function name: %s", this.getName()));
        for (int i2 = 0; i2 < this.getParameterCount(); ++i2) {
            if (bl2) {
                LOGGER.atInfo().log(String.format("Parameter %2d: %-20s = %f \t [%f, %f]", i2, this.getParameterName(i2), this.getParameterValue(i2), this.getParameterRangeMinimum(i2), this.getParameterRangeMaximum(i2)));
                continue;
            }
            LOGGER.atInfo().log(String.format("Parameter %2d: %-20s = %f", i2, this.getParameterName(i2), this.getParameterValue(i2)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunction(Function function) {
        List<Function> list = fallFunctions;
        synchronized (list) {
            if (fallFunctions.contains(function)) {
                fallFunctions.remove(function);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UpdateListener updateListener) {
        List<UpdateListener> list = this.flistener;
        synchronized (list) {
            if (this.flistener.contains(updateListener)) {
                this.flistener.remove(updateListener);
            }
        }
    }

    @Override
    public void setFitterMode(boolean bl2) {
        if (this.fitterMode == bl2) {
            throw new InvalidParameterException("setFitterMode(" + bl2 + ") - funciton is already in this mode");
        }
        this.fitterMode = bl2;
        if (this.fitterMode) {
            this.fparameterCopy = Arrays.copyOf(this.fparameter, this.fparameter.length);
        } else {
            this.fparameter = Arrays.copyOf(this.fparameterCopy, this.fparameterCopy.length);
        }
    }

    @Override
    public void setParameterCount(int n2) {
        if (this.fnbOfParameter == n2 || n2 < 0) {
            return;
        }
        this.fnbOfParameter = n2;
        this.reinitialise();
    }

    @Override
    public void setParameterName(int n2, String string) {
        if (n2 >= 0 || n2 <= this.fnbOfParameter) {
            this.fparameterName[n2] = string;
            return;
        }
        throw new InvalidParameterException(this.exceptionForIdString("setParameterName", n2, string));
    }

    @Override
    public void setParameterRange(int n2, double d2, double d3) {
        if (n2 < 0 || n2 >= this.fnbOfParameter) {
            throw new InvalidParameterException("setParameterRangeMaximum(" + n2 + "," + d2 + "," + d3 + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
        }
        this.fparameterMin[n2] = d2;
        this.fparameterMax[n2] = d3;
    }

    @Override
    public void setParameterValue(int n2, double d2) {
        if (n2 >= 0 || n2 <= this.fnbOfParameter) {
            this.fparameter[n2] = d2;
            return;
        }
        throw new InvalidParameterException(this.exceptionForIdString("setParameterValue", n2, Double.toString(d2)));
    }

    @Override
    public void setParameterValues(double[] dArray) {
        if (dArray.length <= this.fnbOfParameter) {
            System.arraycopy(dArray, 0, this.fparameter, 0, dArray.length);
            return;
        }
        throw new InvalidParameterException("setParameterValue(" + dArray.length + "," + Arrays.toString(dArray) + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
    }

    private void reinitialise() {
        if (this.fparameter != null && this.fnbOfParameter == this.fparameter.length) {
            return;
        }
        if (this.fparameter == null) {
            this.fparameter = new double[this.fnbOfParameter];
            this.fparameterMin = new double[this.fnbOfParameter];
            this.fparameterMax = new double[this.fnbOfParameter];
            this.fparameterCopy = new double[this.fnbOfParameter];
            this.fparameterName = new String[this.fnbOfParameter];
            this.fparameterFixed = new boolean[this.fnbOfParameter];
            for (int i2 = 0; i2 < this.fnbOfParameter; ++i2) {
                this.fparameterName[i2] = "arg" + i2;
            }
            return;
        }
        this.fparameter = Arrays.copyOf(this.fparameter, this.fnbOfParameter);
        this.fparameterMin = Arrays.copyOf(this.fparameterMin, this.fnbOfParameter);
        this.fparameterMax = Arrays.copyOf(this.fparameterMax, this.fnbOfParameter);
        this.fparameterCopy = Arrays.copyOf(this.fparameterCopy, this.fnbOfParameter);
        this.fparameterFixed = Arrays.copyOf(this.fparameterFixed, this.fnbOfParameter);
        String[] stringArray = this.fparameterName;
        this.fparameterName = new String[this.fnbOfParameter];
        for (int i3 = 0; i3 < this.fnbOfParameter; ++i3) {
            this.fparameterName[i3] = i3 < stringArray.length ? stringArray[i3] : "arg" + i3;
        }
    }
}

