/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.HashMapHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class IntStringMap
implements Map<Integer, String> {
    private static final String NOT_IMPLEMENTED = "not implemented";
    private static final String FREE_KEY = "";
    private static final String REMOVED_KEY = "";
    private static final String NULL_VALUE = null;
    private Object[] data;
    private boolean hasNull;
    private final float fillFactor;
    private int threshold;
    private int sizeInternal;
    private int mask;
    private int mask2;

    public IntStringMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("FillFactor must be in (0, 1)");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        int n3 = HashMapHelper.arraySize(n2, f2);
        this.mask = n3 - 1;
        this.mask2 = n3 * 2 - 1;
        this.fillFactor = f2;
        this.data = new Object[n3 * 2];
        Arrays.fill(this.data, "");
        this.threshold = (int)((float)n3 * f2);
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, "");
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    @Override
    public Set<Map.Entry<Integer, String>> entrySet() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    public String get(int n2) {
        int n3 = (n2 & this.mask) << 1;
        Object object = this.data[n3];
        if (object.equals("")) {
            return null;
        }
        do {
            if (!(object = this.data[n3 = n3 + 2 & this.mask2]).equals("")) continue;
            return null;
        } while (!object.equals(n2));
        return (String)this.data[n3 + 1];
    }

    @Override
    public String get(Object object) {
        if (object == null) {
            return NULL_VALUE;
        }
        return this.get(object);
    }

    public int getStartIndex(Object object) {
        return (Integer)object & this.mask;
    }

    @Override
    public boolean isEmpty() {
        return this.sizeInternal == 0;
    }

    @Override
    public Set<Integer> keySet() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    @Override
    public String put(Integer n2, String string) {
        int n3 = this.getStartIndex(n2) << 1;
        Object object = this.data[n3];
        if (object.equals("")) {
            this.data[n3] = n2;
            this.data[n3 + 1] = string;
            if (this.sizeInternal >= this.threshold) {
                this.rehash(this.data.length * 2);
            } else {
                ++this.sizeInternal;
            }
            return null;
        }
        if (object.equals(n2)) {
            Object object2 = this.data[n3 + 1];
            this.data[n3 + 1] = string;
            return (String)object2;
        }
        int n4 = -1;
        if (object.equals("")) {
            n4 = n3;
        }
        while (true) {
            if ((object = this.data[n3 = n3 + 2 & this.mask2]).equals("")) {
                if (n4 != -1) {
                    n3 = n4;
                }
                this.data[n3] = n2;
                this.data[n3 + 1] = string;
                if (this.sizeInternal >= this.threshold) {
                    this.rehash(this.data.length * 2);
                } else {
                    ++this.sizeInternal;
                }
                return null;
            }
            if (object.equals(n2)) {
                Object object3 = this.data[n3 + 1];
                this.data[n3 + 1] = string;
                return (String)object3;
            }
            if (!object.equals("") || n4 != -1) continue;
            n4 = n3;
        }
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends String> map) {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }

    private void rehash(int n2) {
        this.threshold = (int)((double)n2 / 2.0 * (double)this.fillFactor);
        this.mask = n2 / 2 - 1;
        this.mask2 = n2 - 1;
        int n3 = this.data.length;
        Object[] objectArray = this.data;
        this.data = new Object[n2];
        Arrays.fill(this.data, "");
        this.sizeInternal = this.hasNull ? 1 : 0;
        for (int i2 = 0; i2 < n3; i2 += 2) {
            Object object = objectArray[i2];
            if (object.equals("") || object.equals("")) continue;
            this.put((Integer)object, (String)objectArray[i2 + 1]);
        }
    }

    @Override
    public String remove(Object object) {
        int n2 = this.getStartIndex(object) << 1;
        Object object2 = this.data[n2];
        if (object2.equals("")) {
            return null;
        }
        if (object2.equals(object)) {
            --this.sizeInternal;
            this.data[n2] = this.data[n2 + 2 & this.mask2] == "" ? "" : "";
            String string = (String)this.data[n2 + 1];
            this.data[n2 + 1] = null;
            return string;
        }
        do {
            if (!(object2 = this.data[n2 = n2 + 2 & this.mask2]).equals("")) continue;
            return null;
        } while (!object2.equals(object));
        --this.sizeInternal;
        this.data[n2] = this.data[n2 + 2 & this.mask2] == "" ? "" : "";
        String string = (String)this.data[n2 + 1];
        this.data[n2 + 1] = null;
        return string;
    }

    @Override
    public int size() {
        return this.sizeInternal;
    }

    @Override
    public Collection<String> values() {
        throw new IllegalStateException(NOT_IMPLEMENTED);
    }
}

