/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

public final class HashMapHelper {
    private static final int INT_PHI = -1640531527;

    private HashMapHelper() {
    }

    public static int arraySize(int n2, float f2) {
        long l2 = Math.max(2L, HashMapHelper.nextPowerOfTwo((long)Math.ceil((float)n2 / f2)));
        if (l2 > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + n2 + " expected elements with load factor " + f2 + ")");
        }
        return (int)l2;
    }

    public static long nextPowerOfTwo(long l2) {
        long l3 = l2;
        if (l3 == 0L) {
            return 1L;
        }
        --l3;
        l3 |= l3 >> 1;
        l3 |= l3 >> 2;
        l3 |= l3 >> 4;
        l3 |= l3 >> 8;
        l3 |= l3 >> 16;
        return (l3 | l3 >> 32) + 1L;
    }

    public static int phiMix(int n2) {
        int n3 = n2 * -1640531527;
        return n3 ^ n3 >> 16;
    }
}

