/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.remote;

import io.fair_acc.dataset.remote.Data;
import io.fair_acc.dataset.remote.MimeType;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DataContainer
implements Serializable {
    private static final long serialVersionUID = -4443375672892579564L;
    private String selector;
    private final String exportName;
    private final String category;
    private final long updatePeriod;
    private final List<Data> data;
    private String rbacToken;
    private final long timeStampCreation;
    private long timeStampLastAccess;

    public DataContainer(String string, long l2, byte[] byArray, int n2) {
        this(DataContainer.genExportName(string), DataContainer.getCategory(string), l2, new Data(DataContainer.genExportNameData(string), MimeType.getEnumByFileName(string).toString(), byArray, n2));
    }

    public DataContainer(String string, String string2, long l2, Data ... dataArray) {
        this.exportName = DataContainer.checkField("exportName", string);
        this.category = DataContainer.fixPreAndPost(DataContainer.checkField("category", string2));
        this.updatePeriod = l2;
        this.data = List.of(dataArray);
        this.timeStampLastAccess = this.timeStampCreation = System.currentTimeMillis();
    }

    public String getCategory() {
        this.updateAccess();
        return this.category;
    }

    public List<Data> getData() {
        this.updateAccess();
        return this.data;
    }

    public byte[] getDataByteArray() {
        return this.getData().get(0).getDataByteArray();
    }

    public int getDataByteArraySize() {
        return this.getData().get(0).getDataByteArraySize();
    }

    public String getExportName() {
        return this.exportName;
    }

    public String getExportNameData() {
        return this.getData().get(0).getExportNameData();
    }

    public String getMimeType() {
        return this.getData().get(0).getMimeType();
    }

    public String getRbacToken() {
        return this.rbacToken;
    }

    public String getSelector() {
        return this.selector;
    }

    public long getTimeStampCreation() {
        return this.timeStampCreation;
    }

    public String getTimeStampCreationString() {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.UK);
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat.format(new Date(this.timeStampCreation));
    }

    public long getTimeStampLastAccess() {
        return this.timeStampLastAccess;
    }

    public long getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setRbacToken(String string) {
        this.updateAccess();
        this.rbacToken = string;
    }

    public void setSelector(String string) {
        this.updateAccess();
        this.selector = string;
    }

    public void updateAccess() {
        this.timeStampLastAccess = System.currentTimeMillis();
    }

    protected static String fixPreAndPost(String string) {
        String string2 = string == null ? "/" : string.trim();
        Object object = string2.startsWith("/") ? string2 : "/" + string2;
        return ((String)object).endsWith("/") ? object : (String)object + "/";
    }

    protected static String genExportName(String string) {
        int n2;
        DataContainer.checkField("genExportName(name)", string);
        int n3 = string.lastIndexOf(47);
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = string.lastIndexOf(46)) < 0) {
            n2 = string.length();
        }
        return string.substring(n3, n2).replace("/", "");
    }

    protected static String genExportNameData(String string) {
        DataContainer.checkField("genExportNameData(name)", string);
        int n2 = string.lastIndexOf(47);
        if (n2 < 0) {
            n2 = 0;
        }
        return string.substring(n2).replace("/", "");
    }

    protected static String getCategory(String string) {
        DataContainer.checkField("getCategory(name)", string);
        int n2 = string.lastIndexOf(47);
        if (n2 < 0) {
            return DataContainer.fixPreAndPost("");
        }
        return DataContainer.fixPreAndPost(string.substring(0, n2 + 1));
    }

    private static String checkField(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException(string + "category not be null");
        }
        if (string2.isBlank()) {
            throw new IllegalArgumentException(string + "must not be blank");
        }
        return string2;
    }
}

