/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.hexagon;

import io.fair_acc.chartfx.renderer.spi.hexagon.GridPosition;
import io.fair_acc.chartfx.renderer.spi.hexagon.Hexagon;
import io.fair_acc.chartfx.renderer.spi.hexagon.HexagonCallback;
import io.fair_acc.chartfx.renderer.spi.hexagon.HexagonMap;
import java.util.Collection;
import javafx.scene.Group;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class GridDrawer {
    private final HexagonMap map;
    private Font font = new Font(13.0);

    public GridDrawer(HexagonMap hexagonMap) {
        this.map = hexagonMap;
    }

    public void draw(Canvas canvas) {
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.clearRect(0.0, 0.0, graphicsContext.getCanvas().getWidth(), graphicsContext.getCanvas().getHeight());
        for (Hexagon hexagon : this.map.getAllHexagons()) {
            hexagon.draw(graphicsContext);
            if (!this.map.renderCoordinates) continue;
            hexagon.renderCoordinates(graphicsContext);
        }
    }

    public void draw(Group group) {
        Collection<Hexagon> collection = this.map.getAllHexagons();
        for (Hexagon hexagon : collection) {
            hexagon.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                GridPosition gridPosition = ((Hexagon)((Object)((Object)mouseEvent.getSource()))).position;
                for (HexagonCallback hexagonCallback : this.map.onHexClickedCallback) {
                    Hexagon hexagon;
                    if (hexagonCallback == null || (hexagon = this.map.getHexagon(gridPosition)) == null) continue;
                    hexagonCallback.handle(hexagon);
                }
            });
            hexagon.addEventFilter(MouseEvent.MOUSE_ENTERED, mouseEvent -> {
                GridPosition gridPosition = ((Hexagon)((Object)((Object)mouseEvent.getSource()))).position;
                for (HexagonCallback hexagonCallback : this.map.onHexEnteredCallback) {
                    Hexagon hexagon;
                    if (hexagonCallback == null || (hexagon = this.map.getHexagon(gridPosition)) == null) continue;
                    hexagonCallback.handle(hexagon);
                }
            });
            hexagon.addEventFilter(MouseEvent.MOUSE_EXITED, mouseEvent -> {
                GridPosition gridPosition = ((Hexagon)((Object)((Object)mouseEvent.getSource()))).position;
                for (HexagonCallback hexagonCallback : this.map.onHexExitCallback) {
                    Hexagon hexagon;
                    if (hexagonCallback == null || (hexagon = this.map.getHexagon(gridPosition)) == null) continue;
                    hexagonCallback.handle(hexagon);
                }
            });
            group.getChildren().add((Object)hexagon);
            if (!this.map.renderCoordinates) continue;
            Text text = new Text(hexagon.position.getCoordinates());
            text.setFont(this.font);
            double d2 = text.getBoundsInLocal().getWidth();
            double d3 = text.getBoundsInLocal().getHeight();
            text.setX((double)hexagon.getGraphicsXoffset() - d2 / 2.0);
            text.setY((double)hexagon.getGraphicsYoffset() + d3 / 4.0);
            group.getChildren().add((Object)text);
        }
    }

    public void drawContour(Canvas canvas) {
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.clearRect(0.0, 0.0, graphicsContext.getCanvas().getWidth(), graphicsContext.getCanvas().getHeight());
        for (Hexagon hexagon : this.map.getAllHexagons()) {
            hexagon.drawContour(graphicsContext);
            if (!this.map.renderCoordinates) continue;
            hexagon.renderCoordinates(graphicsContext);
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public static GridPosition pixelToPosition(int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 - n5;
        int n8 = n3 - n6;
        double d2 = (double)n4 / 2.0;
        double d3 = (0.3333333333333333 * Math.sqrt(3.0) * (double)n7 - 0.3333333333333333 * (double)n8) / d2;
        double d4 = 0.6666666666666666 * (double)n3 / d2;
        return GridPosition.hexRound(d3, d4);
    }
}

