/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.financial;

import io.fair_acc.chartfx.Chart;
import javafx.css.PseudoClass;

public enum FinancialTheme {
    Default,
    Classic("classic"),
    Clearlook("clearlook"),
    Sand("sand"),
    Blackberry("blackberry"),
    Dark("dark");

    private final PseudoClass pseudoClass;
    private static final FinancialTheme[] values;

    private FinancialTheme() {
        this.pseudoClass = null;
    }

    private FinancialTheme(String string2) {
        this.pseudoClass = PseudoClass.getPseudoClass((String)("financial-" + string2));
    }

    public PseudoClass getPseudoClass() {
        return this.pseudoClass;
    }

    public void applyPseudoClasses(Chart chart) {
        for (FinancialTheme financialTheme : values) {
            chart.pseudoClassStateChanged(financialTheme.getPseudoClass(), this == financialTheme);
        }
    }

    static {
        values = FinancialTheme.values();
    }
}

