/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.renderer.ErrorStyle;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.ErrorDataSetRenderer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.locks.DataSetLock;
import io.fair_acc.dataset.locks.DefaultDataSetLock;
import io.fair_acc.dataset.spi.DefaultAxisDescription;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.canvas.GraphicsContext;

public class MountainRangeRenderer
extends ErrorDataSetRenderer
implements Renderer {
    private static final int MIN_DIM = 3;
    protected DoubleProperty mountainRangeOffset = new SimpleDoubleProperty((Object)this, "mountainRangeOffset", 0.5);
    private final WeakHashMap<Double, Integer> xWeakIndexMap = new WeakHashMap();
    private final WeakHashMap<Double, Integer> yWeakIndexMap = new WeakHashMap();
    private double mountainRangeExtra;
    double zRangeMin;
    double zRangeMax;

    public MountainRangeRenderer() {
        this.setDrawMarker(false);
        this.setDrawBars(false);
        this.setErrorStyle(ErrorStyle.NONE);
        this.xWeakIndexMap.clear();
        this.yWeakIndexMap.clear();
    }

    public MountainRangeRenderer(double d2) {
        this();
        this.setMountainRangeOffset(d2);
    }

    public final double getMountainRangeOffset() {
        return this.mountainRangeOffset.get();
    }

    public final DoubleProperty mountainRangeOffsetProperty() {
        return this.mountainRangeOffset;
    }

    @Override
    protected void updateCachedVariables() {
        super.updateCachedVariables();
        this.zRangeMin = this.getDatasets().stream().mapToDouble(dataSet -> dataSet.getAxisDescription(2).getMin()).min().orElse(-1.0);
        this.zRangeMax = this.getDatasets().stream().mapToDouble(dataSet -> dataSet.getAxisDescription(2).getMax()).max().orElse(1.0);
    }

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        if (!(dataSet instanceof GridDataSet)) {
            return;
        }
        this.xWeakIndexMap.clear();
        this.yWeakIndexMap.clear();
        this.mountainRangeExtra = this.getMountainRangeOffset();
        double d2 = this.zRangeMax * (1.0 + this.mountainRangeExtra);
        boolean bl2 = this.yAxis.isAutoRanging();
        if (bl2 && (this.zRangeMin != this.yAxis.getMin() || d2 != this.yAxis.getMax())) {
            this.yAxis.setAutoRanging(false);
            this.yAxis.setMin(this.zRangeMin);
            this.yAxis.setMax(d2);
            this.yAxis.setTickUnit(Math.abs(d2 - this.zRangeMin) / 10.0);
            this.yAxis.forceRedraw();
        }
        this.yAxis.setAutoRanging(bl2);
        int n2 = ((GridDataSet)dataSet).getShape(1);
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            super.render(graphicsContext, new Demux3dTo2dDataSet((GridDataSet)dataSet, i2, this.zRangeMin, d2), dataSetNode);
        }
    }

    public MountainRangeRenderer setMountainRangeOffset(double d2) {
        AssertUtils.gtEqThanZero("mountainRangeOffset", d2);
        this.mountainRangeOffset.setValue((Number)d2);
        return this;
    }

    private class Demux3dTo2dDataSet
    implements DataSet {
        private static final long serialVersionUID = 3914728138839091421L;
        private final transient DataSetLock<DataSet> localLock = new DefaultDataSetLock<Demux3dTo2dDataSet>(this);
        private final GridDataSet dataSet;
        private final int yIndex;
        private final double zMin;
        private final double zMax;
        private final double yShift;
        private final transient List<AxisDescription> axesDescriptions = new ArrayList<DefaultAxisDescription>(Arrays.asList(new DefaultAxisDescription(0, "x-Axis", "a.u."), new DefaultAxisDescription(1, "y-Axis", "a.u.")));

        public Demux3dTo2dDataSet(GridDataSet gridDataSet, int n2, double d2, double d3) {
            this.dataSet = gridDataSet;
            this.yIndex = n2;
            this.zMin = d2;
            this.zMax = d3;
            this.yShift = this.dataSet.getShape(1) > 0 ? MountainRangeRenderer.this.mountainRangeExtra * this.dataSet.getAxisDescription(2).getMax() * (double)this.yIndex / (double)this.dataSet.getShape(1) : 0.0;
        }

        @Override
        public double get(int n2, int n3) {
            switch (n2) {
                case 0: {
                    return this.dataSet.getGrid(n2, n3);
                }
                case 1: {
                    return this.dataSet.get(2, n3, this.yIndex) + this.yShift;
                }
            }
            throw new IllegalArgumentException("dinIndex " + n2 + " not defined");
        }

        @Override
        public List<AxisDescription> getAxisDescriptions() {
            return this.axesDescriptions;
        }

        @Override
        public int getDataCount() {
            return this.dataSet.getShape(0);
        }

        @Override
        public String getDataLabel(int n2) {
            return this.dataSet.getDataLabel(n2);
        }

        @Override
        public boolean hasDataLabels() {
            return this.dataSet.hasDataLabels();
        }

        @Override
        public int getDimension() {
            return 2;
        }

        @Override
        public int getIndex(int n2, double ... dArray) {
            AssertUtils.checkArrayDimension("value", dArray, 1);
            switch (n2) {
                case 0: {
                    return MountainRangeRenderer.this.xWeakIndexMap.computeIfAbsent(dArray[0], d2 -> this.dataSet.getGridIndex(0, (double)d2));
                }
                case 1: {
                    return MountainRangeRenderer.this.yWeakIndexMap.computeIfAbsent(dArray[0], d2 -> this.dataSet.getGridIndex(1, (double)d2));
                }
            }
            throw new IndexOutOfBoundsException("dimIndex=" + n2 + " out of range");
        }

        @Override
        public String getName() {
            return this.dataSet.getName() + ":slice#" + this.yIndex;
        }

        @Override
        public List<String> getStyleClasses() {
            return this.dataSet.getStyleClasses();
        }

        @Override
        public DataSet addStyleClasses(String ... stringArray) {
            this.dataSet.addStyleClasses(stringArray);
            return this;
        }

        @Override
        public String getStyle() {
            return this.dataSet.getStyle();
        }

        @Override
        public String getStyle(int n2) {
            return null;
        }

        @Override
        public boolean hasStyles() {
            return this.dataSet.hasStyles();
        }

        @Override
        public double[] getValues(int n2) {
            switch (n2) {
                case 0: {
                    return this.dataSet.getGridValues(n2);
                }
                case 1: {
                    double[] dArray = new double[this.dataSet.getShape(0)];
                    for (int i2 = 0; i2 < dArray.length; ++i2) {
                        dArray[i2] = this.dataSet.getValue(2, i2, this.yIndex) + this.yShift;
                    }
                    return dArray;
                }
            }
            throw new IllegalArgumentException("dinIndex " + n2 + " not defined");
        }

        public DataSetLock<DataSet> lock() {
            return this.localLock;
        }

        @Override
        public DataSet recomputeLimits(int n2) {
            this.getAxisDescription(0).set(this.dataSet.getAxisDescription(0));
            this.getAxisDescription(1).set(this.zMin, this.zMax);
            return this;
        }

        @Override
        public DataSet setStyle(String string) {
            return this.dataSet.setStyle(string);
        }

        @Override
        public double getValue(int n2, double ... dArray) {
            return 0.0;
        }

        @Override
        public DataSet set(DataSet dataSet, boolean bl2) {
            throw new UnsupportedOperationException("copy setter not implemented for Demux3dTo2dDataSet");
        }

        @Override
        public BitState getBitState() {
            return this.dataSet.getBitState();
        }
    }
}

