/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.plugins.AbstractDataFormattingPlugin;
import io.fair_acc.dataset.spi.utils.Tuple;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;

public class CrosshairIndicator
extends AbstractDataFormattingPlugin {
    public static final String STYLE_CLASS_PATH = "chart-crosshair-path";
    public static final String STYLE_CLASS_LABEL = "chart-crosshair-label";
    private static final int LABEL_X_OFFSET = 15;
    private static final int LABEL_Y_OFFSET = 5;
    protected final Path crosshairPath = new Path();
    protected final Text coordinatesLabel = new Text();

    public CrosshairIndicator() {
        this.crosshairPath.getStyleClass().add((Object)STYLE_CLASS_PATH);
        this.crosshairPath.setManaged(false);
        this.crosshairPath.setId("crosshairIndicator-Path");
        this.coordinatesLabel.getStyleClass().add((Object)STYLE_CLASS_LABEL);
        this.coordinatesLabel.setManaged(false);
        this.coordinatesLabel.setId("crosshairIndicator-Label");
        EventHandler eventHandler = mouseEvent -> {
            if (!this.isMouseEventWithinCanvas((MouseEvent)mouseEvent)) {
                this.getChartChildren().remove((Object)this.crosshairPath);
                this.getChartChildren().remove((Object)this.coordinatesLabel);
                return;
            }
            Bounds bounds = this.getChart().getPlotArea().getBoundsInLocal();
            this.updatePath((MouseEvent)mouseEvent, bounds);
            this.updateLabel((MouseEvent)mouseEvent, bounds);
            if (!this.getChartChildren().contains((Object)this.crosshairPath)) {
                this.getChartChildren().addAll((Object[])new Node[]{this.crosshairPath, this.coordinatesLabel});
            }
        };
        this.registerInputEventHandler(MouseEvent.ANY, eventHandler);
    }

    private String formatLabelText(Point2D point2D) {
        Axis axis = this.getChart().getFirstAxis(Orientation.VERTICAL);
        if (axis == null) {
            return this.getChart() + " - no y-axis present to translate point " + point2D;
        }
        Tuple<Number, Number> tuple = this.toDataPoint(axis, point2D);
        if (tuple == null) {
            return "unknown coordinate";
        }
        return this.formatData(this.getChart(), tuple);
    }

    private void updateLabel(MouseEvent mouseEvent, Bounds bounds) {
        this.coordinatesLabel.setText(this.formatLabelText(this.getLocationInPlotArea(mouseEvent)));
        double d2 = this.coordinatesLabel.prefWidth(-1.0);
        double d3 = this.coordinatesLabel.prefHeight(d2);
        double d4 = mouseEvent.getX() + 15.0;
        double d5 = mouseEvent.getY() + 5.0;
        if (d4 + d2 > bounds.getMaxX()) {
            d4 = mouseEvent.getX() - 15.0 - d2;
        }
        if (d5 + d3 > bounds.getMaxY()) {
            d5 = mouseEvent.getY() - 5.0 - d3;
        }
        this.coordinatesLabel.resizeRelocate(d4, d5, d2, d3);
    }

    private void updatePath(MouseEvent mouseEvent, Bounds bounds) {
        ObservableList observableList = this.crosshairPath.getElements();
        observableList.clear();
        observableList.add((Object)new MoveTo(bounds.getMinX() + 1.0, mouseEvent.getY()));
        observableList.add((Object)new LineTo(bounds.getMaxX(), mouseEvent.getY()));
        observableList.add((Object)new MoveTo(mouseEvent.getX(), bounds.getMinY() + 1.0));
        observableList.add((Object)new LineTo(mouseEvent.getX(), bounds.getMaxY()));
    }
}

