/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.marker;

import io.fair_acc.chartfx.marker.Marker;
import javafx.scene.canvas.GraphicsContext;

public enum DefaultMarker implements Marker
{
    RECTANGLE,
    RECTANGLE1,
    RECTANGLE2,
    CIRCLE,
    CIRCLE1,
    CIRCLE2,
    PLUS,
    CROSS,
    DIAMOND,
    DIAMOND1,
    DIAMOND2;

    public static final DefaultMarker DEFAULT;

    @Override
    public void draw(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        switch (this) {
            case DIAMOND: 
            case DIAMOND1: {
                DefaultMarker.drawDiamond(graphicsContext, d2, d3, d4);
                break;
            }
            case DIAMOND2: {
                DefaultMarker.drawEmptyDiamond(graphicsContext, d2, d3, d4);
                break;
            }
            case CIRCLE: 
            case CIRCLE1: {
                DefaultMarker.drawCircle(graphicsContext, d2, d3, d4);
                break;
            }
            case CIRCLE2: {
                DefaultMarker.drawEmptyCircle(graphicsContext, d2, d3, d4);
                break;
            }
            case CROSS: {
                DefaultMarker.drawCross(graphicsContext, d2, d3, d4);
                break;
            }
            case PLUS: {
                DefaultMarker.drawPlus(graphicsContext, d2, d3, d4);
                break;
            }
            case RECTANGLE2: {
                DefaultMarker.drawEmptyRectangle(graphicsContext, d2, d3, d4);
                break;
            }
            default: {
                DefaultMarker.drawRectangle(graphicsContext, d2, d3, d4);
            }
        }
    }

    public static void drawCircle(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        graphicsContext.fillOval(d2 - d4, d3 - d4, 2.0 * d4, 2.0 * d4);
    }

    public static void drawCross(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        graphicsContext.strokeLine(d2 - d4, d3 - d4, d2 + d4, d3 + d4);
        graphicsContext.strokeLine(d2 - d4, d3 + d4, d2 + d4, d3 - d4);
    }

    public static void drawDiamond(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        double[] dArray = new double[]{d2 + d4, d2, d2 - d4, d2, d2 + d4};
        double[] dArray2 = new double[]{d3, d3 + d4, d3, d3 - d4, d3};
        graphicsContext.fillPolygon(dArray, dArray2, dArray.length);
    }

    public static void drawEmptyCircle(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        graphicsContext.strokeOval(d2 - d4, d3 - d4, 2.0 * d4, 2.0 * d4);
    }

    public static void drawEmptyDiamond(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        double[] dArray = new double[]{d2 + d4, d2, d2 - d4, d2, d2 + d4};
        double[] dArray2 = new double[]{d3, d3 + d4, d3, d3 - d4, d3};
        graphicsContext.strokePolygon(dArray, dArray2, dArray.length);
    }

    public static void drawEmptyRectangle(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        graphicsContext.strokeRect(d2 - d4, d3 - d4, 2.0 * d4, 2.0 * d4);
    }

    public static void drawPlus(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        graphicsContext.strokeLine(d2, d3 - d4, d2, d3 + d4);
        graphicsContext.strokeLine(d2 - d4, d3, d2 + d4, d3);
    }

    public static void drawRectangle(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        graphicsContext.fillRect(d2 - d4, d3 - d4, 2.0 * d4, 2.0 * d4);
    }

    public static Marker get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("marker type name must not be 'null'");
        }
        String string2 = string.toUpperCase();
        for (DefaultMarker defaultMarker : DefaultMarker.values()) {
            if (!defaultMarker.name().equals(string2)) continue;
            return defaultMarker;
        }
        throw new IllegalArgumentException("unknown marker type name '" + string + "'");
    }

    static {
        DEFAULT = RECTANGLE;
    }
}

