/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

import io.fair_acc.chartfx.axes.AxisLabelOverlapPolicy;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;

public final class CategoryAxis
extends DefaultNumericAxis {
    private boolean forceAxisCategories = false;
    private boolean changeIsLocal = false;
    private final ObjectProperty<ObservableList<String>> categories = new ObjectPropertyBase<ObservableList<String>>(){

        public Object getBean() {
            return CategoryAxis.this;
        }

        public String getName() {
            return "categories";
        }
    };

    public CategoryAxis() {
        this((String)null);
        this.setTickUnit(1.0);
        this.changeIsLocal = true;
        this.setCategories((ObservableList<String>)FXCollections.observableArrayList());
        this.changeIsLocal = false;
    }

    public CategoryAxis(ObservableList<String> observableList) {
        this(null, observableList);
    }

    public CategoryAxis(String string) {
        super(string);
        this.setOverlapPolicy(AxisLabelOverlapPolicy.SHIFT_ALT);
        PropUtil.runOnChange(() -> {
            double d2 = Math.abs(this.getMax() - this.getMin());
            if (!Double.isFinite(d2)) {
                return;
            }
            double d3 = 0.5 / (double)((int)d2);
            this.autoRangePaddingProperty().set(d3);
        }, new ObservableValue[]{this.minProperty(), this.maxProperty()});
    }

    public CategoryAxis(String string, ObservableList<String> observableList) {
        super(string, 0.0, observableList.size(), 1.0);
        this.changeIsLocal = true;
        this.setCategories(observableList);
        this.changeIsLocal = false;
    }

    public ObservableList<String> getCategories() {
        return (ObservableList)this.categories.get();
    }

    public void setCategories(List<String> list) {
        if (list == null) {
            this.forceAxisCategories = false;
            this.setCategories((ObservableList<String>)FXCollections.observableArrayList());
            return;
        }
        this.forceAxisCategories = true;
        this.setCategories((ObservableList<String>)FXCollections.observableArrayList(list));
    }

    public void setCategories(ObservableList<String> observableList) {
        if (observableList == null) {
            this.forceAxisCategories = false;
            this.setCategories((ObservableList<String>)FXCollections.observableArrayList());
            return;
        }
        this.setMaxMajorTickLabelCount(observableList.size() + 1);
        this.setTickLabelFormatter(new StringConverter<Number>(){

            public Number fromString(String string) {
                for (int i2 = 0; i2 < CategoryAxis.this.getCategories().size(); ++i2) {
                    if (!((String)CategoryAxis.this.getCategories().get(i2)).equalsIgnoreCase(string)) continue;
                    return i2;
                }
                throw new IllegalArgumentException("Category not found.");
            }

            public String toString(Number number) {
                int n2 = Math.round(number.floatValue());
                if (n2 < 0 || n2 >= CategoryAxis.this.getCategories().size()) {
                    return "unknown category";
                }
                return (String)CategoryAxis.this.getCategories().get(n2);
            }
        });
        this.categories.set(observableList);
    }

    public boolean updateCategories(DataSet dataSet) {
        if (dataSet == null || !dataSet.hasDataLabels() || this.forceAxisCategories) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = true;
        for (int i2 = 0; i2 < dataSet.getDataCount(); ++i2) {
            String string;
            String string2 = dataSet.getDataLabel(i2);
            if (string2 == null) {
                string = "unknown category";
            } else {
                string = string2;
                bl2 = false;
            }
            arrayList.add(string);
        }
        if (!bl2) {
            this.setCategories(arrayList);
            this.forceAxisCategories = false;
        }
        return false;
    }

    @Override
    protected AxisRange autoRange(double d2, double d3, double d4, double d5) {
        double d6;
        double d7 = d6 = d2 > 0.0 && this.isForceZeroInRange() ? 0.0 : d2;
        if (this.isLogAxis && d2 <= 0.0) {
            d6 = 1.0E-6;
            this.isUpdating = true;
            this.setMin(1.0E-6);
            this.isUpdating = false;
        }
        double d8 = d3 < 0.0 && this.isForceZeroInRange() ? 0.0 : d3;
        double d9 = DefaultNumericAxis.getEffectiveRange(d6, d8) * this.getAutoRangePadding();
        double d10 = 1.0 + this.getAutoRangePadding();
        double d11 = this.isLogAxis ? d2 / d10 : d6 - d9;
        double d12 = this.isLogAxis ? d3 * d10 : d8 + d9;
        return this.computeRange(d11, d12, d4, d5);
    }

    @Override
    protected void calculateMinorTickValues(DoubleArrayList doubleArrayList) {
    }

    @Override
    protected double computeTickUnit(double d2) {
        return 1.0;
    }
}

