/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.BufferUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class DataHeaderFlyweight
extends HeaderFlyweight {
    public static final int HEADER_LENGTH = 32;
    public static final short BEGIN_FLAG = 128;
    public static final short END_FLAG = 64;
    public static final short BEGIN_AND_END_FLAGS = 192;
    public static final short EOS_FLAG = 32;
    public static final short BEGIN_END_AND_EOS_FLAGS = 224;
    public static final long DEFAULT_RESERVE_VALUE = 0L;
    public static final int TERM_OFFSET_FIELD_OFFSET = 8;
    public static final int SESSION_ID_FIELD_OFFSET = 12;
    public static final int STREAM_ID_FIELD_OFFSET = 16;
    public static final int TERM_ID_FIELD_OFFSET = 20;
    public static final int RESERVED_VALUE_OFFSET = 24;
    public static final int DATA_OFFSET = 32;

    public DataHeaderFlyweight() {
    }

    public DataHeaderFlyweight(UnsafeBuffer unsafeBuffer) {
        super(unsafeBuffer);
    }

    public DataHeaderFlyweight(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public static int fragmentLength(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getInt(n2 + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static boolean isHeartbeat(UnsafeBuffer unsafeBuffer, int n2) {
        return n2 == 32 && unsafeBuffer.getInt(0) == 0;
    }

    public static boolean isEndOfStream(UnsafeBuffer unsafeBuffer) {
        return 224 == (unsafeBuffer.getByte(5) & 0xFF);
    }

    public int sessionId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionId(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getInt(n2 + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public DataHeaderFlyweight sessionId(int n2) {
        this.putInt(12, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int streamId(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getInt(n2 + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public DataHeaderFlyweight streamId(int n2) {
        this.putInt(16, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int termId() {
        return this.getInt(20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int termId(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getInt(n2 + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public DataHeaderFlyweight termId(int n2) {
        this.putInt(20, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int termOffset() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int termOffset(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getInt(n2 + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public DataHeaderFlyweight termOffset(int n2) {
        this.putInt(8, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long reservedValue() {
        return this.getLong(24, ByteOrder.LITTLE_ENDIAN);
    }

    public static long reservedValue(UnsafeBuffer unsafeBuffer, int n2) {
        return unsafeBuffer.getLong(n2 + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public DataHeaderFlyweight reservedValue(long l2) {
        this.putLong(24, l2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int dataOffset() {
        return 32;
    }

    public static UnsafeBuffer createDefaultHeader(int n2, int n3, int n4) {
        UnsafeBuffer unsafeBuffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned(32, 64));
        unsafeBuffer.putByte(4, (byte)0);
        unsafeBuffer.putByte(5, (byte)-64);
        unsafeBuffer.putShort(6, (short)1, ByteOrder.LITTLE_ENDIAN);
        unsafeBuffer.putInt(12, n2, ByteOrder.LITTLE_ENDIAN);
        unsafeBuffer.putInt(16, n3, ByteOrder.LITTLE_ENDIAN);
        unsafeBuffer.putInt(20, n4, ByteOrder.LITTLE_ENDIAN);
        unsafeBuffer.putLong(24, 0L);
        return unsafeBuffer;
    }

    @Override
    public String toString() {
        return "DATA Header{frame-length=" + this.frameLength() + " version=" + this.version() + " flags=" + String.valueOf(DataHeaderFlyweight.flagsToChars(this.flags())) + " type=" + this.headerType() + " term-offset=" + this.termOffset() + " session-id=" + this.sessionId() + " stream-id=" + this.streamId() + " term-id=" + this.termId() + " reserved-value=" + this.reservedValue() + "}";
    }
}

