/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.NetworkUtil;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.FrameDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public abstract class UdpChannelTransport
implements AutoCloseable {
    protected final MediaDriver.Context context;
    protected final ErrorHandler errorHandler;
    protected final UdpChannel udpChannel;
    protected DatagramChannel sendDatagramChannel;
    protected DatagramChannel receiveDatagramChannel;
    protected InetSocketAddress connectAddress;
    protected SelectionKey selectionKey;
    private UdpTransportPoller transportPoller;
    private final InetSocketAddress bindAddress;
    private final InetSocketAddress endPointAddress;
    private final AtomicCounter invalidPackets;
    protected boolean isClosed = false;
    private int multicastTtl = 0;
    private final int socketSndbufLength;
    private final int socketRcvbufLength;

    protected UdpChannelTransport(UdpChannel udpChannel, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, InetSocketAddress inetSocketAddress3, MediaDriver.Context context, int n2, int n3) {
        this.context = context;
        this.udpChannel = udpChannel;
        this.errorHandler = context.errorHandler();
        this.endPointAddress = inetSocketAddress;
        this.bindAddress = inetSocketAddress2;
        this.connectAddress = inetSocketAddress3;
        this.invalidPackets = context.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS);
        this.socketRcvbufLength = n2;
        this.socketSndbufLength = n3;
    }

    protected UdpChannelTransport(UdpChannel udpChannel, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, InetSocketAddress inetSocketAddress3, MediaDriver.Context context) {
        this(udpChannel, inetSocketAddress, inetSocketAddress2, inetSocketAddress3, context, udpChannel.socketRcvbufLengthOrDefault(context.socketRcvbufLength()), udpChannel.socketSndbufLengthOrDefault(context.socketSndbufLength()));
    }

    public static void sendError(int n2, IOException iOException, InetSocketAddress inetSocketAddress) {
        throw new AeronException("failed to send " + n2 + " byte packet to " + inetSocketAddress, iOException, AeronException.Category.WARN);
    }

    public void openDatagramChannel(AtomicCounter atomicCounter) {
        try {
            this.receiveDatagramChannel = this.sendDatagramChannel = DatagramChannel.open(this.udpChannel.protocolFamily());
            if (this.udpChannel.isMulticast()) {
                if (null != this.connectAddress) {
                    this.receiveDatagramChannel = DatagramChannel.open(this.udpChannel.protocolFamily());
                }
                this.receiveDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                this.receiveDatagramChannel.bind(new InetSocketAddress(this.endPointAddress.getPort()));
                this.receiveDatagramChannel.join(this.endPointAddress.getAddress(), this.udpChannel.localInterface());
                this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, this.udpChannel.localInterface());
                if (this.udpChannel.hasMulticastTtl()) {
                    this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.udpChannel.multicastTtl());
                    this.multicastTtl = this.sendDatagramChannel.getOption(StandardSocketOptions.IP_MULTICAST_TTL);
                } else if (this.context.socketMulticastTtl() != 0) {
                    this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.context.socketMulticastTtl());
                    this.multicastTtl = this.sendDatagramChannel.getOption(StandardSocketOptions.IP_MULTICAST_TTL);
                }
            } else {
                this.sendDatagramChannel.bind(this.bindAddress);
            }
            if (null != this.connectAddress) {
                this.sendDatagramChannel.connect(this.connectAddress);
            }
            if (0 != this.socketSndbufLength()) {
                this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.socketSndbufLength());
            }
            if (0 != this.socketRcvbufLength()) {
                this.receiveDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.socketRcvbufLength());
            }
            this.sendDatagramChannel.configureBlocking(false);
            this.receiveDatagramChannel.configureBlocking(false);
        }
        catch (IOException iOException) {
            if (null != atomicCounter) {
                atomicCounter.setOrdered(-1L);
            }
            CloseHelper.quietClose(this.sendDatagramChannel);
            if (this.receiveDatagramChannel != this.sendDatagramChannel) {
                CloseHelper.quietClose(this.receiveDatagramChannel);
            }
            this.sendDatagramChannel = null;
            this.receiveDatagramChannel = null;
            String string = "channel error - " + iOException.getMessage() + " (at " + iOException.getStackTrace()[0].toString() + "): " + this.udpChannel.originalUriString();
            throw new AeronException(string, iOException);
        }
    }

    public void registerForRead(UdpTransportPoller udpTransportPoller) {
        this.transportPoller = udpTransportPoller;
        this.selectionKey = udpTransportPoller.registerForRead(this);
    }

    public UdpChannel udpChannel() {
        return this.udpChannel;
    }

    public DatagramChannel receiveDatagramChannel() {
        return this.receiveDatagramChannel;
    }

    public int multicastTtl() {
        return this.multicastTtl;
    }

    public String bindAddressAndPort() {
        try {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.receiveDatagramChannel.getLocalAddress();
            if (null != inetSocketAddress) {
                return NetworkUtil.formatAddressAndPort(inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (null != this.selectionKey) {
                this.selectionKey.cancel();
            }
            if (null != this.transportPoller) {
                this.transportPoller.cancelRead(this);
                this.transportPoller.selectNowWithoutProcessing();
            }
            CloseHelper.close(this.errorHandler, this.sendDatagramChannel);
            CloseHelper.close(this.errorHandler, this.receiveDatagramChannel);
            if (null != this.transportPoller) {
                this.transportPoller.selectNowWithoutProcessing();
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isMulticast() {
        return this.udpChannel.isMulticast();
    }

    public boolean isValidFrame(UnsafeBuffer unsafeBuffer, int n2) {
        boolean bl2 = true;
        if (FrameDescriptor.frameVersion(unsafeBuffer, 0) != 0) {
            bl2 = false;
            this.invalidPackets.increment();
        } else if (n2 < 8) {
            bl2 = false;
            this.invalidPackets.increment();
        }
        return bl2;
    }

    public void sendHook(ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
    }

    public void receiveHook(UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress) {
    }

    public InetSocketAddress receive(ByteBuffer byteBuffer) {
        byteBuffer.clear();
        InetSocketAddress inetSocketAddress = null;
        try {
            if (this.receiveDatagramChannel.isOpen()) {
                inetSocketAddress = (InetSocketAddress)this.receiveDatagramChannel.receive(byteBuffer);
            }
        }
        catch (PortUnreachableException portUnreachableException) {
        }
        catch (Exception exception) {
            LangUtil.rethrowUnchecked(exception);
        }
        return inetSocketAddress;
    }

    public void updateEndpoint(InetSocketAddress inetSocketAddress, AtomicCounter atomicCounter) {
        try {
            if (null != this.sendDatagramChannel) {
                this.sendDatagramChannel.disconnect();
                this.sendDatagramChannel.connect(inetSocketAddress);
                this.connectAddress = inetSocketAddress;
                if (null != atomicCounter) {
                    atomicCounter.setOrdered(1L);
                }
            }
        }
        catch (Exception exception) {
            if (null != atomicCounter) {
                atomicCounter.setOrdered(-1L);
            }
            String string = "re-resolve endpoint channel error - " + exception.getMessage() + " (at " + exception.getStackTrace()[0].toString() + "): " + this.udpChannel.originalUriString();
            throw new AeronException(string, exception);
        }
    }

    public int socketSndbufLength() {
        return this.socketSndbufLength;
    }

    public int socketRcvbufLength() {
        return this.socketRcvbufLength;
    }
}

