/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.DirectBufferVector;
import io.aeron.LogBuffers;
import io.aeron.ReservedValueSupplier;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.HeaderWriter;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.status.LocalSocketAddressStatus;
import java.util.List;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public abstract class Publication
implements AutoCloseable {
    public static final long NOT_CONNECTED = -1L;
    public static final long BACK_PRESSURED = -2L;
    public static final long ADMIN_ACTION = -3L;
    public static final long CLOSED = -4L;
    public static final long MAX_POSITION_EXCEEDED = -5L;
    final long originalRegistrationId;
    final long registrationId;
    final long maxPossiblePosition;
    final int channelStatusId;
    final int streamId;
    final int sessionId;
    final int maxMessageLength;
    final int maxFramedLength;
    final int initialTermId;
    final int maxPayloadLength;
    final int positionBitsToShift;
    final int termBufferLength;
    volatile boolean isClosed = false;
    final ReadablePosition positionLimit;
    final UnsafeBuffer[] termBuffers;
    final UnsafeBuffer logMetaDataBuffer;
    final HeaderWriter headerWriter;
    final LogBuffers logBuffers;
    final ClientConductor conductor;
    final String channel;

    Publication(ClientConductor clientConductor, String string, int n2, int n3, ReadablePosition readablePosition, int n4, LogBuffers logBuffers, long l2, long l3) {
        UnsafeBuffer unsafeBuffer = logBuffers.metaDataBuffer();
        this.termBufferLength = logBuffers.termLength();
        this.maxMessageLength = FrameDescriptor.computeMaxMessageLength(this.termBufferLength);
        this.maxPayloadLength = LogBufferDescriptor.mtuLength(unsafeBuffer) - 32;
        this.maxFramedLength = Publication.computeFramedLength(this.maxMessageLength, this.maxPayloadLength);
        this.maxPossiblePosition = (long)this.termBufferLength * 0x80000000L;
        this.conductor = clientConductor;
        this.channel = string;
        this.streamId = n2;
        this.sessionId = n3;
        this.initialTermId = LogBufferDescriptor.initialTermId(unsafeBuffer);
        this.termBuffers = logBuffers.duplicateTermBuffers();
        this.logMetaDataBuffer = unsafeBuffer;
        this.logBuffers = logBuffers;
        this.originalRegistrationId = l2;
        this.registrationId = l3;
        this.positionLimit = readablePosition;
        this.channelStatusId = n4;
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift(this.termBufferLength);
        this.headerWriter = HeaderWriter.newInstance(LogBufferDescriptor.defaultFrameHeader(unsafeBuffer));
        for (int i2 = 0; i2 < 3; ++i2) {
            int n5 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + i2 * 8;
            unsafeBuffer.boundsCheck(n5, 8);
        }
    }

    public int positionBitsToShift() {
        return this.positionBitsToShift;
    }

    public int termBufferLength() {
        return this.termBufferLength;
    }

    public long maxPossiblePosition() {
        return this.maxPossiblePosition;
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public int maxMessageLength() {
        return this.maxMessageLength;
    }

    public int maxPayloadLength() {
        return this.maxPayloadLength;
    }

    public long originalRegistrationId() {
        return this.originalRegistrationId;
    }

    public boolean isOriginal() {
        return this.originalRegistrationId == this.registrationId;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public boolean isConnected() {
        return !this.isClosed && LogBufferDescriptor.isConnected(this.logMetaDataBuffer);
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.conductor.removePublication(this);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long channelStatus() {
        if (this.isClosed) {
            return -1L;
        }
        return this.conductor.channelStatus(this.channelStatusId);
    }

    public int channelStatusId() {
        return this.channelStatusId;
    }

    public List<String> localSocketAddresses() {
        return LocalSocketAddressStatus.findAddresses(this.conductor.countersReader(), this.channelStatus(), this.channelStatusId);
    }

    public long position() {
        if (this.isClosed) {
            return -4L;
        }
        long l2 = LogBufferDescriptor.rawTailVolatile(this.logMetaDataBuffer);
        int n2 = LogBufferDescriptor.termOffset(l2, this.termBufferLength);
        return LogBufferDescriptor.computePosition(LogBufferDescriptor.termId(l2), n2, this.positionBitsToShift, this.initialTermId);
    }

    public long positionLimit() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile();
    }

    public int positionLimitId() {
        return this.positionLimit.id();
    }

    public abstract long availableWindow();

    public final long offer(DirectBuffer directBuffer) {
        return this.offer(directBuffer, 0, directBuffer.capacity());
    }

    public final long offer(DirectBuffer directBuffer, int n2, int n3) {
        return this.offer(directBuffer, n2, n3, null);
    }

    public abstract long offer(DirectBuffer var1, int var2, int var3, ReservedValueSupplier var4);

    public final long offer(DirectBuffer directBuffer, int n2, int n3, DirectBuffer directBuffer2, int n4, int n5) {
        return this.offer(directBuffer, n2, n3, directBuffer2, n4, n5, null);
    }

    public abstract long offer(DirectBuffer var1, int var2, int var3, DirectBuffer var4, int var5, int var6, ReservedValueSupplier var7);

    public final long offer(DirectBufferVector[] directBufferVectorArray) {
        return this.offer(directBufferVectorArray, null);
    }

    public abstract long offer(DirectBufferVector[] var1, ReservedValueSupplier var2);

    public abstract long tryClaim(int var1, BufferClaim var2);

    public void addDestination(String string) {
        if (this.isClosed) {
            throw new AeronException("Publication is closed");
        }
        this.conductor.addDestination(this.originalRegistrationId, string);
    }

    public void removeDestination(String string) {
        if (this.isClosed) {
            throw new AeronException("Publication is closed");
        }
        this.conductor.removeDestination(this.originalRegistrationId, string);
    }

    public long asyncAddDestination(String string) {
        if (this.isClosed) {
            throw new AeronException("Publication is closed");
        }
        return this.conductor.asyncAddDestination(this.registrationId, string);
    }

    public long asyncRemoveDestination(String string) {
        if (this.isClosed) {
            throw new AeronException("Publication is closed");
        }
        return this.conductor.asyncRemoveDestination(this.registrationId, string);
    }

    void internalClose() {
        this.isClosed = true;
    }

    LogBuffers logBuffers() {
        return this.logBuffers;
    }

    final long backPressureStatus(long l2, int n2) {
        if (l2 + (long)BitUtil.align(n2 + 32, 32) >= this.maxPossiblePosition) {
            return -5L;
        }
        if (LogBufferDescriptor.isConnected(this.logMetaDataBuffer)) {
            return -2L;
        }
        return -1L;
    }

    final void checkPositiveLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid length: " + n2);
        }
    }

    final void checkPayloadLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid length: " + n2);
        }
        if (n2 > this.maxPayloadLength) {
            throw new IllegalArgumentException("claim exceeds maxPayloadLength of " + this.maxPayloadLength + ", length=" + n2);
        }
    }

    final void checkMaxMessageLength(int n2) {
        if (n2 > this.maxMessageLength) {
            throw new IllegalArgumentException("message exceeds maxMessageLength of " + this.maxMessageLength + ", length=" + n2);
        }
    }

    static int computeFramedLength(int n2, int n3) {
        int n4 = n2 / n3;
        int n5 = n2 % n3;
        int n6 = n5 > 0 ? BitUtil.align(n5 + 32, 32) : 0;
        return n4 * (n3 + 32) + n6;
    }

    static int validateAndComputeLength(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("lengthOne < 0: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("lengthTwo < 0: " + n3);
        }
        int n4 = n2 + n3;
        if (n4 < 0) {
            throw new IllegalArgumentException("overflow totalLength=" + n4);
        }
        return n4;
    }

    public static String errorString(long l2) {
        if (-5L <= l2 && l2 < 0L) {
            int n2 = (int)l2;
            switch (n2) {
                case -1: {
                    return "NOT_CONNECTED";
                }
                case -2: {
                    return "BACK_PRESSURED";
                }
                case -3: {
                    return "ADMIN_ACTION";
                }
                case -4: {
                    return "CLOSED";
                }
                case -5: {
                    return "MAX_POSITION_EXCEEDED";
                }
            }
            return "UNKNOWN";
        }
        if (0L <= l2) {
            return "NONE";
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "Publication{originalRegistrationId=" + this.originalRegistrationId + ", registrationId=" + this.registrationId + ", isClosed=" + this.isClosed + ", isConnected=" + this.isConnected() + ", initialTermId=" + this.initialTermId + ", termBufferLength=" + this.termBufferLength + ", sessionId=" + this.sessionId + ", streamId=" + this.streamId + ", channel='" + this.channel + '\'' + ", position=" + this.position() + '}';
    }
}

