/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import java.util.Arrays;
import org.agrona.DirectBuffer;

public final class DirectBufferVector {
    private DirectBuffer buffer;
    private int offset;
    private int length;

    public DirectBufferVector() {
    }

    public DirectBufferVector(DirectBuffer directBuffer, int n2, int n3) {
        this.buffer = directBuffer;
        this.offset = n2;
        this.length = n3;
    }

    public DirectBufferVector reset(DirectBuffer directBuffer, int n2, int n3) {
        this.buffer = directBuffer;
        this.offset = n2;
        this.length = n3;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public DirectBufferVector buffer(DirectBuffer directBuffer) {
        this.buffer = directBuffer;
        return this;
    }

    public int offset() {
        return this.offset;
    }

    public DirectBufferVector offset(int n2) {
        this.offset = n2;
        return this;
    }

    public int length() {
        return this.length;
    }

    public DirectBufferVector length(int n2) {
        this.length = n2;
        return this;
    }

    public DirectBufferVector validate() {
        int n2 = this.buffer.capacity();
        if (this.offset < 0 || this.offset >= n2) {
            throw new IllegalArgumentException("offset=" + this.offset + " capacity=" + n2);
        }
        if (this.length < 0 || this.length > n2 - this.offset) {
            throw new IllegalArgumentException("offset=" + this.offset + " capacity=" + n2 + " length=" + this.length);
        }
        return this;
    }

    public String toString() {
        return "DirectBufferVector{buffer=" + this.buffer + ", offset=" + this.offset + ", length=" + this.length + '}';
    }

    public static int validateAndComputeLength(DirectBufferVector[] directBufferVectorArray) {
        int n2 = 0;
        for (DirectBufferVector directBufferVector : directBufferVectorArray) {
            directBufferVector.validate();
            if ((n2 += directBufferVector.length) >= 0) continue;
            throw new IllegalStateException("length overflow: " + Arrays.toString(directBufferVectorArray));
        }
        return n2;
    }
}

