/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2.filter.parser.string;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.tableview2.filter.parser.Operation;
import impl.org.controlsfx.tableview2.filter.parser.aggregate.AggregatorsParser;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.StringConverter;
import org.controlsfx.control.tableview2.filter.parser.Parser;

public class StringParser<T>
implements Parser<T> {
    private StringConverter<T> converter;
    private boolean caseSensitive;
    private String errorString = "";
    private final List<Operation<T, String>> operations = Arrays.asList(new BeginsWith(), new EndsWith(), new Contains(), new EqualsTo(), new NotEqualsTo());

    public StringParser() {
    }

    public StringParser(boolean bl2) {
        this(bl2, null);
    }

    public StringParser(boolean bl2, StringConverter<T> stringConverter) {
        this.caseSensitive = bl2;
        this.converter = stringConverter;
    }

    public StringConverter<T> getConverter() {
        return this.converter;
    }

    public void setConverter(StringConverter<T> stringConverter) {
        this.converter = stringConverter;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl2) {
        this.caseSensitive = bl2;
    }

    @Override
    public Predicate<T> parse(String string) {
        this.errorString = "";
        Predicate predicate = this.aggregate(string);
        if (predicate == null) {
            Optional<Operation> optional = this.operations.stream().filter(operation -> string.startsWith(operation.get())).filter(operation -> string.length() > operation.length()).findFirst();
            if (optional.isPresent()) {
                Operation operation2 = optional.get();
                String string2 = this.trim(string, operation2.length());
                if (string2.isEmpty()) {
                    return null;
                }
                return operation2.operate(string2);
            }
            this.errorString = Localization.localize(Localization.asKey("parser.text.error.start.operator"));
            return null;
        }
        return predicate;
    }

    @Override
    public boolean isValid(String string) {
        this.parse(string);
        return this.errorString.isEmpty();
    }

    @Override
    public String getErrorMessage() {
        return this.errorString;
    }

    private String trim(String string, int n2) {
        String string2 = string.substring(n2, string.length()).trim();
        if (!string2.startsWith("\"")) {
            this.errorString = string2 + " " + Localization.localize(Localization.asKey("parser.text.error.string.start"));
        } else if (!string2.endsWith("\"")) {
            this.errorString = string2.substring(1) + " " + Localization.localize(Localization.asKey("parser.text.error.string.end"));
        } else if (string2.length() > 2) {
            return string2.substring(1, string2.length() - 1);
        }
        return "";
    }

    @Override
    public List<String> operators() {
        return Stream.concat(this.operations.stream().map(Operation::get), AggregatorsParser.getStrings()).collect(Collectors.toList());
    }

    @Override
    public String getSymbol(String string) {
        return this.operations.stream().filter(operation -> operation.get().equals(string)).map(Operation::getSymbol).findFirst().orElse(StringParser.i18nString("symbol.default"));
    }

    private String casedString(String string) {
        return this.caseSensitive ? string : string.toUpperCase();
    }

    private static String i18nString(String string) {
        return Localization.localize(Localization.asKey("parser.text.operator." + string));
    }

    class NotEqualsTo
    implements Operation<T, String> {
        NotEqualsTo() {
        }

        @Override
        public String get() {
            return StringParser.i18nString("text.notequalsto");
        }

        @Override
        public int length() {
            return this.get().length();
        }

        @Override
        public Predicate<T> operate(String string) {
            if (StringParser.this.converter != null) {
                return object -> object != null && !StringParser.this.casedString(StringParser.this.converter.toString(object)).equals(StringParser.this.casedString(string));
            }
            return object -> !StringParser.this.casedString(String.valueOf(object)).equals(StringParser.this.casedString(string));
        }

        @Override
        public String getSymbol() {
            return StringParser.i18nString("symbol.notequalsto." + (StringParser.this.caseSensitive ? "sensitive" : "insensitive"));
        }
    }

    class EqualsTo
    implements Operation<T, String> {
        EqualsTo() {
        }

        @Override
        public String get() {
            return StringParser.i18nString("text.equalsto");
        }

        @Override
        public int length() {
            return this.get().length();
        }

        @Override
        public Predicate<T> operate(String string) {
            if (StringParser.this.converter != null) {
                return object -> object != null && StringParser.this.casedString(StringParser.this.converter.toString(object)).equals(StringParser.this.casedString(string));
            }
            return object -> StringParser.this.casedString(String.valueOf(object)).equals(StringParser.this.casedString(string));
        }

        @Override
        public String getSymbol() {
            return StringParser.i18nString("symbol.equalsto." + (StringParser.this.caseSensitive ? "sensitive" : "insensitive"));
        }
    }

    class Contains
    implements Operation<T, String> {
        Contains() {
        }

        @Override
        public String get() {
            return StringParser.i18nString("text.contains");
        }

        @Override
        public int length() {
            return this.get().length();
        }

        @Override
        public Predicate<T> operate(String string) {
            if (StringParser.this.converter != null) {
                return object -> object != null && StringParser.this.casedString(StringParser.this.converter.toString(object)).contains(StringParser.this.casedString(string));
            }
            return object -> StringParser.this.casedString(String.valueOf(object)).contains(StringParser.this.casedString(string));
        }

        @Override
        public String getSymbol() {
            return StringParser.i18nString("symbol.contains." + (StringParser.this.caseSensitive ? "sensitive" : "insensitive"));
        }
    }

    class EndsWith
    implements Operation<T, String> {
        EndsWith() {
        }

        @Override
        public String get() {
            return StringParser.i18nString("text.endswith");
        }

        @Override
        public int length() {
            return this.get().length();
        }

        @Override
        public Predicate<T> operate(String string) {
            if (StringParser.this.converter != null) {
                return object -> object != null && StringParser.this.casedString(StringParser.this.converter.toString(object)).endsWith(StringParser.this.casedString(string));
            }
            return object -> StringParser.this.casedString(String.valueOf(object)).endsWith(StringParser.this.casedString(string));
        }

        @Override
        public String getSymbol() {
            return StringParser.i18nString("symbol.endswith." + (StringParser.this.caseSensitive ? "sensitive" : "insensitive"));
        }
    }

    class BeginsWith
    implements Operation<T, String> {
        BeginsWith() {
        }

        @Override
        public String get() {
            return StringParser.i18nString("text.beginswith");
        }

        @Override
        public int length() {
            return this.get().length();
        }

        @Override
        public Predicate<T> operate(String string) {
            if (StringParser.this.converter != null) {
                return object -> object != null && StringParser.this.casedString(StringParser.this.converter.toString(object)).startsWith(StringParser.this.casedString(string));
            }
            return object -> StringParser.this.casedString(String.valueOf(object)).startsWith(StringParser.this.casedString(string));
        }

        @Override
        public String getSymbol() {
            return StringParser.i18nString("symbol.beginswith." + (StringParser.this.caseSensitive ? "sensitive" : "insensitive"));
        }
    }
}

