/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.scene.control.TableColumnBase;
import org.controlsfx.control.tableview2.FilteredTableColumn;

public class FilteredColumnPredicate<S, T>
implements Predicate<S> {
    private final List<? extends TableColumnBase> columns;

    public FilteredColumnPredicate(TableColumnBase<S, T> ... tableColumnBaseArray) {
        this(Arrays.asList(tableColumnBaseArray));
    }

    public FilteredColumnPredicate(List<? extends TableColumnBase> list) {
        this.columns = Collections.unmodifiableList(list);
    }

    @Override
    public boolean test(S s2) {
        for (TableColumnBase tableColumnBase : this.columns) {
            Object object;
            boolean bl2;
            FilteredTableColumn filteredTableColumn;
            if (!(tableColumnBase instanceof FilteredTableColumn) || (filteredTableColumn = (FilteredTableColumn)tableColumnBase).getPredicate() == null || !filteredTableColumn.isFilterable() || (bl2 = this.doFilter(filteredTableColumn, object = tableColumnBase.getCellData(s2)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 59 * n2 + (this.columns != null ? this.columns.hashCode() : 0);
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FilteredColumnPredicate filteredColumnPredicate = (FilteredColumnPredicate)object;
        return this.columns == filteredColumnPredicate.columns || this.columns != null && this.columns.equals(filteredColumnPredicate.columns);
    }

    private boolean doFilter(FilteredTableColumn<S, T> filteredTableColumn, T t2) {
        Predicate<T> predicate = filteredTableColumn.getPredicate();
        return predicate == null || predicate.test(t2);
    }

    public String toString() {
        return "FilteredColumnsPredicate [ columns: " + this.columns + "] ";
    }
}

