/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridCellEditor {
    private final SpreadsheetHandle handle;
    private SpreadsheetCell modelCell;
    private CellView viewCell;
    private BooleanExpression focusProperty;
    private boolean editing = false;
    private SpreadsheetCellEditor spreadsheetCellEditor;
    private KeyCode lastKeyPressed;
    private final EventHandler<KeyEvent> enterKeyPressed = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent keyEvent) {
            GridCellEditor.this.lastKeyPressed = keyEvent.getCode();
        }
    };
    private final ChangeListener<Boolean> focusListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl2, Boolean bl3) {
            if (!bl3.booleanValue()) {
                GridCellEditor.this.endEdit(true);
            }
        }
    };
    private final InvalidationListener endEditionListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            GridCellEditor.this.endEdit(true);
        }
    };

    public GridCellEditor(SpreadsheetHandle spreadsheetHandle) {
        this.handle = spreadsheetHandle;
    }

    public void updateDataCell(SpreadsheetCell spreadsheetCell) {
        this.modelCell = spreadsheetCell;
    }

    public void updateSpreadsheetCell(CellView cellView) {
        this.viewCell = cellView;
    }

    public void updateSpreadsheetCellEditor(SpreadsheetCellEditor spreadsheetCellEditor) {
        this.spreadsheetCellEditor = spreadsheetCellEditor;
    }

    public void endEdit(boolean bl2) {
        if (bl2 && this.editing) {
            SpreadsheetView spreadsheetView = this.handle.getView();
            boolean bl3 = this.modelCell.getCellType().match(this.spreadsheetCellEditor.getControlValue(), this.modelCell.getOptionsForEditor());
            if (bl3 && this.viewCell != null) {
                Object t2 = this.modelCell.getCellType().convertValue(this.spreadsheetCellEditor.getControlValue());
                spreadsheetView.getGrid().setCellValue(this.modelCell.getRow(), this.modelCell.getColumn(), t2);
                this.editing = false;
                this.viewCell.commitEdit(this.modelCell);
                this.end();
                this.spreadsheetCellEditor.end();
                if (KeyCode.ENTER.equals((Object)this.lastKeyPressed)) {
                    this.handle.getCellsViewSkin().getBehavior().selectCell(1, 0);
                } else if (KeyCode.TAB.equals((Object)this.lastKeyPressed)) {
                    this.handle.getView().getSelectionModel().clearAndSelectRightCell();
                    this.handle.getCellsViewSkin().scrollHorizontally();
                }
            }
        }
        if (this.editing) {
            this.editing = false;
            if (this.viewCell != null) {
                this.viewCell.cancelEdit();
            }
            this.end();
            if (this.spreadsheetCellEditor != null) {
                this.spreadsheetCellEditor.end();
            }
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    public SpreadsheetCell getModelCell() {
        return this.modelCell;
    }

    void startEdit() {
        this.lastKeyPressed = null;
        this.editing = true;
        this.handle.getGridView().addEventFilter(KeyEvent.KEY_PRESSED, this.enterKeyPressed);
        this.handle.getCellsViewSkin().getVBar().valueProperty().addListener(this.endEditionListener);
        this.handle.getCellsViewSkin().getHBar().valueProperty().addListener(this.endEditionListener);
        Control control = this.spreadsheetCellEditor.getEditor();
        Object object = this.modelCell.getItem();
        Double d2 = Math.min(this.viewCell.getHeight(), this.spreadsheetCellEditor.getMaxHeight());
        if (control != null) {
            this.viewCell.setGraphic((Node)control);
            control.setMaxHeight(d2.doubleValue());
            control.setPrefWidth(this.viewCell.getWidth());
        }
        this.spreadsheetCellEditor.startEdit(object, this.modelCell.getFormat(), this.modelCell.getOptionsForEditor());
        if (control != null) {
            this.focusProperty = this.getFocusProperty(control);
            this.focusProperty.addListener(this.focusListener);
        }
    }

    private void end() {
        if (this.focusProperty != null) {
            this.focusProperty.removeListener(this.focusListener);
            this.focusProperty = null;
        }
        this.handle.getCellsViewSkin().getVBar().valueProperty().removeListener(this.endEditionListener);
        this.handle.getCellsViewSkin().getHBar().valueProperty().removeListener(this.endEditionListener);
        this.handle.getGridView().removeEventFilter(KeyEvent.KEY_PRESSED, this.enterKeyPressed);
        this.modelCell = null;
        this.viewCell = null;
    }

    private BooleanExpression getFocusProperty(Control control) {
        if (control instanceof TextArea) {
            return Bindings.createBooleanBinding(() -> {
                if (this.handle.getView().getScene() == null) {
                    return false;
                }
                for (Node node = this.handle.getView().getScene().getFocusOwner(); node != null; node = node.getParent()) {
                    if (node != control) continue;
                    return true;
                }
                return false;
            }, (Observable[])new Observable[]{this.handle.getView().getScene().focusOwnerProperty()});
        }
        return control.focusedProperty();
    }
}

