/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.i18n.Localization;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.property.editor.AbstractPropertyEditor;
import org.controlsfx.property.editor.PropertyEditor;

public class PropertySheetSkin
extends SkinBase<PropertySheet> {
    private static final int MIN_COLUMN_WIDTH = 100;
    private final BorderPane content;
    private final ScrollPane scroller;
    private final ToolBar toolbar;
    private final SegmentedButton modeButton = ActionUtils.createSegmentedButton(new ActionChangeMode(PropertySheet.Mode.NAME), new ActionChangeMode(PropertySheet.Mode.CATEGORY));
    private final TextField searchField = TextFields.createClearableTextField();

    public PropertySheetSkin(PropertySheet propertySheet) {
        super((Control)propertySheet);
        this.scroller = new ScrollPane();
        this.scroller.setFitToWidth(true);
        this.toolbar = new ToolBar();
        this.toolbar.managedProperty().bind((ObservableValue)this.toolbar.visibleProperty());
        this.toolbar.setFocusTraversable(true);
        this.modeButton.managedProperty().bind((ObservableValue)this.modeButton.visibleProperty());
        ((ToggleButton)this.modeButton.getButtons().get(((PropertySheet.Mode)((Object)((PropertySheet)this.getSkinnable()).modeProperty().get())).ordinal())).setSelected(true);
        this.toolbar.getItems().add((Object)this.modeButton);
        this.searchField.setPromptText(Localization.localize(Localization.asKey("property.sheet.search.field.prompt")));
        this.searchField.setMinWidth(0.0);
        HBox.setHgrow((Node)this.searchField, (Priority)Priority.SOMETIMES);
        this.searchField.managedProperty().bind((ObservableValue)this.searchField.visibleProperty());
        this.toolbar.getItems().add((Object)this.searchField);
        this.content = new BorderPane();
        this.content.setTop((Node)this.toolbar);
        this.content.setCenter((Node)this.scroller);
        this.getChildren().add((Object)this.content);
        this.registerChangeListener((ObservableValue)propertySheet.modeProperty(), observableValue -> this.refreshProperties());
        this.registerChangeListener((ObservableValue)propertySheet.propertyEditorFactory(), observableValue -> this.refreshProperties());
        this.registerChangeListener((ObservableValue)propertySheet.titleFilter(), observableValue -> this.refreshProperties());
        this.registerChangeListener((ObservableValue)this.searchField.textProperty(), observableValue -> ((PropertySheet)this.getSkinnable()).setTitleFilter(this.searchField.getText()));
        this.registerChangeListener((ObservableValue)propertySheet.modeSwitcherVisibleProperty(), observableValue -> this.updateToolbar());
        this.registerChangeListener((ObservableValue)propertySheet.searchBoxVisibleProperty(), observableValue -> this.updateToolbar());
        this.registerChangeListener((ObservableValue)propertySheet.categoryComparatorProperty(), observableValue -> this.refreshProperties());
        propertySheet.getItems().addListener(change -> this.refreshProperties());
        this.refreshProperties();
        this.updateToolbar();
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        this.content.resizeRelocate(d2, d3, d4, d5);
    }

    private void updateToolbar() {
        this.modeButton.setVisible(((PropertySheet)this.getSkinnable()).isModeSwitcherVisible());
        this.searchField.setVisible(((PropertySheet)this.getSkinnable()).isSearchBoxVisible());
        this.toolbar.setVisible(this.modeButton.isVisible() || this.searchField.isVisible());
    }

    private void refreshProperties() {
        this.scroller.setContent(this.buildPropertySheetContainer());
    }

    private Node buildPropertySheetContainer() {
        switch ((PropertySheet.Mode)((Object)((PropertySheet)this.getSkinnable()).modeProperty().get())) {
            case CATEGORY: {
                Object object;
                TreeMap<String, ArrayList<Object>> treeMap = new TreeMap<String, ArrayList<Object>>(((PropertySheet)this.getSkinnable()).getCategoryComparator());
                for (Object object2 : ((PropertySheet)this.getSkinnable()).getItems()) {
                    String string = object2.getCategory();
                    object = (ArrayList<Object>)treeMap.get(string);
                    if (object == null) {
                        object = new ArrayList<Object>();
                        treeMap.put(string, (ArrayList<Object>)object);
                    }
                    object.add(object2);
                }
                Iterator iterator = new Accordion();
                for (String string : treeMap.keySet()) {
                    object = new PropertyPane((List)treeMap.get(string));
                    if (object.getChildrenUnmodifiable().size() <= 0) continue;
                    TitledPane titledPane = new TitledPane(string, object);
                    titledPane.setExpanded(true);
                    iterator.getPanes().add((Object)titledPane);
                }
                if (iterator.getPanes().size() > 0) {
                    iterator.setExpandedPane((TitledPane)iterator.getPanes().get(0));
                }
                return iterator;
            }
        }
        return new PropertyPane((List<PropertySheet.Item>)((PropertySheet)this.getSkinnable()).getItems());
    }

    private class PropertyPane
    extends GridPane {
        public PropertyPane(List<PropertySheet.Item> list) {
            this(list, 0);
        }

        public PropertyPane(List<PropertySheet.Item> list, int n2) {
            this.setVgap(5.0);
            this.setHgap(5.0);
            this.setPadding(new Insets(5.0, 15.0, 5.0, (double)(15 + n2 * 10)));
            this.getStyleClass().add((Object)"property-pane");
            this.setItems(list);
        }

        public void setItems(List<PropertySheet.Item> list) {
            this.getChildren().clear();
            String string = ((PropertySheet)PropertySheetSkin.this.getSkinnable()).titleFilter().get();
            string = string == null ? "" : string.trim().toLowerCase();
            int n2 = 0;
            for (PropertySheet.Item item : list) {
                String string2 = item.getName();
                if (!string.isEmpty() && string2.toLowerCase().indexOf(string) < 0) continue;
                Label label = new Label(string2);
                label.setMinWidth(100.0);
                String string3 = item.getDescription();
                if (string3 != null && !string3.trim().isEmpty()) {
                    label.setTooltip(new Tooltip(string3));
                }
                this.add((Node)label, 0, n2);
                Node node = this.getEditor(item);
                if (node instanceof Region) {
                    ((Region)node).setMinWidth(100.0);
                    ((Region)node).setMaxWidth(Double.MAX_VALUE);
                }
                label.setLabelFor(node);
                this.add(node, 1, n2);
                GridPane.setHgrow((Node)node, (Priority)Priority.ALWAYS);
                ++n2;
            }
        }

        private Node getEditor(PropertySheet.Item item) {
            PropertyEditor propertyEditor = (PropertyEditor)((PropertySheet)PropertySheetSkin.this.getSkinnable()).getPropertyEditorFactory().call((Object)item);
            if (propertyEditor == null) {
                propertyEditor = new AbstractPropertyEditor<Object, TextField>(item, new TextField(), true){
                    {
                        ((TextField)this.getEditor()).setEditable(false);
                        ((TextField)this.getEditor()).setDisable(true);
                    }

                    @Override
                    protected ObservableValue<Object> getObservableValue() {
                        return (ObservableValue)((TextField)this.getEditor()).textProperty();
                    }

                    @Override
                    public void setValue(Object object) {
                        ((TextField)this.getEditor()).setText(object == null ? "" : object.toString());
                    }
                };
            } else if (!item.isEditable()) {
                propertyEditor.getEditor().setDisable(true);
            }
            propertyEditor.setValue(item.getValue());
            return propertyEditor.getEditor();
        }
    }

    private class ActionChangeMode
    extends Action {
        private final Image CATEGORY_IMAGE;
        private final Image NAME_IMAGE;

        public ActionChangeMode(PropertySheet.Mode mode) {
            super("");
            this.CATEGORY_IMAGE = new Image(PropertySheetSkin.class.getResource("/org/controlsfx/control/format-indent-more.png").toExternalForm());
            this.NAME_IMAGE = new Image(PropertySheetSkin.class.getResource("/org/controlsfx/control/format-line-spacing-triple.png").toExternalForm());
            this.setEventHandler(actionEvent -> ((PropertySheet)PropertySheetSkin.this.getSkinnable()).modeProperty().set((Object)mode));
            if (mode == PropertySheet.Mode.CATEGORY) {
                this.setGraphic((Node)new ImageView(this.CATEGORY_IMAGE));
                this.setLongText(Localization.localize(Localization.asKey("property.sheet.group.mode.bycategory")));
            } else if (mode == PropertySheet.Mode.NAME) {
                this.setGraphic((Node)new ImageView(this.NAME_IMAGE));
                this.setLongText(Localization.localize(Localization.asKey("property.sheet.group.mode.byname")));
            } else {
                this.setText("???");
            }
        }
    }
}

