/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import javafx.animation.AnimationTimer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import org.controlsfx.control.PlusMinusSlider;

public class PlusMinusSliderSkin
extends SkinBase<PlusMinusSlider> {
    private SliderReader reader;
    private Slider slider;
    private Region plusRegion;
    private Region minusRegion;
    private BorderPane borderPane;

    public PlusMinusSliderSkin(PlusMinusSlider plusMinusSlider) {
        super((Control)plusMinusSlider);
        plusMinusSlider.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        });
        this.slider = new Slider(-1.0, 1.0, 0.0);
        this.slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                ((PlusMinusSlider)PlusMinusSliderSkin.this.getSkinnable()).getProperties().put((Object)"plusminusslidervalue", (Object)number2.doubleValue());
            }
        });
        this.slider.orientationProperty().bind(plusMinusSlider.orientationProperty());
        this.slider.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                PlusMinusSliderSkin.this.reader = new SliderReader();
                PlusMinusSliderSkin.this.reader.start();
            }
        });
        this.slider.addEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (PlusMinusSliderSkin.this.reader != null) {
                    PlusMinusSliderSkin.this.reader.stop();
                }
                KeyValue keyValue = new KeyValue((WritableValue)PlusMinusSliderSkin.this.slider.valueProperty(), (Object)0);
                KeyFrame keyFrame = new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{keyValue});
                Timeline timeline = new Timeline(new KeyFrame[]{keyFrame});
                timeline.play();
            }
        });
        this.plusRegion = new Region();
        this.plusRegion.getStyleClass().add((Object)"adjust-plus");
        this.minusRegion = new Region();
        this.minusRegion.getStyleClass().add((Object)"adjust-minus");
        this.borderPane = new BorderPane();
        this.updateLayout(plusMinusSlider.getOrientation());
        this.getChildren().add((Object)this.borderPane);
        plusMinusSlider.orientationProperty().addListener((observableValue, orientation, orientation2) -> this.updateLayout((Orientation)orientation2));
    }

    private void updateLayout(Orientation orientation) {
        this.borderPane.getChildren().clear();
        switch (orientation) {
            case HORIZONTAL: {
                this.borderPane.setLeft((Node)this.minusRegion);
                this.borderPane.setCenter((Node)this.slider);
                this.borderPane.setRight((Node)this.plusRegion);
                break;
            }
            case VERTICAL: {
                this.borderPane.setTop((Node)this.plusRegion);
                this.borderPane.setCenter((Node)this.slider);
                this.borderPane.setBottom((Node)this.minusRegion);
            }
        }
    }

    class SliderReader
    extends AnimationTimer {
        private long lastTime = System.currentTimeMillis();

        SliderReader() {
        }

        public void handle(long l2) {
            if (l2 - this.lastTime > 10000000L) {
                this.lastTime = l2;
                PlusMinusSliderSkin.this.slider.fireEvent((Event)new PlusMinusSlider.PlusMinusEvent(PlusMinusSliderSkin.this.slider, (EventTarget)PlusMinusSliderSkin.this.slider, PlusMinusSlider.PlusMinusEvent.VALUE_CHANGED, PlusMinusSliderSkin.this.slider.getValue()));
            }
        }
    }
}

