/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.ReflectionHelper;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import java.lang.reflect.Field;
import java.util.Arrays;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.skin.TextAreaSkin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class JFXTextAreaSkin
extends TextAreaSkin {
    private boolean invalid = true;
    private ScrollPane scrollPane = (ScrollPane)this.getChildren().get(0);
    private Text promptText;
    private ValidationPane<JFXTextArea> errorContainer;
    private PromptLinesWrapper<JFXTextArea> linesWrapper;

    public JFXTextAreaSkin(JFXTextArea jFXTextArea) {
        super((TextArea)jFXTextArea);
        jFXTextArea.setWrapText(true);
        this.linesWrapper = new PromptLinesWrapper<JFXTextArea>(jFXTextArea, (ObjectProperty<Paint>)this.promptTextFillProperty(), (ObservableValue<?>)jFXTextArea.textProperty(), (ObservableValue<String>)jFXTextArea.promptTextProperty(), () -> this.promptText);
        this.linesWrapper.init(() -> this.createPromptNode(), new Node[]{this.scrollPane});
        this.errorContainer = new ValidationPane<JFXTextArea>(jFXTextArea);
        this.getChildren().addAll((Object[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
        this.registerChangeListener((ObservableValue)jFXTextArea.disableProperty(), observableValue -> this.linesWrapper.updateDisabled());
        this.registerChangeListener((ObservableValue)jFXTextArea.focusColorProperty(), observableValue -> this.linesWrapper.updateFocusColor());
        this.registerChangeListener((ObservableValue)jFXTextArea.unFocusColorProperty(), observableValue -> this.linesWrapper.updateUnfocusColor());
        this.registerChangeListener((ObservableValue)jFXTextArea.disableAnimationProperty(), observableValue -> this.errorContainer.updateClip());
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        super.layoutChildren(d2, d3, d4, d5);
        double d6 = ((TextArea)this.getSkinnable()).getHeight();
        this.linesWrapper.layoutLines(d2, d3, d4, d5, d6, this.promptText == null ? 0.0 : this.promptText.getLayoutBounds().getHeight() + 3.0);
        this.errorContainer.layoutPane(d2, d6 + this.linesWrapper.focusedLine.getHeight(), d4, d5);
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            Region region = (Region)this.scrollPane.getChildrenUnmodifiable().get(0);
            region.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            region.applyCss();
            this.errorContainer.invalid(d4);
            this.linesWrapper.invalid();
        }
    }

    private void createPromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.setManaged(false);
        this.promptText.getStyleClass().add((Object)"text");
        this.promptText.visibleProperty().bind((ObservableValue)this.linesWrapper.usePromptText);
        this.promptText.fontProperty().bind((ObservableValue)((TextArea)this.getSkinnable()).fontProperty());
        this.promptText.textProperty().bind((ObservableValue)((TextArea)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind(this.linesWrapper.animatedPromptTextFill);
        this.promptText.setLayoutX(1.0);
        this.promptText.setTranslateX(1.0);
        this.promptText.getTransforms().add((Object)this.linesWrapper.promptTextScale);
        this.linesWrapper.promptContainer.getChildren().add((Object)this.promptText);
        if (((TextArea)this.getSkinnable()).isFocused() && ((JFXTextArea)this.getSkinnable()).isLabelFloat()) {
            this.promptText.setTranslateY(-Math.floor(this.scrollPane.getHeight()));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
        try {
            Field field = ReflectionHelper.getField(TextAreaSkin.class, "promptNode");
            Object object = field.get((Object)this);
            if (object != null) {
                this.removeHighlight(Arrays.asList((Node)object));
            }
            field.set((Object)this, this.promptText);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

