/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.transitions.CachedTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.skin.CheckBoxSkin;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Line;
import javafx.util.Duration;

public class JFXCheckBoxOldSkin
extends CheckBoxSkin {
    private final StackPane box = new StackPane();
    private double lineThick = 2.0;
    private double padding = 10.0;
    private double boxWidth;
    private double maxHeight;
    private double boxHeight;
    private final JFXRippler rippler;
    private Line rightLine;
    private Line leftLine;
    private final AnchorPane container = new AnchorPane();
    private double labelOffset = 0.0;
    private Transition transition;
    private boolean invalid = true;

    public JFXCheckBoxOldSkin(JFXCheckBox jFXCheckBox) {
        super((CheckBox)jFXCheckBox);
        this.box.setMinSize(20.0, 20.0);
        this.box.setPrefSize(20.0, 20.0);
        this.box.setMaxSize(20.0, 20.0);
        this.box.setBorder(new Border(new BorderStroke[]{new BorderStroke(jFXCheckBox.getUnCheckedColor(), BorderStrokeStyle.SOLID, new CornerRadii(0.0), new BorderWidths(this.lineThick))}));
        StackPane stackPane = new StackPane();
        stackPane.getChildren().add((Object)this.box);
        stackPane.setPadding(new Insets(this.padding));
        this.rippler = new JFXRippler((Node)stackPane, JFXRippler.RipplerMask.CIRCLE);
        this.rippler.setRipplerFill(((CheckBox)this.getSkinnable()).isSelected() ? jFXCheckBox.getUnCheckedColor() : jFXCheckBox.getCheckedColor());
        this.rightLine = new Line();
        this.leftLine = new Line();
        this.rightLine.setStroke(jFXCheckBox.getCheckedColor());
        this.rightLine.setStrokeWidth(this.lineThick);
        this.leftLine.setStroke(jFXCheckBox.getCheckedColor());
        this.leftLine.setStrokeWidth(this.lineThick);
        this.rightLine.setVisible(false);
        this.leftLine.setVisible(false);
        this.container.getChildren().add((Object)this.rightLine);
        this.container.getChildren().add((Object)this.leftLine);
        this.container.getChildren().add((Object)this.rippler);
        AnchorPane.setRightAnchor((Node)this.rippler, (Double)this.labelOffset);
        ((CheckBox)this.getSkinnable()).selectedProperty().addListener((observableValue, bl2, bl3) -> {
            this.rippler.setRipplerFill(bl3 != false ? jFXCheckBox.getUnCheckedColor() : jFXCheckBox.getCheckedColor());
            this.transition.setRate(bl3 != false ? 1.0 : -1.0);
            this.transition.play();
        });
        this.updateChildren();
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.container != null) {
            this.getChildren().remove(1);
            this.getChildren().add((Object)this.container);
        }
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return super.computePrefWidth(d2, d3, d4, d5, d6) + this.snapSize(this.box.minWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return super.computePrefWidth(d2, d3, d4, d5, d6) + this.snapSize(this.box.prefWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        CheckBox checkBox = (CheckBox)this.getSkinnable();
        this.boxWidth = this.snapSize(this.container.prefWidth(-1.0));
        this.boxHeight = this.snapSize(this.container.prefHeight(-1.0));
        double d6 = Math.max(checkBox.prefWidth(-1.0), checkBox.minWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
        double d7 = Math.min(d6 - this.boxWidth, d4 - this.snapSize(this.boxWidth)) + this.labelOffset + 2.0 * this.padding;
        double d8 = Math.min(checkBox.prefHeight(d7), d5);
        this.maxHeight = Math.max(this.boxHeight, d8);
        double d9 = JFXCheckBoxOldSkin.computeXOffset(d4, d7 + this.boxWidth, checkBox.getAlignment().getHpos()) + d2;
        double d10 = JFXCheckBoxOldSkin.computeYOffset(d5, this.maxHeight, checkBox.getAlignment().getVpos()) + d2;
        if (this.invalid) {
            this.rightLine.setStartX((this.boxWidth + this.padding - this.labelOffset) / 2.0 - this.boxWidth / 5.5);
            this.rightLine.setStartY(this.maxHeight - this.padding - this.lineThick);
            this.rightLine.setEndX((this.boxWidth + this.padding - this.labelOffset) / 2.0 - this.boxWidth / 5.5);
            this.rightLine.setEndY(this.maxHeight - this.padding - this.lineThick);
            this.leftLine.setStartX((this.boxWidth + this.padding - this.labelOffset) / 2.0 - this.boxWidth / 5.5);
            this.leftLine.setStartY(this.maxHeight - this.padding - this.lineThick);
            this.leftLine.setEndX((this.boxWidth + this.padding - this.labelOffset) / 2.0 - this.boxWidth / 5.5);
            this.leftLine.setEndY(this.maxHeight - this.padding - this.lineThick);
            this.transition = new CheckBoxTransition();
            if (((CheckBox)this.getSkinnable()).isSelected()) {
                this.transition.play();
            }
            this.invalid = false;
        }
        this.layoutLabelInArea(d9 + this.boxWidth, d10, d7, this.maxHeight, checkBox.getAlignment());
        this.container.resize(this.boxWidth, this.boxHeight);
        this.positionInArea((Node)this.container, d9, d10, this.boxWidth, this.maxHeight, 0.0, checkBox.getAlignment().getHpos(), checkBox.getAlignment().getVpos());
    }

    static double computeXOffset(double d2, double d3, HPos hPos) {
        switch (hPos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (d2 - d3) / 2.0;
            }
            case RIGHT: {
                return d2 - d3;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double d2, double d3, VPos vPos) {
        switch (vPos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (d2 - d3) / 2.0;
            }
            case BOTTOM: {
                return d2 - d3;
            }
        }
        return 0.0;
    }

    private class CheckBoxTransition
    extends CachedTransition {
        public CheckBoxTransition() {
            super((Node)JFXCheckBoxOldSkin.this.box, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.rightLine.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.leftLine.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.rotateProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.translateYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.rightLine.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.leftLine.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.rightLine.endXProperty(), (Object)((JFXCheckBoxOldSkin.this.boxWidth + JFXCheckBoxOldSkin.this.padding - JFXCheckBoxOldSkin.this.labelOffset) / 2.0 - JFXCheckBoxOldSkin.this.boxWidth / 5.5), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.rightLine.endYProperty(), (Object)(JFXCheckBoxOldSkin.this.maxHeight - JFXCheckBoxOldSkin.this.padding - 2.0 * JFXCheckBoxOldSkin.this.lineThick), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.leftLine.endXProperty(), (Object)((JFXCheckBoxOldSkin.this.boxWidth + JFXCheckBoxOldSkin.this.padding - JFXCheckBoxOldSkin.this.labelOffset) / 2.0 - JFXCheckBoxOldSkin.this.boxWidth / 5.5), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.leftLine.endYProperty(), (Object)(JFXCheckBoxOldSkin.this.maxHeight - JFXCheckBoxOldSkin.this.padding - 2.0 * JFXCheckBoxOldSkin.this.lineThick), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.rotateProperty(), (Object)44, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.scaleXProperty(), (Object)0.3, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.scaleYProperty(), (Object)0.4, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.translateYProperty(), (Object)(JFXCheckBoxOldSkin.this.boxHeight / 12.0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.translateXProperty(), (Object)(-JFXCheckBoxOldSkin.this.boxWidth / 12.0), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.box.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)800.0), new KeyValue[]{new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.rightLine.endXProperty(), (Object)(JFXCheckBoxOldSkin.this.boxWidth - JFXCheckBoxOldSkin.this.padding - JFXCheckBoxOldSkin.this.labelOffset + JFXCheckBoxOldSkin.this.lineThick / 2.0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.rightLine.endYProperty(), (Object)((JFXCheckBoxOldSkin.this.maxHeight - JFXCheckBoxOldSkin.this.padding) / 2.4), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.leftLine.endXProperty(), (Object)(JFXCheckBoxOldSkin.this.padding + JFXCheckBoxOldSkin.this.lineThick / 4.0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXCheckBoxOldSkin.this.leftLine.endYProperty(), (Object)((JFXCheckBoxOldSkin.this.maxHeight - JFXCheckBoxOldSkin.this.padding) / 1.4), Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }
}

