/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.transitions.CachedTransition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.BoundingBox;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class JFXMasonryPane
extends Pane {
    private boolean performingLayout = false;
    private int[][] matrix;
    private HashMap<Region, Transition> animationMap = null;
    private ParallelTransition trans = new ParallelTransition();
    private HashMap<Node, BoundingBox> boundingBoxes = new HashMap();
    private boolean dirtyBoxes = false;
    private final ListChangeListener<Node> childrenListener = change -> {
        if (change.next()) {
            this.dirtyBoxes = true;
            if (this.animationMap != null) {
                for (Node node : change.getRemoved()) {
                    this.animationMap.remove(node);
                }
            }
        }
        this.clearLayout();
        this.requestLayout();
    };
    private ObjectProperty<LayoutMode> layoutMode = new SimpleObjectProperty((Object)LayoutMode.MASONRY);
    private DoubleProperty cellWidth = new SimpleDoubleProperty(70.0){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };
    private DoubleProperty cellHeight = new SimpleDoubleProperty(70.0){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };
    private DoubleProperty hSpacing = new SimpleDoubleProperty(5.0){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };
    private DoubleProperty vSpacing = new SimpleDoubleProperty(5.0){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };
    private IntegerProperty limitColumn = new SimpleIntegerProperty(-1){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };
    private IntegerProperty limitRow = new SimpleIntegerProperty(100){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };

    public JFXMasonryPane() {
        this.getChildren().addListener((ListChangeListener)new WeakListChangeListener(this.childrenListener));
    }

    protected double computePrefWidth(double d2) {
        return this.snappedLeftInset() + this.getCellWidth() + this.snappedRightInset() + 2.0 * this.getHSpacing();
    }

    protected void layoutChildren() {
        this.performingLayout = true;
        int n2 = (int)Math.floor((this.getWidth() + this.getHSpacing() - this.snappedLeftInset() - this.snappedRightInset()) / (this.getCellWidth() + this.getHSpacing()));
        int n3 = n2 = this.getLimitColumn() != -1 && n2 > this.getLimitColumn() ? this.getLimitColumn() : n2;
        if (this.matrix != null && n2 == this.matrix[0].length) {
            this.performingLayout = false;
            return;
        }
        int n4 = this.getLimitRow();
        this.matrix = new int[n4][n2];
        double d2 = -1.0;
        double d3 = -1.0;
        List list = this.getManagedChildren();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2) instanceof Region) continue;
            list.remove(i2);
            --i2;
        }
        List<BoundingBox> list2 = ((LayoutMode)this.layoutMode.get()).fillGrid(this.matrix, list, this.getCellWidth(), this.getCellHeight(), n4, n2, this.getHSpacing(), this.getVSpacing());
        if (list2 == null) {
            this.performingLayout = false;
            return;
        }
        HashMap<Node, BoundingBox> hashMap = this.boundingBoxes;
        if (this.dirtyBoxes) {
            this.boundingBoxes = new HashMap();
        }
        for (int i3 = 0; i3 < list.size() && i3 < list2.size(); ++i3) {
            double d4;
            double d5;
            double d6;
            double d7;
            final Region region = (Region)list.get(i3);
            BoundingBox boundingBox = list2.get(i3);
            if (region instanceof GridPane) continue;
            if (boundingBox != null) {
                d7 = boundingBox.getMinY() * this.getCellWidth() + boundingBox.getMinY() * this.getHSpacing() + this.snappedLeftInset();
                d6 = boundingBox.getMinX() * this.getCellHeight() + boundingBox.getMinX() * this.getVSpacing() + this.snappedTopInset();
                d5 = boundingBox.getWidth() * this.getCellWidth() + (boundingBox.getWidth() - 1.0) * this.getHSpacing();
                d4 = boundingBox.getHeight() * this.getCellHeight() + (boundingBox.getHeight() - 1.0) * this.getVSpacing();
            } else {
                d7 = region.getLayoutX();
                d6 = region.getLayoutY();
                d5 = -1.0;
                d4 = -1.0;
            }
            if (this.animationMap == null) {
                region.setPrefSize(d5, d4);
                region.resizeRelocate(d7, d6, d5, d4);
            } else {
                KeyFrame keyFrame;
                BoundingBox boundingBox2 = hashMap.get(region);
                if (boundingBox2 == null || !boundingBox2.equals((Object)boundingBox) && this.dirtyBoxes) {
                    region.setOpacity(0.0);
                    region.setPrefSize(d5, d4);
                    region.resizeRelocate(d7, d6, d5, d4);
                }
                if (boundingBox != null) {
                    if (region.getWidth() != d5 || region.getHeight() != d4) {
                        region.setOpacity(0.0);
                        region.setPrefSize(d5, d4);
                        region.resizeRelocate(d7, d6, d5, d4);
                    }
                    keyFrame = new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{new KeyValue((WritableValue)region.opacityProperty(), (Object)1, Interpolator.LINEAR), new KeyValue((WritableValue)region.layoutXProperty(), (Object)d7, Interpolator.LINEAR), new KeyValue((WritableValue)region.layoutYProperty(), (Object)d6, Interpolator.LINEAR)});
                    this.animationMap.put(region, new CachedTransition((Node)region, new Timeline(new KeyFrame[]{keyFrame})){
                        {
                            super(node, timeline);
                            this.setCycleDuration(Duration.seconds((double)0.32));
                            this.setDelay(Duration.seconds((double)0.0));
                            this.setOnFinished(actionEvent -> {
                                region.setLayoutX(d7);
                                region.setLayoutY(d6);
                                region.setOpacity(1.0);
                            });
                        }
                    });
                } else {
                    keyFrame = new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{new KeyValue((WritableValue)region.opacityProperty(), (Object)0, Interpolator.LINEAR), new KeyValue((WritableValue)region.layoutXProperty(), (Object)d7, Interpolator.LINEAR), new KeyValue((WritableValue)region.layoutYProperty(), (Object)d6, Interpolator.LINEAR)});
                    this.animationMap.put(region, new CachedTransition((Node)region, new Timeline(new KeyFrame[]{keyFrame})){
                        {
                            super(node, timeline);
                            this.setCycleDuration(Duration.seconds((double)0.32));
                            this.setDelay(Duration.seconds((double)0.0));
                            this.setOnFinished(actionEvent -> {
                                region.setLayoutX(d7);
                                region.setLayoutY(d6);
                                region.setOpacity(0.0);
                            });
                        }
                    });
                }
            }
            this.boundingBoxes.put((Node)region, boundingBox);
            if (boundingBox == null) continue;
            if (d7 + d5 > d2) {
                d2 = d7 + d5;
            }
            if (!(d6 + d4 > d3)) continue;
            d3 = d6 + d4;
        }
        if (d3 != -1.0) {
            this.setPrefHeight(d3 += this.snappedBottomInset());
        }
        if (this.animationMap == null) {
            this.animationMap = new HashMap();
        }
        this.trans.stop();
        ParallelTransition parallelTransition = new ParallelTransition();
        parallelTransition.getChildren().addAll(this.animationMap.values());
        parallelTransition.play();
        this.trans = parallelTransition;
        this.dirtyBoxes = false;
        this.performingLayout = false;
    }

    public void requestLayout() {
        if (this.performingLayout) {
            return;
        }
        super.requestLayout();
    }

    public final void clearLayout() {
        this.matrix = null;
    }

    public final ObjectProperty<LayoutMode> layoutModeProperty() {
        return this.layoutMode;
    }

    public final LayoutMode getLayoutMode() {
        return (LayoutMode)this.layoutModeProperty().get();
    }

    public final void setLayoutMode(LayoutMode layoutMode) {
        this.layoutModeProperty().set((Object)layoutMode);
    }

    public final DoubleProperty cellWidthProperty() {
        return this.cellWidth;
    }

    public final double getCellWidth() {
        return this.cellWidthProperty().get();
    }

    public final void setCellWidth(double d2) {
        this.cellWidthProperty().set(d2);
    }

    public final DoubleProperty cellHeightProperty() {
        return this.cellHeight;
    }

    public final double getCellHeight() {
        return this.cellHeightProperty().get();
    }

    public final void setCellHeight(double d2) {
        this.cellHeightProperty().set(d2);
    }

    public final DoubleProperty hSpacingProperty() {
        return this.hSpacing;
    }

    public final double getHSpacing() {
        return this.hSpacingProperty().get();
    }

    public final void setHSpacing(double d2) {
        this.hSpacingProperty().set(d2);
    }

    public final DoubleProperty vSpacingProperty() {
        return this.vSpacing;
    }

    public final double getVSpacing() {
        return this.vSpacingProperty().get();
    }

    public final void setVSpacing(double d2) {
        this.vSpacingProperty().set(d2);
    }

    public final IntegerProperty limitColumnProperty() {
        return this.limitColumn;
    }

    public final int getLimitColumn() {
        return this.limitColumnProperty().get();
    }

    public final void setLimitColumn(int n2) {
        this.limitColumnProperty().set(n2);
    }

    public final IntegerProperty limitRowProperty() {
        return this.limitRow;
    }

    public final int getLimitRow() {
        return this.limitRowProperty().get();
    }

    public final void setLimitRow(int n2) {
        this.limitRowProperty().set(n2);
    }

    private static class BinPackingLayout
    extends LayoutMode {
        private BinPackingLayout() {
        }

        @Override
        public List<BoundingBox> fillGrid(int[][] nArray, List<Region> list, double d2, double d3, int n2, int n3, double d4, double d5) {
            int n4 = nArray.length;
            if (n4 <= 0) {
                return null;
            }
            int n5 = nArray[0].length;
            ArrayList<BoundingBox> arrayList = new ArrayList<BoundingBox>();
            block0: for (int i2 = 0; i2 < list.size(); ++i2) {
                Region region = list.get(i2);
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n6 = arrayList.size();
                    for (int i4 = 0; i4 < n5; ++i4) {
                        BoundingBox boundingBox;
                        if (nArray[i3][i4] != 0 || !this.validWidth(boundingBox = this.getFreeArea(nArray, i3, i4, region, d2, d3, n2, n3, d4, d5), region, d2, d4, d5) || !this.validHeight(boundingBox, region, d3, d4, d5)) continue;
                        nArray = this.fillMatrix(nArray, i2 + 1, boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getWidth(), boundingBox.getHeight());
                        arrayList.add(boundingBox);
                        break;
                    }
                    if (arrayList.size() != n6) continue block0;
                    if (i3 != n4 - 1) continue;
                    arrayList.add(null);
                }
            }
            return arrayList;
        }
    }

    private static class MasonryLayout
    extends LayoutMode {
        private MasonryLayout() {
        }

        @Override
        public List<BoundingBox> fillGrid(int[][] nArray, List<Region> list, double d2, double d3, int n2, int n3, double d4, double d5) {
            int n4 = nArray.length;
            if (n4 <= 0) {
                return null;
            }
            int n5 = nArray[0].length;
            ArrayList<BoundingBox> arrayList = new ArrayList<BoundingBox>();
            block0: for (int i2 = 0; i2 < list.size(); ++i2) {
                Region region = list.get(i2);
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n6 = arrayList.size();
                    for (int i4 = 0; i4 < n5; ++i4) {
                        BoundingBox boundingBox;
                        if (nArray[i3][i4] != 0) continue;
                        boolean bl2 = true;
                        for (int i5 = i3 + 1; i5 < n4; ++i5) {
                            if (nArray[i5][i4] == 0) continue;
                            bl2 = false;
                            break;
                        }
                        if (!bl2 || !this.validWidth(boundingBox = this.getFreeArea(nArray, i3, i4, region, d2, d3, n2, n3, d4, d5), region, d2, d4, d5) || !this.validHeight(boundingBox, region, d3, d4, d5)) continue;
                        nArray = this.fillMatrix(nArray, i2 + 1, boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getWidth(), boundingBox.getHeight());
                        arrayList.add(boundingBox);
                        break;
                    }
                    if (arrayList.size() != n6) continue block0;
                    if (i3 != n4 - 1) continue;
                    arrayList.add(null);
                }
            }
            return arrayList;
        }
    }

    public static abstract class LayoutMode {
        public static final MasonryLayout MASONRY = new MasonryLayout();
        public static final BinPackingLayout BIN_PACKING = new BinPackingLayout();

        protected abstract List<BoundingBox> fillGrid(int[][] var1, List<Region> var2, double var3, double var5, int var7, int var8, double var9, double var11);

        protected BoundingBox getFreeArea(int[][] nArray, int n2, int n3, Region region, double d2, double d3, int n4, int n5, double d4, double d5) {
            int n6;
            int n7;
            double d6 = this.getBLockHeight(region);
            double d7 = this.getBLockWidth(region);
            int n8 = (int)Math.ceil(d6 / (d3 + d5));
            if (d3 * (double)n8 + (double)((n8 - 1) * 2) * d5 < d6) {
                ++n8;
            }
            int n9 = Math.min(n2 + n8, n4);
            int n10 = (int)Math.ceil(d7 / (d2 + d4));
            if (d2 * (double)n10 + (double)((n10 - 1) * 2) * d4 < d7) {
                ++n10;
            }
            int n11 = Math.min(n3 + n10, n5);
            int n12 = n9;
            int n13 = n11;
            for (n7 = n2; n7 < n12; ++n7) {
                for (n6 = n3; n6 < n11; ++n6) {
                    if (nArray[n7][n6] == 0 || n3 >= n6 || n6 >= n13) continue;
                    n13 = n6;
                }
            }
            for (n7 = n2; n7 < n9; ++n7) {
                for (n6 = n3; n6 < n13; ++n6) {
                    if (nArray[n7][n6] == 0 || n2 >= n7 || n7 >= n12) continue;
                    n12 = n7;
                }
            }
            return new BoundingBox((double)n2, (double)n3, (double)(n13 - n3), (double)(n12 - n2));
        }

        protected double getBLockWidth(Region region) {
            if (region.getMinWidth() != -1.0) {
                return region.getMinWidth();
            }
            if (region.getPrefWidth() != -1.0) {
                return region.getPrefWidth();
            }
            return region.prefWidth(-1.0);
        }

        protected double getBLockHeight(Region region) {
            if (region.getMinHeight() != -1.0) {
                return region.getMinHeight();
            }
            if (region.getPrefHeight() != -1.0) {
                return region.getPrefHeight();
            }
            return region.prefHeight(this.getBLockWidth(region));
        }

        protected boolean validWidth(BoundingBox boundingBox, Region region, double d2, double d3, double d4) {
            boolean bl2 = false;
            if (region.getMinWidth() != -1.0 && boundingBox.getWidth() * d2 + (boundingBox.getWidth() - 1.0) * 2.0 * d3 < region.getMinWidth()) {
                return false;
            }
            if (region.getPrefWidth() == -1.0 && boundingBox.getWidth() * d2 + (boundingBox.getWidth() - 1.0) * 2.0 * d3 >= region.prefWidth(-1.0)) {
                bl2 = true;
            }
            if (region.getPrefWidth() != -1.0 && boundingBox.getWidth() * d2 + (boundingBox.getWidth() - 1.0) * 2.0 * d3 >= region.getPrefWidth()) {
                bl2 = true;
            }
            return bl2;
        }

        protected boolean validHeight(BoundingBox boundingBox, Region region, double d2, double d3, double d4) {
            boolean bl2 = false;
            if (region.getMinHeight() != -1.0 && boundingBox.getHeight() * d2 + (boundingBox.getHeight() - 1.0) * 2.0 * d4 < region.getMinHeight()) {
                return false;
            }
            if (region.getPrefHeight() == -1.0 && boundingBox.getHeight() * d2 + (boundingBox.getHeight() - 1.0) * 2.0 * d4 >= region.prefHeight(region.prefWidth(-1.0))) {
                bl2 = true;
            }
            if (region.getPrefHeight() != -1.0 && boundingBox.getHeight() * d2 + (boundingBox.getHeight() - 1.0) * 2.0 * d4 >= region.getPrefHeight()) {
                bl2 = true;
            }
            return bl2;
        }

        protected int[][] fillMatrix(int[][] nArray, int n2, double d2, double d3, double d4, double d5) {
            int n3 = (int)d2;
            while ((double)n3 < d2 + d5) {
                int n4 = (int)d3;
                while ((double)n4 < d3 + d4) {
                    nArray[n3][n4] = n2;
                    ++n4;
                }
                ++n3;
            }
            return nArray;
        }
    }
}

