/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.httpclient.jdk;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.httpclient.jdk.JDKHttpFuture;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class JDKHttpClient
implements HttpClient {
    private final JDKHttpClientConfig config;

    public JDKHttpClient() {
        this(JDKHttpClientConfig.defaultConfig());
    }

    public JDKHttpClient(JDKHttpClientConfig jDKHttpClientConfig) {
        this.config = jDKHttpClientConfig;
    }

    @Override
    public void close() {
    }

    @Override
    public <T> Future<T> executeAsync(String string, Map<String, String> map, Verb verb, String string2, byte[] byArray, OAuthAsyncRequestCallback<T> oAuthAsyncRequestCallback, OAuthRequest.ResponseConverter<T> responseConverter) {
        try {
            Response response;
            Response response2 = this.execute(string, map, verb, string2, byArray);
            Response response3 = response = responseConverter == null ? response2 : responseConverter.convert(response2);
            if (oAuthAsyncRequestCallback != null) {
                oAuthAsyncRequestCallback.onCompleted(response);
            }
            return new JDKHttpFuture<Response>(response);
        }
        catch (IOException | InterruptedException | ExecutionException exception) {
            oAuthAsyncRequestCallback.onThrowable(exception);
            return new JDKHttpFuture(exception);
        }
    }

    @Override
    public <T> Future<T> executeAsync(String string, Map<String, String> map, Verb verb, String string2, String string3, OAuthAsyncRequestCallback<T> oAuthAsyncRequestCallback, OAuthRequest.ResponseConverter<T> responseConverter) {
        try {
            Response response;
            Response response2 = this.execute(string, map, verb, string2, string3);
            Response response3 = response = responseConverter == null ? response2 : responseConverter.convert(response2);
            if (oAuthAsyncRequestCallback != null) {
                oAuthAsyncRequestCallback.onCompleted(response);
            }
            return new JDKHttpFuture<Response>(response);
        }
        catch (IOException | InterruptedException | ExecutionException exception) {
            if (oAuthAsyncRequestCallback != null) {
                oAuthAsyncRequestCallback.onThrowable(exception);
            }
            return new JDKHttpFuture(exception);
        }
    }

    @Override
    public <T> Future<T> executeAsync(String string, Map<String, String> map, Verb verb, String string2, File file, OAuthAsyncRequestCallback<T> oAuthAsyncRequestCallback, OAuthRequest.ResponseConverter<T> responseConverter) {
        throw new UnsupportedOperationException("JDKHttpClient do not support File payload for the moment");
    }

    @Override
    public Response execute(String string, Map<String, String> map, Verb verb, String string2, byte[] byArray) throws InterruptedException, ExecutionException, IOException {
        return this.doExecute(string, map, verb, string2, BodyType.BYTE_ARRAY, byArray);
    }

    @Override
    public Response execute(String string, Map<String, String> map, Verb verb, String string2, String string3) throws InterruptedException, ExecutionException, IOException {
        return this.doExecute(string, map, verb, string2, BodyType.STRING, string3);
    }

    @Override
    public Response execute(String string, Map<String, String> map, Verb verb, String string2, File file) throws InterruptedException, ExecutionException, IOException {
        throw new UnsupportedOperationException("JDKHttpClient do not support File payload for the moment");
    }

    private Response doExecute(String string, Map<String, String> map, Verb verb, String string2, BodyType bodyType, Object object) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
        httpURLConnection.setInstanceFollowRedirects(this.config.isFollowRedirects());
        httpURLConnection.setRequestMethod(verb.name());
        if (this.config.getConnectTimeout() != null) {
            httpURLConnection.setConnectTimeout(this.config.getConnectTimeout());
        }
        if (this.config.getReadTimeout() != null) {
            httpURLConnection.setReadTimeout(this.config.getReadTimeout());
        }
        JDKHttpClient.addHeaders(httpURLConnection, map, string);
        if (verb.isPermitBody()) {
            bodyType.setBody(httpURLConnection, object, verb.isRequiresBody());
        }
        try {
            httpURLConnection.connect();
            int n2 = httpURLConnection.getResponseCode();
            return new Response(n2, httpURLConnection.getResponseMessage(), JDKHttpClient.parseHeaders(httpURLConnection), n2 >= 200 && n2 < 400 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream());
        }
        catch (UnknownHostException unknownHostException) {
            throw new OAuthException("The IP address of a host could not be determined.", unknownHostException);
        }
    }

    private static Map<String, String> parseHeaders(HttpURLConnection httpURLConnection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue().get(0);
            if ("Content-Encoding".equalsIgnoreCase(string)) {
                hashMap.put("Content-Encoding", string2);
                continue;
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private static void addHeaders(HttpURLConnection httpURLConnection, Map<String, String> map, String string) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (string != null) {
            httpURLConnection.setRequestProperty("User-Agent", string);
        }
    }

    private static void addBody(HttpURLConnection httpURLConnection, byte[] byArray, boolean bl2) throws IOException {
        int n2 = byArray.length;
        if (bl2 || n2 > 0) {
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(n2));
            if (httpURLConnection.getRequestProperty("Content-Type") == null) {
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
            httpURLConnection.setDoOutput(true);
            httpURLConnection.getOutputStream().write(byArray);
        }
    }

    private static enum BodyType {
        BYTE_ARRAY{

            @Override
            void setBody(HttpURLConnection httpURLConnection, Object object, boolean bl2) throws IOException {
                JDKHttpClient.addBody(httpURLConnection, (byte[])object, bl2);
            }
        }
        ,
        STRING{

            @Override
            void setBody(HttpURLConnection httpURLConnection, Object object, boolean bl2) throws IOException {
                JDKHttpClient.addBody(httpURLConnection, ((String)object).getBytes(), bl2);
            }
        };


        abstract void setBody(HttpURLConnection var1, Object var2, boolean var3) throws IOException;
    }
}

