/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.yaml.PackageVersion;
import com.fasterxml.jackson.dataformat.yaml.UTF8Reader;
import com.fasterxml.jackson.dataformat.yaml.UTF8Writer;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.fasterxml.jackson.dataformat.yaml.util.StringQuotingChecker;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;

public class YAMLFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_YAML = "YAML";
    protected static final int DEFAULT_YAML_PARSER_FEATURE_FLAGS = YAMLParser.Feature.collectDefaults();
    protected static final int DEFAULT_YAML_GENERATOR_FEATURE_FLAGS = YAMLGenerator.Feature.collectDefaults();
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;
    protected int _yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
    protected int _yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
    protected final DumperOptions.Version _version;
    protected final StringQuotingChecker _quotingChecker;
    protected final LoaderOptions _loaderOptions;
    protected final DumperOptions _dumperOptions;

    public YAMLFactory() {
        this((ObjectCodec)null);
    }

    public YAMLFactory(ObjectCodec objectCodec) {
        super(objectCodec);
        this._yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
        this._yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
        this._version = null;
        this._quotingChecker = StringQuotingChecker.Default.instance();
        this._loaderOptions = null;
        this._dumperOptions = null;
    }

    public YAMLFactory(YAMLFactory yAMLFactory, ObjectCodec objectCodec) {
        super(yAMLFactory, objectCodec);
        this._yamlGeneratorFeatures = yAMLFactory._yamlGeneratorFeatures;
        this._yamlParserFeatures = yAMLFactory._yamlParserFeatures;
        this._version = yAMLFactory._version;
        this._quotingChecker = yAMLFactory._quotingChecker;
        this._loaderOptions = yAMLFactory._loaderOptions;
        this._dumperOptions = yAMLFactory._dumperOptions;
    }

    protected YAMLFactory(YAMLFactoryBuilder yAMLFactoryBuilder) {
        super(yAMLFactoryBuilder, false);
        this._yamlGeneratorFeatures = yAMLFactoryBuilder.formatGeneratorFeaturesMask();
        this._yamlParserFeatures = yAMLFactoryBuilder.formatParserFeaturesMask();
        this._version = yAMLFactoryBuilder.yamlVersionToWrite();
        this._quotingChecker = yAMLFactoryBuilder.stringQuotingChecker();
        this._loaderOptions = yAMLFactoryBuilder.loaderOptions();
        this._dumperOptions = yAMLFactoryBuilder.dumperOptions();
    }

    public YAMLFactoryBuilder rebuild() {
        return new YAMLFactoryBuilder(this);
    }

    public static YAMLFactoryBuilder builder() {
        return new YAMLFactoryBuilder();
    }

    @Override
    public YAMLFactory copy() {
        this._checkInvalidCopy(YAMLFactory.class);
        return new YAMLFactory(this, null);
    }

    @Override
    protected Object readResolve() {
        return new YAMLFactory(this, this._objectCodec);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean canUseCharArrays() {
        return false;
    }

    public Class<YAMLParser.Feature> getFormatReadFeatureType() {
        return YAMLParser.Feature.class;
    }

    public Class<YAMLGenerator.Feature> getFormatWriteFeatureType() {
        return YAMLGenerator.Feature.class;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_YAML;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor inputAccessor) throws IOException {
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by2 = inputAccessor.nextByte();
        if (by2 == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by2 = inputAccessor.nextByte();
        }
        if (by2 == 45 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 45 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 45) {
            return MatchStrength.FULL_MATCH;
        }
        return MatchStrength.INCONCLUSIVE;
    }

    public final YAMLFactory configure(YAMLGenerator.Feature feature, boolean bl2) {
        if (bl2) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public YAMLFactory enable(YAMLGenerator.Feature feature) {
        this._yamlGeneratorFeatures |= feature.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLGenerator.Feature feature) {
        this._yamlGeneratorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLGenerator.Feature feature) {
        return (this._yamlGeneratorFeatures & feature.getMask()) != 0;
    }

    @Override
    public int getFormatGeneratorFeatures() {
        return this._yamlGeneratorFeatures;
    }

    public final YAMLFactory configure(YAMLParser.Feature feature, boolean bl2) {
        if (bl2) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public YAMLFactory enable(YAMLParser.Feature feature) {
        this._yamlParserFeatures |= feature.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLParser.Feature feature) {
        this._yamlParserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLParser.Feature feature) {
        return (this._yamlParserFeatures & feature.getMask()) != 0;
    }

    @Override
    public int getFormatParserFeatures() {
        return this._yamlParserFeatures;
    }

    @Override
    public YAMLParser createParser(String string) throws IOException {
        return this.createParser(new StringReader(string));
    }

    @Override
    public YAMLParser createParser(File file) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(file), true);
        return this._createParser(this._decorate(new FileInputStream(file), iOContext), iOContext);
    }

    @Override
    public YAMLParser createParser(URL uRL) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(uRL), true);
        return this._createParser(this._decorate(this._optimizedStreamFromURL(uRL), iOContext), iOContext);
    }

    @Override
    public YAMLParser createParser(InputStream inputStream) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(inputStream), false);
        return this._createParser(this._decorate(inputStream, iOContext), iOContext);
    }

    @Override
    public YAMLParser createParser(Reader reader) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(reader), false);
        return this._createParser(this._decorate(reader, iOContext), iOContext);
    }

    @Override
    public YAMLParser createParser(char[] cArray) throws IOException {
        return this.createParser(cArray, 0, cArray.length);
    }

    @Override
    public YAMLParser createParser(char[] cArray, int n2, int n3) throws IOException {
        return this.createParser(new CharArrayReader(cArray, n2, n3));
    }

    @Override
    public YAMLParser createParser(byte[] byArray) throws IOException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(this._createContentReference(byArray), true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    @Override
    public YAMLParser createParser(byte[] byArray, int n2, int n3) throws IOException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(this._createContentReference(byArray, n2, n3), true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, n2, n3)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, n2, n3, iOContext);
    }

    @Override
    public YAMLGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(outputStream), false);
        iOContext.setEncoding(jsonEncoding);
        return this._createGenerator(this._createWriter(this._decorate(outputStream, iOContext), jsonEncoding, iOContext), iOContext);
    }

    @Override
    public YAMLGenerator createGenerator(OutputStream outputStream) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(outputStream), false);
        return this._createGenerator(this._createWriter(this._decorate(outputStream, iOContext), JsonEncoding.UTF8, iOContext), iOContext);
    }

    @Override
    public YAMLGenerator createGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(writer), false);
        return this._createGenerator(this._decorate(writer, iOContext), iOContext);
    }

    @Override
    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOContext iOContext = this._createContext(this._createContentReference(file), true);
        iOContext.setEncoding(jsonEncoding);
        return this._createGenerator(this._createWriter(this._decorate(fileOutputStream, iOContext), jsonEncoding, iOContext), iOContext);
    }

    @Override
    protected YAMLParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException {
        return new YAMLParser(iOContext, this._parserFeatures, this._yamlParserFeatures, this._loaderOptions, this._objectCodec, this._createReader(inputStream, null, iOContext));
    }

    @Override
    protected YAMLParser _createParser(Reader reader, IOContext iOContext) throws IOException {
        return new YAMLParser(iOContext, this._parserFeatures, this._yamlParserFeatures, this._loaderOptions, this._objectCodec, reader);
    }

    @Override
    protected YAMLParser _createParser(char[] cArray, int n2, int n3, IOContext iOContext, boolean bl2) throws IOException {
        return new YAMLParser(iOContext, this._parserFeatures, this._yamlParserFeatures, this._loaderOptions, this._objectCodec, (Reader)new CharArrayReader(cArray, n2, n3));
    }

    @Override
    protected YAMLParser _createParser(byte[] byArray, int n2, int n3, IOContext iOContext) throws IOException {
        return new YAMLParser(iOContext, this._parserFeatures, this._yamlParserFeatures, this._loaderOptions, this._objectCodec, this._createReader(byArray, n2, n3, null, iOContext));
    }

    @Override
    protected YAMLGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        int n2 = this._yamlGeneratorFeatures;
        if (this._dumperOptions == null) {
            return new YAMLGenerator(iOContext, this._generatorFeatures, n2, this._quotingChecker, this._objectCodec, writer, this._version);
        }
        return new YAMLGenerator(iOContext, this._generatorFeatures, n2, this._quotingChecker, this._objectCodec, writer, this._dumperOptions);
    }

    @Override
    protected YAMLGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected Reader _createReader(InputStream inputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == null) {
            jsonEncoding = JsonEncoding.UTF8;
        }
        if (jsonEncoding == JsonEncoding.UTF8) {
            boolean bl2 = iOContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(inputStream, bl2);
        }
        return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
    }

    protected Reader _createReader(byte[] byArray, int n2, int n3, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == null) {
            jsonEncoding = JsonEncoding.UTF8;
        }
        if (jsonEncoding == null || jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Reader(byArray, n2, n3, true);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, n3);
        return new InputStreamReader((InputStream)byteArrayInputStream, jsonEncoding.getJavaName());
    }
}

